/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.LocalFlagAffectedCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.read.SizeCommand;
import org.infinispan.commands.read.ValuesCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.container.EntryFactory;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.JmxStatsCommandInterceptor;
import org.infinispan.jmx.annotations.DisplayType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.jmx.annotations.Parameter;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.Metadatas;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.persistence.CollectionKeyFilter;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="CacheLoader", description="Component that handles loading entries from a CacheStore into memory.")
public class CacheLoaderInterceptor
extends JmxStatsCommandInterceptor {
    private final AtomicLong cacheLoads = new AtomicLong(0L);
    private final AtomicLong cacheMisses = new AtomicLong(0L);
    protected PersistenceManager persistenceManager;
    protected CacheNotifier notifier;
    protected volatile boolean enabled = true;
    private EntryFactory entryFactory;
    private TimeService timeService;
    private InternalEntryFactory iceFactory;
    private static final Log log = LogFactory.getLog(CacheLoaderInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    protected void injectDependencies(PersistenceManager clm, EntryFactory entryFactory, CacheNotifier notifier, TimeService timeService, InternalEntryFactory iceFactory) {
        this.persistenceManager = clm;
        this.notifier = notifier;
        this.entryFactory = entryFactory;
        this.timeService = timeService;
        this.iceFactory = iceFactory;
    }

    @Override
    public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        Object key;
        if (this.enabled && (key = command.getKey()) != null) {
            this.loadIfNeeded(ctx, key, false, command);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object key;
        if (this.enabled && (key = command.getKey()) != null) {
            this.loadIfNeeded(ctx, key, false, command);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        Object key;
        if (this.enabled && (key = command.getKey()) != null) {
            this.loadIfNeededAndUpdateStats(ctx, key, true, command);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        Object[] keys;
        if (this.enabled && (keys = command.getKeys()) != null && keys.length > 0) {
            for (Object key : command.getKeys()) {
                this.loadIfNeeded(ctx, key, false, command);
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        Object key;
        if (this.enabled && (key = command.getKey()) != null) {
            this.loadIfNeededAndUpdateStats(ctx, key, false, command);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        Object key;
        if (this.enabled && (key = command.getKey()) != null) {
            this.loadIfNeededAndUpdateStats(ctx, key, false, command);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitSizeCommand(InvocationContext ctx, SizeCommand command) throws Throwable {
        int totalSize = 0;
        if (this.enabled && !this.shouldSkipCacheLoader(command)) {
            totalSize = this.persistenceManager.size();
        }
        if (this.cacheConfiguration.persistence().passivation() || totalSize == 0) {
            totalSize += ((Integer)super.visitSizeCommand(ctx, command)).intValue();
        }
        return totalSize;
    }

    @Override
    public Object visitKeySetCommand(InvocationContext ctx, KeySetCommand command) throws Throwable {
        Object keys = super.visitKeySetCommand(ctx, command);
        if (this.enabled && !this.shouldSkipCacheLoader(command)) {
            final HashSet union = new HashSet((Set)keys);
            this.persistenceManager.processOnAllStores(new CollectionKeyFilter(union), new AdvancedCacheLoader.CacheLoaderTask(){

                public void processEntry(MarshalledEntry marshalledEntry, AdvancedCacheLoader.TaskContext taskContext) throws InterruptedException {
                    union.add(marshalledEntry.getKey());
                }
            }, false, false);
            return Collections.unmodifiableSet(union);
        }
        return keys;
    }

    @Override
    public Object visitEntrySetCommand(InvocationContext ctx, EntrySetCommand command) throws Throwable {
        Object entrySet = super.visitEntrySetCommand(ctx, command);
        if (this.enabled && !this.shouldSkipCacheLoader(command)) {
            final HashSet union = new HashSet();
            final HashSet<Object> processedKeys = new HashSet<Object>();
            for (InternalCacheEntry ice : (Set)entrySet) {
                processedKeys.add(ice.getKey());
            }
            this.persistenceManager.processOnAllStores(new CollectionKeyFilter(processedKeys), new AdvancedCacheLoader.CacheLoaderTask(){

                public void processEntry(MarshalledEntry marshalledEntry, AdvancedCacheLoader.TaskContext taskContext) throws InterruptedException {
                    processedKeys.add(marshalledEntry.getKey());
                    union.add(CacheLoaderInterceptor.this.iceFactory.create(marshalledEntry.getKey(), marshalledEntry.getValue(), marshalledEntry.getMetadata()));
                }
            }, true, true);
            union.addAll((Set)entrySet);
            return Collections.unmodifiableSet(union);
        }
        return entrySet;
    }

    @Override
    public Object visitValuesCommand(InvocationContext ctx, ValuesCommand command) throws Throwable {
        Object values = super.visitValuesCommand(ctx, command);
        if (this.enabled && !this.shouldSkipCacheLoader(command)) {
            final HashSet processedKeys = new HashSet();
            final ArrayList result = new ArrayList();
            this.persistenceManager.processOnAllStores(new CollectionKeyFilter(processedKeys), new AdvancedCacheLoader.CacheLoaderTask(){

                public void processEntry(MarshalledEntry marshalledEntry, AdvancedCacheLoader.TaskContext taskContext) throws InterruptedException {
                    processedKeys.add(marshalledEntry.getKey());
                    result.add(marshalledEntry.getValue());
                }
            }, true, false);
            result.addAll((Collection)values);
            return Collections.unmodifiableList(result);
        }
        return values;
    }

    protected boolean forceLoad(Object key, Set<Flag> flags) {
        return false;
    }

    protected boolean isDeltaWrite(Set<Flag> flags) {
        return flags != null && flags.contains((Object)Flag.DELTA_WRITE);
    }

    private boolean shouldSkipCacheLoader(LocalFlagAffectedCommand cmd) {
        return cmd.hasFlag(Flag.SKIP_CACHE_STORE) || cmd.hasFlag(Flag.SKIP_CACHE_LOAD);
    }

    protected boolean canLoad(Object key) {
        return true;
    }

    private Boolean loadIfNeeded(InvocationContext ctx, Object key, boolean isRetrieval, FlagAffectedCommand cmd) throws Throwable {
        if (this.shouldSkipCacheLoader(cmd) || cmd.hasFlag(Flag.IGNORE_RETURN_VALUES) || !this.canLoad(key)) {
            return null;
        }
        if (!(isRetrieval || ctx.isOriginLocal() || this.forceLoad(key, cmd.getFlags()))) {
            return null;
        }
        CacheEntry e = ctx.lookupEntry(key);
        if (e == null || e.isNull() || e.getValue() == null) {
            CacheEntry wrappedEntry;
            MarshalledEntry loaded = this.persistenceManager.loadFromAllStores(key);
            if (loaded == null) {
                return Boolean.FALSE;
            }
            InternalMetadata metadata = loaded.getMetadata();
            if (metadata != null && metadata.isExpired(this.timeService.wallClockTime())) {
                return Boolean.FALSE;
            }
            InternalCacheEntry ice = this.iceFactory.create(loaded.getKey(), loaded.getValue(), metadata);
            if (cmd instanceof ApplyDeltaCommand) {
                ctx.putLookedUpEntry(key, ice);
                wrappedEntry = this.entryFactory.wrapEntryForDelta(ctx, key, ((ApplyDeltaCommand)cmd).getDelta());
            } else {
                wrappedEntry = this.entryFactory.wrapEntryForPut(ctx, key, ice, false, cmd, false);
            }
            this.recordLoadedEntry(ctx, key, wrappedEntry, ice, cmd);
            return Boolean.TRUE;
        }
        return null;
    }

    private void recordLoadedEntry(InvocationContext ctx, Object key, CacheEntry entry, InternalCacheEntry loadedEntry, FlagAffectedCommand cmd) throws Exception {
        boolean entryExists;
        boolean bl = entryExists = loadedEntry != null;
        if (log.isTraceEnabled()) {
            log.trace("Entry exists in loader? " + entryExists);
        }
        if (this.getStatisticsEnabled()) {
            if (entryExists) {
                this.cacheLoads.incrementAndGet();
            } else {
                this.cacheMisses.incrementAndGet();
            }
        }
        if (entryExists) {
            Object value = loadedEntry.getValue();
            this.sendNotification(key, value, true, ctx, cmd);
            entry.setValue(value);
            Metadata metadata = cmd.getMetadata();
            Metadata loadedMetadata = loadedEntry.getMetadata();
            if (metadata != null && loadedMetadata != null) {
                metadata = Metadatas.applyVersion(loadedMetadata, metadata);
            } else if (metadata == null) {
                metadata = loadedMetadata;
            }
            entry.setMetadata(metadata);
            entry.setValid(true);
            entry.setLoaded(true);
            this.sendNotification(key, value, false, ctx, cmd);
        }
    }

    protected void sendNotification(Object key, Object value, boolean pre, InvocationContext ctx, FlagAffectedCommand cmd) {
        this.notifier.notifyCacheEntryLoaded(key, value, pre, ctx, cmd);
    }

    private void loadIfNeededAndUpdateStats(InvocationContext ctx, Object key, boolean isRetrieval, FlagAffectedCommand cmd) throws Throwable {
        Boolean found = this.loadIfNeeded(ctx, key, isRetrieval, cmd);
        if (found == Boolean.FALSE && this.getStatisticsEnabled()) {
            this.cacheMisses.incrementAndGet();
        }
    }

    @ManagedAttribute(description="Number of entries loaded from cache store", displayName="Number of cache store loads", measurementType=MeasurementType.TRENDSUP)
    public long getCacheLoaderLoads() {
        return this.cacheLoads.get();
    }

    @ManagedAttribute(description="Number of entries that did not exist in cache store", displayName="Number of cache store load misses", measurementType=MeasurementType.TRENDSUP)
    public long getCacheLoaderMisses() {
        return this.cacheMisses.get();
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset Statistics")
    public void resetStatistics() {
        this.cacheLoads.set(0L);
        this.cacheMisses.set(0L);
    }

    @ManagedAttribute(description="Returns a collection of cache loader types which configured and enabled", displayName="Returns a collection of cache loader types which configured and enabled", displayType=DisplayType.DETAIL)
    public Collection<String> getStores() {
        if (this.enabled && this.cacheConfiguration.persistence().usingStores()) {
            return this.persistenceManager.getStoresAsString();
        }
        return InfinispanCollections.emptySet();
    }

    @ManagedOperation(description="Disable all stores of a given type, where type is a fully qualified class name of the cache loader to disable", displayName="Disable all stores of a given type")
    public void disableStore(@Parameter(name="storeType", description="Fully qualified class name of a store implementation") String storeType) {
        if (this.enabled) {
            this.persistenceManager.disableStore(storeType);
        }
    }

    public void disableInterceptor() {
        this.enabled = false;
    }
}

