/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.equivalence.EquivalentLinkedHashMap;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferFactory;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.configuration.cache.SingleFileStoreConfiguration;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.CacheLoaderException;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.TaskContextImpl;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class SingleFileStore
implements AdvancedLoadWriteStore {
    private static final Log log = LogFactory.getLog(SingleFileStore.class);
    private static final byte[] MAGIC = new byte[]{70, 67, 83, 49};
    private static final byte[] ZERO_INT = new byte[]{0, 0, 0, 0};
    private static final int KEYLEN_POS = 4;
    private static final int KEY_POS = 24;
    private SingleFileStoreConfiguration configuration;
    protected InitializationContext ctx;
    private FileChannel file;
    private Map<Object, FileEntry> entries;
    private SortedSet<FileEntry> freeList;
    private long filePos = MAGIC.length;

    @Override
    public void init(InitializationContext ctx) {
        this.ctx = ctx;
        this.configuration = (SingleFileStoreConfiguration)ctx.getConfiguration();
    }

    @Override
    public void start() {
        try {
            File dir;
            File f;
            String location = this.configuration.location();
            if (location == null || location.trim().length() == 0) {
                location = "Infinispan-SingleFileStore";
            }
            if (!((f = new File(location + File.separator + this.ctx.getCache().getName() + ".dat")).exists() || (dir = f.getParentFile()).exists() || dir.mkdirs())) {
                throw log.directoryCannotBeCreated(dir.getAbsolutePath());
            }
            this.file = new RandomAccessFile(f, "rw").getChannel();
            this.entries = this.newEntryMap();
            this.freeList = Collections.synchronizedSortedSet(new TreeSet());
            byte[] header = new byte[MAGIC.length];
            if (this.file.read(java.nio.ByteBuffer.wrap(header), 0L) == MAGIC.length && Arrays.equals(MAGIC, header)) {
                this.rebuildIndex();
            } else {
                this.clear();
            }
        }
        catch (Exception e) {
            throw new CacheLoaderException(e);
        }
    }

    private Map<Object, FileEntry> newEntryMap() {
        Equivalence keyEq = this.ctx.getCache().getCacheConfiguration().dataContainer().keyEquivalence();
        Map entryMap = this.configuration.maxEntries() > 0 ? CollectionFactory.makeLinkedMap((int)16, (float)0.75f, (EquivalentLinkedHashMap.IterationOrder)EquivalentLinkedHashMap.IterationOrder.ACCESS_ORDER, keyEq, (Equivalence)AnyEquivalence.getInstance()) : CollectionFactory.makeMap(keyEq, (Equivalence)AnyEquivalence.getInstance());
        return Collections.synchronizedMap(entryMap);
    }

    @Override
    public void stop() {
        try {
            if (this.file != null) {
                this.file.close();
                this.file = null;
                this.entries = null;
                this.freeList = null;
                this.filePos = MAGIC.length;
            }
        }
        catch (Exception e) {
            throw new CacheLoaderException(e);
        }
    }

    private void rebuildIndex() throws Exception {
        java.nio.ByteBuffer buf = java.nio.ByteBuffer.allocate(24);
        while (true) {
            buf.clear().limit(24);
            this.file.read(buf, this.filePos);
            if (buf.remaining() > 0) {
                return;
            }
            buf.flip();
            FileEntry fe = new FileEntry(this.filePos, buf.getInt());
            fe.keyLen = buf.getInt();
            fe.dataLen = buf.getInt();
            fe.metadataLen = buf.getInt();
            fe.expiryTime = buf.getLong();
            this.filePos += (long)fe.size;
            if (fe.keyLen > 0) {
                if (buf.capacity() < fe.keyLen) {
                    buf = java.nio.ByteBuffer.allocate(fe.keyLen);
                }
                buf.clear().limit(fe.keyLen);
                this.file.read(buf, fe.offset + 24L);
                Object key = this.ctx.getMarshaller().objectFromByteBuffer(buf.array(), 0, fe.keyLen);
                this.entries.put(key, fe);
                continue;
            }
            this.freeList.add(fe);
        }
    }

    @Override
    public boolean contains(Object key) {
        return this.entries.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileEntry allocate(int len) {
        SortedSet<FileEntry> sortedSet = this.freeList;
        synchronized (sortedSet) {
            SortedSet<FileEntry> candidates = this.freeList.tailSet(new FileEntry(0L, len));
            Iterator it = candidates.iterator();
            while (it.hasNext()) {
                FileEntry free = (FileEntry)it.next();
                if (free.isLocked()) continue;
                it.remove();
                return free;
            }
            FileEntry fe = new FileEntry(this.filePos, len);
            this.filePos += (long)len;
            return fe;
        }
    }

    private void free(FileEntry fe) throws IOException {
        if (fe != null) {
            this.file.write(java.nio.ByteBuffer.wrap(ZERO_INT), fe.offset + 4L);
            this.freeList.add(fe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(MarshalledEntry marshalledEntry) {
        try {
            ByteBuffer key = marshalledEntry.getKeyBytes();
            ByteBuffer data = marshalledEntry.getValueBytes();
            ByteBuffer metadata = marshalledEntry.getMetadataBytes();
            int metadataLength = metadata == null ? 0 : metadata.getLength();
            int len = 24 + key.getLength() + data.getLength() + metadataLength;
            FileEntry fe = this.allocate(len);
            try {
                fe.expiryTime = metadata != null ? marshalledEntry.getMetadata().expiryTime() : -1L;
                fe.keyLen = key.getLength();
                fe.dataLen = data.getLength();
                fe.metadataLen = metadataLength;
                java.nio.ByteBuffer buf = java.nio.ByteBuffer.allocate(len);
                buf.putInt(fe.size);
                buf.putInt(fe.keyLen);
                buf.putInt(fe.dataLen);
                buf.putInt(fe.metadataLen);
                buf.putLong(fe.expiryTime);
                buf.put(key.getBuf(), key.getOffset(), key.getLength());
                buf.put(data.getBuf(), data.getOffset(), data.getLength());
                if (metadata != null) {
                    buf.put(metadata.getBuf(), metadata.getOffset(), metadata.getLength());
                }
                buf.flip();
                this.file.write(buf, fe.offset);
                fe = this.entries.put(marshalledEntry.getKey(), fe);
                if (fe == null) {
                    fe = this.evict();
                }
            }
            finally {
                this.free(fe);
            }
        }
        catch (Exception e) {
            throw new CacheLoaderException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileEntry evict() {
        if (this.configuration.maxEntries() > 0) {
            Map<Object, FileEntry> map = this.entries;
            synchronized (map) {
                if (this.entries.size() > this.configuration.maxEntries()) {
                    Iterator<FileEntry> it = this.entries.values().iterator();
                    FileEntry fe = it.next();
                    it.remove();
                    return fe;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        try {
            Map<Object, FileEntry> map = this.entries;
            synchronized (map) {
                SortedSet<FileEntry> sortedSet = this.freeList;
                synchronized (sortedSet) {
                    for (FileEntry fe : this.entries.values()) {
                        fe.waitUnlocked();
                    }
                    for (FileEntry fe : this.freeList) {
                        fe.waitUnlocked();
                    }
                    this.entries.clear();
                    this.freeList.clear();
                    this.file.truncate(0L);
                    this.file.write(java.nio.ByteBuffer.wrap(MAGIC), 0L);
                    this.filePos = MAGIC.length;
                }
            }
        }
        catch (Exception e) {
            throw new CacheLoaderException(e);
        }
    }

    @Override
    public boolean delete(Object key) {
        try {
            FileEntry fe = this.entries.remove(key);
            this.free(fe);
            return fe != null;
        }
        catch (Exception e) {
            throw new CacheLoaderException(e);
        }
    }

    @Override
    public MarshalledEntry load(Object key) {
        return this._load(key, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MarshalledEntry _load(Object key, boolean loadValue, boolean loadMetadata) {
        byte[] data;
        boolean expired;
        FileEntry fe;
        Map<Object, FileEntry> map = this.entries;
        synchronized (map) {
            fe = this.entries.get(key);
            if (fe == null) {
                return null;
            }
            expired = fe.isExpired(System.currentTimeMillis());
            if (expired) {
                this.entries.remove(key);
            }
            fe.lock();
        }
        try {
            if (expired) {
                this.free(fe);
                MarshalledEntry marshalledEntry = null;
                return marshalledEntry;
            }
            data = new byte[fe.keyLen + (loadValue ? fe.dataLen : 0) + (loadMetadata ? fe.metadataLen : 0)];
            this.file.read(java.nio.ByteBuffer.wrap(data), fe.offset + 24L);
        }
        catch (Exception e) {
            throw new CacheLoaderException(e);
        }
        finally {
            fe.unlock();
        }
        ByteBufferFactory factory = this.ctx.getByteBufferFactory();
        ByteBuffer keyBb = factory.newByteBuffer(data, 0, fe.keyLen);
        ByteBuffer valueBb = null;
        ByteBuffer metadataBb = null;
        if (loadValue) {
            valueBb = factory.newByteBuffer(data, fe.keyLen, fe.dataLen);
            if (loadMetadata && fe.metadataLen > 0) {
                metadataBb = factory.newByteBuffer(data, fe.keyLen + fe.dataLen, fe.metadataLen);
            }
        }
        return this.ctx.getMarshalledEntryFactory().newMarshalledEntry(keyBb, valueBb, metadataBb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(AdvancedCacheLoader.KeyFilter filter, final AdvancedCacheLoader.CacheLoaderTask task, Executor executor, final boolean fetchValue, final boolean fetchMetadata) {
        filter = PersistenceUtil.notNull(filter);
        HashSet<Object> keysToLoad = new HashSet<Object>(this.entries.size());
        Map<Object, FileEntry> map = this.entries;
        synchronized (map) {
            for (Object k : this.entries.keySet()) {
                if (!filter.shouldLoadKey(k)) continue;
                keysToLoad.add(k);
            }
        }
        ExecutorCompletionService<Void> ecs = new ExecutorCompletionService<Void>(executor);
        final TaskContextImpl taskContext = new TaskContextImpl();
        int taskCount = 0;
        for (Object e : keysToLoad) {
            if (taskContext.isStopped()) break;
            ++taskCount;
            final Object key = e;
            ecs.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    MarshalledEntry marshalledEntry = SingleFileStore.this._load(key, fetchValue, fetchMetadata);
                    task.processEntry(marshalledEntry, taskContext);
                    return null;
                }
            });
        }
        PersistenceUtil.waitForAllTasksToComplete(ecs, taskCount);
    }

    @Override
    public void purge(Executor threadPool, final AdvancedCacheWriter.PurgeListener task) {
        threadPool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long now = System.currentTimeMillis();
                Map map = SingleFileStore.this.entries;
                synchronized (map) {
                    Iterator it = SingleFileStore.this.entries.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry next = it.next();
                        FileEntry fe = (FileEntry)next.getValue();
                        if (!fe.isExpired(now)) continue;
                        it.remove();
                        try {
                            SingleFileStore.this.free(fe);
                        }
                        catch (Exception e) {
                            throw new CacheLoaderException(e);
                        }
                        if (task == null) continue;
                        task.entryPurged(next.getKey());
                    }
                }
            }
        });
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    Map<Object, FileEntry> getEntries() {
        return this.entries;
    }

    SortedSet<FileEntry> getFreeList() {
        return this.freeList;
    }

    public SingleFileStoreConfiguration getConfiguration() {
        return this.configuration;
    }

    private static class FileEntry
    implements Comparable<Object> {
        private final long offset;
        private final int size;
        private int keyLen;
        private int dataLen;
        private int metadataLen;
        private long expiryTime = -1L;
        private transient int readers = 0;

        private FileEntry(long offset, int size) {
            this.offset = offset;
            this.size = size;
        }

        private synchronized boolean isLocked() {
            return this.readers > 0;
        }

        private synchronized void lock() {
            ++this.readers;
        }

        private synchronized void unlock() {
            --this.readers;
            if (this.readers == 0) {
                this.notifyAll();
            }
        }

        private synchronized void waitUnlocked() {
            while (this.readers > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private boolean isExpired(long now) {
            return this.expiryTime > 0L && this.expiryTime < now;
        }

        @Override
        public int compareTo(Object o) {
            FileEntry fe = (FileEntry)o;
            if (this == fe) {
                return 0;
            }
            int diff = this.size - fe.size;
            return diff != 0 ? diff : (this.offset > fe.offset ? 1 : -1);
        }
    }
}

