/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.persistence.jdbc.DatabaseType;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcMixedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcMixedStoreConfigurationChildBuilder;
import org.infinispan.persistence.jdbc.configuration.ManagedConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.PooledConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfigurationBuilder;
import org.infinispan.persistence.keymappers.DefaultTwoWayKey2StringMapper;
import org.infinispan.persistence.keymappers.Key2StringMapper;

public class JdbcMixedStoreConfigurationBuilder
extends AbstractJdbcStoreConfigurationBuilder<JdbcMixedStoreConfiguration, JdbcMixedStoreConfigurationBuilder>
implements JdbcMixedStoreConfigurationChildBuilder<JdbcMixedStoreConfigurationBuilder> {
    private final MixedTableManipulationConfigurationBuilder binaryTable;
    private final MixedTableManipulationConfigurationBuilder stringTable;
    private String key2StringMapper = DefaultTwoWayKey2StringMapper.class.getName();
    private DatabaseType databaseType;
    private int batchSize = 128;
    private int fetchSize = 100;
    private int lockConcurrencyLevel = 2048;
    private long lockAcquisitionTimeout = 60000L;

    public JdbcMixedStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder);
        this.binaryTable = new MixedTableManipulationConfigurationBuilder(this);
        this.stringTable = new MixedTableManipulationConfigurationBuilder(this);
    }

    public JdbcMixedStoreConfigurationBuilder self() {
        return this;
    }

    public JdbcMixedStoreConfigurationBuilder batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public JdbcMixedStoreConfigurationBuilder fetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public JdbcMixedStoreConfigurationBuilder databaseType(DatabaseType databaseType) {
        this.databaseType = databaseType;
        return this;
    }

    @Override
    public MixedTableManipulationConfigurationBuilder binaryTable() {
        return this.binaryTable;
    }

    @Override
    public MixedTableManipulationConfigurationBuilder stringTable() {
        return this.stringTable;
    }

    @Override
    public JdbcMixedStoreConfigurationChildBuilder<JdbcMixedStoreConfigurationBuilder> key2StringMapper(String key2StringMapper) {
        this.key2StringMapper = key2StringMapper;
        return this;
    }

    @Override
    public JdbcMixedStoreConfigurationChildBuilder<JdbcMixedStoreConfigurationBuilder> key2StringMapper(Class<? extends Key2StringMapper> klass) {
        this.key2StringMapper = klass.getName();
        return this;
    }

    @Override
    public void validate() {
        if (this.binaryTable.tableNamePrefix.equals(this.stringTable.tableNamePrefix)) {
            throw new CacheConfigurationException("There cannot be the same tableNamePrefix on both the binary and String tables.");
        }
    }

    public JdbcMixedStoreConfigurationBuilder lockConcurrencyLevel(int l) {
        this.lockConcurrencyLevel = l;
        return this;
    }

    public JdbcMixedStoreConfigurationBuilder lockAcquisitionTimeout(long timeout) {
        this.lockAcquisitionTimeout = timeout;
        return this;
    }

    public JdbcMixedStoreConfiguration create() {
        return new JdbcMixedStoreConfiguration(this.purgeOnStartup, this.fetchPersistentState, this.ignoreModifications, this.async.create(), this.singletonStore.create(), this.preload, this.shared, this.properties, (ConnectionFactoryConfiguration)this.connectionFactory.create(), this.manageConnectionFactory, this.batchSize, this.fetchSize, this.databaseType, this.binaryTable.create(), this.stringTable.create(), this.key2StringMapper, this.lockConcurrencyLevel, this.lockAcquisitionTimeout);
    }

    public JdbcMixedStoreConfigurationBuilder read(JdbcMixedStoreConfiguration template) {
        super.readInternal(template);
        this.binaryTable.read(template.binaryTable());
        this.stringTable.read(template.stringTable());
        this.key2StringMapper = template.key2StringMapper();
        this.batchSize = template.batchSize();
        this.fetchSize = template.fetchSize();
        this.databaseType = template.databaseType();
        this.lockAcquisitionTimeout = template.lockAcquisitionTimeout();
        this.lockConcurrencyLevel = template.lockConcurrencyLevel();
        return this;
    }

    public class MixedTableManipulationConfigurationBuilder
    extends TableManipulationConfigurationBuilder<JdbcMixedStoreConfigurationBuilder, MixedTableManipulationConfigurationBuilder>
    implements JdbcMixedStoreConfigurationChildBuilder<JdbcMixedStoreConfigurationBuilder> {
        MixedTableManipulationConfigurationBuilder(AbstractJdbcStoreConfigurationBuilder<?, JdbcMixedStoreConfigurationBuilder> builder) {
            super(builder);
        }

        public MixedTableManipulationConfigurationBuilder self() {
            return this;
        }

        @Override
        public MixedTableManipulationConfigurationBuilder binaryTable() {
            return JdbcMixedStoreConfigurationBuilder.this.binaryTable;
        }

        @Override
        public MixedTableManipulationConfigurationBuilder stringTable() {
            return JdbcMixedStoreConfigurationBuilder.this.stringTable;
        }

        @Override
        public PooledConnectionFactoryConfigurationBuilder<JdbcMixedStoreConfigurationBuilder> connectionPool() {
            return JdbcMixedStoreConfigurationBuilder.this.connectionPool();
        }

        @Override
        public ManagedConnectionFactoryConfigurationBuilder<JdbcMixedStoreConfigurationBuilder> dataSource() {
            return JdbcMixedStoreConfigurationBuilder.this.dataSource();
        }

        @Override
        public JdbcMixedStoreConfigurationChildBuilder<JdbcMixedStoreConfigurationBuilder> key2StringMapper(String key2StringMapper) {
            return JdbcMixedStoreConfigurationBuilder.this.key2StringMapper(key2StringMapper);
        }

        @Override
        public JdbcMixedStoreConfigurationChildBuilder<JdbcMixedStoreConfigurationBuilder> key2StringMapper(Class<? extends Key2StringMapper> klass) {
            return JdbcMixedStoreConfigurationBuilder.this.key2StringMapper(klass);
        }
    }
}

