/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.container.DataContainer;
import org.infinispan.container.EntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.SingleKeyNonTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.metadata.Metadata;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class EntryWrappingInterceptor
extends CommandInterceptor {
    private EntryFactory entryFactory;
    protected DataContainer dataContainer;
    protected ClusteringDependentLogic cdl;
    protected final EntryWrappingVisitor entryWrappingVisitor = new EntryWrappingVisitor();
    private CommandsFactory commandFactory;
    private boolean isUsingLockDelegation;
    private StateConsumer stateConsumer;
    private StateTransferLock stateTransferLock;
    private static final Log log = LogFactory.getLog(EntryWrappingInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void init(EntryFactory entryFactory, DataContainer dataContainer, ClusteringDependentLogic cdl, CommandsFactory commandFactory, StateConsumer stateConsumer, StateTransferLock stateTransferLock) {
        this.entryFactory = entryFactory;
        this.dataContainer = dataContainer;
        this.cdl = cdl;
        this.commandFactory = commandFactory;
        this.stateConsumer = stateConsumer;
        this.stateTransferLock = stateTransferLock;
    }

    @Start
    public void start() {
        this.isUsingLockDelegation = !this.cacheConfiguration.transaction().transactionMode().isTransactional() && this.cacheConfiguration.clustering().cacheMode().isDistributed();
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        this.wrapEntriesForPrepare(ctx, command);
        Object result = this.invokeNextInterceptor(ctx, command);
        if (this.shouldCommitDuringPrepare(command, ctx)) {
            this.commitContextEntries(ctx, null, null);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        try {
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.commitContextEntries(ctx, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        try {
            this.entryFactory.wrapEntryForReading(ctx, command.getKey());
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            if (!ctx.isInTxScope()) {
                this.commitContextEntries(ctx, command, null);
            } else {
                CacheEntry entry = ctx.lookupEntry(command.getKey());
                if (entry != null) {
                    entry.setSkipRemoteGet(true);
                }
            }
        }
    }

    @Override
    public final Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        if (command.getKeys() != null) {
            for (Object key : command.getKeys()) {
                this.entryFactory.wrapEntryForRemove(ctx, key, false);
            }
        }
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, null);
    }

    @Override
    public final Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        for (InternalCacheEntry entry : this.dataContainer.entrySet()) {
            this.entryFactory.wrapEntryForClear(ctx, entry.getKey());
        }
        return this.setSkipRemoteGetsAndInvokeNextForClear(ctx, command);
    }

    @Override
    public Object visitInvalidateL1Command(InvocationContext ctx, InvalidateL1Command command) throws Throwable {
        for (Object key : command.getKeys()) {
            this.entryFactory.wrapEntryForRemove(ctx, key, false);
            if (!trace) continue;
            log.tracef("Entry to be removed: %s", ctx.getLookedUpEntries());
        }
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, null);
    }

    @Override
    public final Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        this.wrapEntryForPutIfNeeded(ctx, command);
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, command.getMetadata());
    }

    private void wrapEntryForPutIfNeeded(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (this.shouldWrap(command.getKey(), ctx, command)) {
            this.entryFactory.wrapEntryForPut(ctx, command.getKey(), null, !command.isPutIfAbsent(), command, command.hasFlag(Flag.IGNORE_RETURN_VALUES) && !command.isConditional());
        }
    }

    private boolean shouldWrap(Object key, InvocationContext ctx, FlagAffectedCommand command) {
        if (command.hasFlag(Flag.SKIP_OWNERSHIP_CHECK)) {
            if (trace) {
                log.tracef("Skipping ownership check and wrapping key %s", Util.toStr((Object)key));
            }
            return true;
        }
        boolean isTransactional = this.cacheConfiguration.transaction().transactionMode().isTransactional();
        boolean isPutForExternalRead = command.hasFlag(Flag.PUT_FOR_EXTERNAL_READ);
        boolean result = isTransactional && !isPutForExternalRead ? true : (this.isUsingLockDelegation || isTransactional ? this.cdl.localNodeIsPrimaryOwner(key) || this.cdl.localNodeIsOwner(key) && !ctx.isOriginLocal() : this.cdl.localNodeIsOwner(key));
        if (trace) {
            log.tracef("Wrapping entry '%s'? %s", Util.toStr((Object)key), result);
        }
        return result;
    }

    @Override
    public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        this.entryFactory.wrapEntryForDelta(ctx, command.getKey(), command.getDelta());
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public final Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        this.wrapEntryForRemoveIfNeeded(ctx, command);
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, null);
    }

    private void wrapEntryForRemoveIfNeeded(InvocationContext ctx, RemoveCommand command) throws InterruptedException {
        if (this.shouldWrap(command.getKey(), ctx, command)) {
            if (command.isIgnorePreviousValue()) {
                this.entryFactory.wrapEntryForPut(ctx, command.getKey(), null, false, command, false);
            } else {
                this.entryFactory.wrapEntryForRemove(ctx, command.getKey(), command.hasFlag(Flag.IGNORE_RETURN_VALUES) && !command.isConditional());
            }
        }
    }

    @Override
    public final Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        this.wrapEntryForReplaceIfNeeded(ctx, command);
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, command.getMetadata());
    }

    private void wrapEntryForReplaceIfNeeded(InvocationContext ctx, ReplaceCommand command) throws InterruptedException {
        if (this.shouldWrap(command.getKey(), ctx, command)) {
            if (command.isIgnorePreviousValue()) {
                this.entryFactory.wrapEntryForPut(ctx, command.getKey(), null, false, command, false);
            } else {
                this.entryFactory.wrapEntryForReplace(ctx, command);
            }
        }
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        for (Object key : command.getMap().keySet()) {
            if (!this.shouldWrap(key, ctx, command)) continue;
            this.entryFactory.wrapEntryForPut(ctx, key, null, true, command, true);
        }
        return this.setSkipRemoteGetsAndInvokeNextForPutMapCommand(ctx, command);
    }

    @Override
    public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        return this.visitRemoveCommand(ctx, command);
    }

    protected boolean isFromStateTransfer(InvocationContext ctx) {
        LocalTransaction localTx;
        return ctx.isInTxScope() && ctx.isOriginLocal() && (localTx = (LocalTransaction)((TxInvocationContext)ctx).getCacheTransaction()).isFromStateTransfer();
    }

    protected boolean isFromStateTransfer(FlagAffectedCommand command) {
        return command.hasFlag(Flag.PUT_FOR_STATE_TRANSFER);
    }

    protected final void commitContextEntries(InvocationContext ctx, FlagAffectedCommand command, Metadata metadata) {
        boolean isPutForStateTransfer;
        boolean bl = isPutForStateTransfer = command == null ? this.isFromStateTransfer(ctx) : this.isFromStateTransfer(command);
        if (!isPutForStateTransfer && this.stateConsumer != null && ctx instanceof TxInvocationContext && ((TxInvocationContext)ctx).getCacheTransaction().hasModification(ClearCommand.class)) {
            this.stateConsumer.stopApplyingState();
        }
        if (ctx instanceof SingleKeyNonTxInvocationContext) {
            SingleKeyNonTxInvocationContext singleKeyCtx = (SingleKeyNonTxInvocationContext)ctx;
            this.commitEntryIfNeeded(ctx, command, singleKeyCtx.getKey(), singleKeyCtx.getCacheEntry(), isPutForStateTransfer, metadata);
        } else {
            Set<Map.Entry<Object, CacheEntry>> entries = ctx.getLookedUpEntries().entrySet();
            Iterator<Map.Entry<Object, CacheEntry>> it = entries.iterator();
            Log log = this.getLog();
            while (it.hasNext()) {
                Map.Entry<Object, CacheEntry> e = it.next();
                CacheEntry entry = e.getValue();
                if (this.commitEntryIfNeeded(ctx, command, e.getKey(), entry, isPutForStateTransfer, metadata) || !trace) continue;
                if (entry == null) {
                    log.tracef("Entry for key %s is null : not calling commitUpdate", e.getKey());
                    continue;
                }
                log.tracef("Entry for key %s is not changed(%s): not calling commitUpdate", e.getKey(), entry);
            }
        }
    }

    protected void commitContextEntry(CacheEntry entry, InvocationContext ctx, FlagAffectedCommand command, Metadata metadata) {
        this.cdl.commitEntry(entry, metadata, command, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeNextAndApplyChanges(InvocationContext ctx, FlagAffectedCommand command, Metadata metadata) throws Throwable {
        Object result = this.invokeNextInterceptor(ctx, command);
        if (!ctx.isInTxScope()) {
            this.stateTransferLock.acquireSharedTopologyLock();
            try {
                if (command instanceof WriteCommand) {
                    boolean isSync;
                    WriteCommand writeCommand = (WriteCommand)command;
                    boolean bl = isSync = this.cacheConfiguration.clustering().cacheMode().isSynchronous() && !command.hasFlag(Flag.FORCE_ASYNCHRONOUS) || command.hasFlag(Flag.FORCE_SYNCHRONOUS);
                    if (writeCommand.isSuccessful() && this.stateConsumer != null && this.stateConsumer.getCacheTopology() != null) {
                        int commandTopologyId = command.getTopologyId();
                        int currentTopologyId = this.stateConsumer.getCacheTopology().getTopologyId();
                        if (isSync && currentTopologyId != commandTopologyId && commandTopologyId != -1) {
                            if (trace) {
                                log.tracef("Cache topology changed while the command was executing: expected %d, got %d", commandTopologyId, currentTopologyId);
                            }
                            writeCommand.setIgnorePreviousValue(true);
                            throw new OutdatedTopologyException("Cache topology changed while the command was executing: expected " + commandTopologyId + ", got " + currentTopologyId);
                        }
                    }
                }
                this.commitContextEntries(ctx, command, metadata);
            }
            finally {
                this.stateTransferLock.releaseSharedTopologyLock();
            }
        }
        if (trace) {
            log.tracef("The return value is %s", result);
        }
        return result;
    }

    private Object setSkipRemoteGetsAndInvokeNextForClear(InvocationContext context, ClearCommand command) throws Throwable {
        boolean txScope = context.isInTxScope();
        if (txScope) {
            for (CacheEntry entry : context.getLookedUpEntries().values()) {
                if (entry == null) continue;
                entry.setSkipRemoteGet(true);
            }
        }
        Object retVal = this.invokeNextAndApplyChanges(context, command, command.getMetadata());
        if (txScope) {
            for (CacheEntry entry : context.getLookedUpEntries().values()) {
                if (entry == null) continue;
                entry.setSkipRemoteGet(true);
            }
        }
        return retVal;
    }

    private Object setSkipRemoteGetsAndInvokeNextForPutMapCommand(InvocationContext context, PutMapCommand command) throws Throwable {
        Object retVal = this.invokeNextAndApplyChanges(context, command, command.getMetadata());
        if (context.isInTxScope()) {
            for (Object key : command.getAffectedKeys()) {
                CacheEntry entry = context.lookupEntry(key);
                if (entry == null) continue;
                entry.setSkipRemoteGet(true);
            }
        }
        return retVal;
    }

    private Object setSkipRemoteGetsAndInvokeNextForDataCommand(InvocationContext context, DataWriteCommand command, Metadata metadata) throws Throwable {
        CacheEntry entry;
        Object retVal = this.invokeNextAndApplyChanges(context, command, metadata);
        if (context.isInTxScope() && (entry = context.lookupEntry(command.getKey())) != null) {
            entry.setSkipRemoteGet(true);
        }
        return retVal;
    }

    private boolean commitEntryIfNeeded(InvocationContext ctx, FlagAffectedCommand command, Object key, CacheEntry entry, boolean isPutForStateTransfer, Metadata metadata) {
        if (entry == null) {
            if (key != null && !isPutForStateTransfer && this.stateConsumer != null) {
                this.stateConsumer.addUpdatedKey(key);
            }
            return false;
        }
        if (isPutForStateTransfer && this.stateConsumer.isKeyUpdated(key)) {
            log.tracef("State transfer will not write key/value %s/%s because it was already updated by somebody else", key, entry.getValue());
            entry.rollback();
            return false;
        }
        if (entry.isChanged() || entry.isLoaded()) {
            log.tracef("About to commit entry %s", entry);
            this.commitContextEntry(entry, ctx, command, metadata);
            if (!isPutForStateTransfer && this.stateConsumer != null) {
                this.stateConsumer.addUpdatedKey(key);
            }
            return true;
        }
        return false;
    }

    protected boolean shouldCommitDuringPrepare(PrepareCommand command, TxInvocationContext ctx) {
        boolean isTotalOrder = this.cacheConfiguration.transaction().transactionProtocol().isTotalOrder();
        return isTotalOrder ? !(!command.isOnePhaseCommit() || ctx.isOriginLocal() && command.hasModifications()) : command.isOnePhaseCommit();
    }

    protected final void wrapEntriesForPrepare(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!ctx.isOriginLocal() || command.isReplayEntryWrapping()) {
            for (WriteCommand c : command.getModifications()) {
                c.acceptVisitor(ctx, this.entryWrappingVisitor);
            }
        }
    }

    private final class EntryWrappingVisitor
    extends AbstractVisitor {
        private EntryWrappingVisitor() {
        }

        @Override
        public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
            boolean wrapped = false;
            for (Object key : EntryWrappingInterceptor.this.dataContainer.keySet()) {
                EntryWrappingInterceptor.this.entryFactory.wrapEntryForClear(ctx, key);
                wrapped = true;
            }
            if (wrapped) {
                EntryWrappingInterceptor.this.invokeNextInterceptor(ctx, command);
            }
            if (EntryWrappingInterceptor.this.stateConsumer != null && !ctx.isInTxScope()) {
                EntryWrappingInterceptor.this.stateConsumer.stopApplyingState();
            }
            return null;
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            HashMap<Object, Object> newMap = new HashMap<Object, Object>(4);
            for (Map.Entry<Object, Object> e : command.getMap().entrySet()) {
                Object key = e.getKey();
                if (!EntryWrappingInterceptor.this.cdl.localNodeIsOwner(key)) continue;
                EntryWrappingInterceptor.this.entryFactory.wrapEntryForPut(ctx, key, null, true, command, false);
                newMap.put(key, e.getValue());
            }
            if (newMap.size() > 0) {
                PutMapCommand clonedCommand = EntryWrappingInterceptor.this.commandFactory.buildPutMapCommand(newMap, command.getMetadata(), command.getFlags());
                EntryWrappingInterceptor.this.invokeNextInterceptor(ctx, clonedCommand);
            }
            return null;
        }

        @Override
        public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
            if (command.getKeys() != null) {
                for (Object key : command.getKeys()) {
                    if (!EntryWrappingInterceptor.this.cdl.localNodeIsOwner(key)) continue;
                    EntryWrappingInterceptor.this.entryFactory.wrapEntryForRemove(ctx, key, false);
                    EntryWrappingInterceptor.this.invokeNextInterceptor(ctx, command);
                }
            }
            return null;
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            if (EntryWrappingInterceptor.this.cdl.localNodeIsOwner(command.getKey())) {
                if (command.isIgnorePreviousValue()) {
                    EntryWrappingInterceptor.this.entryFactory.wrapEntryForPut(ctx, command.getKey(), null, false, command, false);
                } else {
                    EntryWrappingInterceptor.this.entryFactory.wrapEntryForRemove(ctx, command.getKey(), false);
                }
                EntryWrappingInterceptor.this.invokeNextInterceptor(ctx, command);
            }
            return null;
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            if (EntryWrappingInterceptor.this.cdl.localNodeIsOwner(command.getKey())) {
                EntryWrappingInterceptor.this.entryFactory.wrapEntryForPut(ctx, command.getKey(), null, !command.isPutIfAbsent(), command, false);
                EntryWrappingInterceptor.this.invokeNextInterceptor(ctx, command);
            }
            return null;
        }

        @Override
        public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
            if (EntryWrappingInterceptor.this.cdl.localNodeIsOwner(command.getKey())) {
                EntryWrappingInterceptor.this.entryFactory.wrapEntryForDelta(ctx, command.getKey(), command.getDelta());
                EntryWrappingInterceptor.this.invokeNextInterceptor(ctx, command);
            }
            return null;
        }

        @Override
        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
            if (EntryWrappingInterceptor.this.cdl.localNodeIsOwner(command.getKey())) {
                if (command.isIgnorePreviousValue()) {
                    EntryWrappingInterceptor.this.entryFactory.wrapEntryForPut(ctx, command.getKey(), null, false, command, false);
                } else {
                    EntryWrappingInterceptor.this.entryFactory.wrapEntryForReplace(ctx, command);
                }
                EntryWrappingInterceptor.this.invokeNextInterceptor(ctx, command);
            }
            return null;
        }
    }
}

