/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.async;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.TaskContextImpl;
import org.infinispan.persistence.async.AsyncCacheLoader;
import org.infinispan.persistence.async.State;
import org.infinispan.persistence.modifications.Modification;
import org.infinispan.persistence.modifications.Remove;
import org.infinispan.persistence.modifications.Store;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.CacheLoader;

public class AdvancedAsyncCacheLoader
extends AsyncCacheLoader
implements AdvancedCacheLoader {
    public AdvancedAsyncCacheLoader(CacheLoader actual, AtomicReference<State> state) {
        super(actual, state);
    }

    private void loadAllKeys(State s, final Set<Object> result, AdvancedCacheLoader.KeyFilter filter, Executor executor) {
        if (!s.clear) {
            State next = s.next;
            if (next != null) {
                this.loadAllKeys(next, result, filter, executor);
            } else {
                this.advancedLoader().process(filter, new AdvancedCacheLoader.CacheLoaderTask(){

                    public void processEntry(MarshalledEntry marshalledEntry, AdvancedCacheLoader.TaskContext taskContext) throws InterruptedException {
                        result.add(marshalledEntry.getKey());
                    }
                }, executor, false, false);
            }
        }
        for (Modification mod : s.modifications.values()) {
            switch (mod.getType()) {
                case STORE: {
                    Object key = ((Store)mod).getStoredValue().getKey();
                    if (filter != null && !filter.shouldLoadKey(key)) break;
                    result.add(key);
                    break;
                }
                case REMOVE: {
                    result.remove(((Remove)mod).getKey());
                }
            }
        }
    }

    public void process(AdvancedCacheLoader.KeyFilter keyFilter, AdvancedCacheLoader.CacheLoaderTask cacheLoaderTask, Executor executor, boolean loadValues, boolean loadMetadata) {
        int batchSize = 100;
        ExecutorCompletionService<Void> ecs = new ExecutorCompletionService<Void>(executor);
        int tasks = 0;
        TaskContextImpl taskContext = new TaskContextImpl();
        HashSet<Object> allKeys = new HashSet<Object>(batchSize);
        HashSet<Object> batch = new HashSet<Object>();
        this.loadAllKeys((State)this.state.get(), allKeys, keyFilter, executor);
        Iterator it = allKeys.iterator();
        while (it.hasNext()) {
            batch.add(it.next());
            if (batch.size() != batchSize) continue;
            HashSet<Object> toHandle = batch;
            batch = new HashSet(batchSize);
            this.submitProcessTask(cacheLoaderTask, ecs, taskContext, toHandle);
            ++tasks;
        }
        if (!batch.isEmpty()) {
            this.submitProcessTask(cacheLoaderTask, ecs, taskContext, batch);
            ++tasks;
        }
        PersistenceUtil.waitForAllTasksToComplete(ecs, tasks);
    }

    private void submitProcessTask(final AdvancedCacheLoader.CacheLoaderTask cacheLoaderTask, ExecutorCompletionService ecs, final AdvancedCacheLoader.TaskContext taskContext, final Set<Object> batch) {
        ecs.submit(new Callable(){

            public Object call() throws Exception {
                for (Object k : batch) {
                    if (taskContext.isStopped()) break;
                    MarshalledEntry load = AdvancedAsyncCacheLoader.this.load(k);
                    if (load == null) continue;
                    cacheLoaderTask.processEntry(load, taskContext);
                }
                return null;
            }
        });
    }

    @Override
    public int size() {
        return this.advancedLoader().size();
    }

    AdvancedCacheLoader advancedLoader() {
        return (AdvancedCacheLoader)this.actual;
    }
}

