/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Map;
import java.util.Properties;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.cache.IndexingConfiguration;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class IndexingConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<IndexingConfiguration> {
    private static final Log log = LogFactory.getLog(IndexingConfigurationBuilder.class);
    private Properties properties = new Properties();
    private Index index = Index.NONE;

    IndexingConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    @Deprecated
    public IndexingConfigurationBuilder enable() {
        if (this.index == Index.NONE) {
            this.index = Index.ALL;
        }
        return this;
    }

    @Deprecated
    public IndexingConfigurationBuilder disable() {
        this.index = Index.NONE;
        return this;
    }

    @Deprecated
    public IndexingConfigurationBuilder enabled(boolean enabled) {
        if (this.index == Index.NONE & enabled) {
            this.index = Index.ALL;
        } else if (!enabled) {
            this.index = Index.NONE;
        }
        return this;
    }

    boolean enabled() {
        return this.index.isEnabled();
    }

    @Deprecated
    public IndexingConfigurationBuilder indexLocalOnly(boolean b) {
        if (b) {
            this.index = Index.LOCAL;
        }
        return this;
    }

    boolean indexLocalOnly() {
        return this.index.isLocalOnly();
    }

    public IndexingConfigurationBuilder addProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public IndexingConfigurationBuilder setProperty(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    public IndexingConfigurationBuilder withProperties(Properties props) {
        this.properties = props;
        return this;
    }

    public IndexingConfigurationBuilder index(Index index) {
        this.index = index;
        return this;
    }

    public void validate() {
        if (this.index.isEnabled()) {
            if (this.clustering().cacheMode().isInvalidation()) {
                throw log.invalidConfigurationIndexingWithInvalidation();
            }
            try {
                String clazz = "org.infinispan.query.Search";
                ClassLoader classLoader = this.getBuilder().classLoader();
                if (classLoader == null) {
                    Class.forName(clazz);
                } else {
                    classLoader.loadClass(clazz);
                }
            }
            catch (ClassNotFoundException e) {
                throw log.invalidConfigurationIndexingWithoutModule();
            }
        }
    }

    public IndexingConfiguration create() {
        return new IndexingConfiguration(TypedProperties.toTypedProperties((Properties)this.properties), this.index);
    }

    public IndexingConfigurationBuilder read(IndexingConfiguration template) {
        this.index = template.index();
        this.properties = new Properties();
        TypedProperties templateProperties = template.properties();
        if (templateProperties != null) {
            for (Map.Entry entry : templateProperties.entrySet()) {
                this.properties.put(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public String toString() {
        return "IndexingConfigurationBuilder{index=" + (Object)((Object)this.index) + ", properties=" + this.properties + '}';
    }
}

