/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.RecoveryConfigurationBuilder;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.TransactionProtocol;
import org.infinispan.transaction.lookup.GenericTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionSynchronizationRegistryLookup;

public class TransactionConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<TransactionConfiguration> {
    private boolean autoCommit = true;
    private long cacheStopTimeout = TimeUnit.SECONDS.toMillis(30L);
    private boolean eagerLockingSingleNode = false;
    LockingMode lockingMode = LockingMode.OPTIMISTIC;
    private boolean syncCommitPhase = true;
    private boolean syncRollbackPhase = false;
    private TransactionManagerLookup transactionManagerLookup = new GenericTransactionManagerLookup();
    private TransactionSynchronizationRegistryLookup transactionSynchronizationRegistryLookup;
    TransactionMode transactionMode = null;
    private boolean useEagerLocking = false;
    private boolean useSynchronization = true;
    private final RecoveryConfigurationBuilder recovery;
    private boolean use1PcForAutoCommitTransactions = false;
    private long reaperWakeUpInterval = 1000L;
    private long completedTxTimeout = 15000L;
    private TransactionProtocol transactionProtocol = TransactionProtocol.DEFAULT;

    TransactionConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
        this.recovery = new RecoveryConfigurationBuilder(this);
    }

    public TransactionConfigurationBuilder autoCommit(boolean b) {
        this.autoCommit = b;
        return this;
    }

    public TransactionConfigurationBuilder cacheStopTimeout(long l) {
        this.cacheStopTimeout = l;
        return this;
    }

    public TransactionConfigurationBuilder cacheStopTimeout(long l, TimeUnit unit) {
        return this.cacheStopTimeout(unit.toMillis(l));
    }

    @Deprecated
    public TransactionConfigurationBuilder eagerLockingSingleNode(boolean b) {
        this.eagerLockingSingleNode = b;
        return this;
    }

    public TransactionConfigurationBuilder lockingMode(LockingMode lockingMode) {
        this.lockingMode = lockingMode;
        return this;
    }

    public TransactionConfigurationBuilder syncCommitPhase(boolean b) {
        this.syncCommitPhase = b;
        return this;
    }

    public boolean syncCommitPhase() {
        return this.syncCommitPhase;
    }

    public TransactionConfigurationBuilder syncRollbackPhase(boolean b) {
        this.syncRollbackPhase = b;
        return this;
    }

    public TransactionConfigurationBuilder transactionManagerLookup(TransactionManagerLookup tml) {
        this.transactionManagerLookup = tml;
        if (tml != null) {
            this.transactionMode(TransactionMode.TRANSACTIONAL);
        }
        return this;
    }

    public TransactionConfigurationBuilder transactionSynchronizationRegistryLookup(TransactionSynchronizationRegistryLookup lookup) {
        this.transactionSynchronizationRegistryLookup = lookup;
        return this;
    }

    public TransactionConfigurationBuilder transactionMode(TransactionMode transactionMode) {
        this.transactionMode = transactionMode;
        return this;
    }

    @Deprecated
    public TransactionConfigurationBuilder useEagerLocking(boolean b) {
        this.useEagerLocking = b;
        return this;
    }

    public TransactionConfigurationBuilder useSynchronization(boolean b) {
        this.useSynchronization = b;
        return this;
    }

    public boolean useSynchronization() {
        return this.useSynchronization;
    }

    public RecoveryConfigurationBuilder recovery() {
        return this.recovery;
    }

    public TransactionConfigurationBuilder use1PcForAutoCommitTransactions(boolean b) {
        this.use1PcForAutoCommitTransactions = b;
        return this;
    }

    public TransactionConfigurationBuilder reaperWakeUpInterval(long interval) {
        this.reaperWakeUpInterval = interval;
        return this;
    }

    public TransactionConfigurationBuilder completedTxTimeout(long timeout) {
        this.completedTxTimeout = timeout;
        return this;
    }

    public void validate() {
        if (this.reaperWakeUpInterval < 0L) {
            throw new CacheConfigurationException("reaperWakeUpInterval must be > 0, we got " + this.reaperWakeUpInterval);
        }
        if (this.completedTxTimeout < 0L) {
            throw new CacheConfigurationException("completedTxTimeout must be > 0, we got " + this.reaperWakeUpInterval);
        }
        if (this.transactionProtocol == TransactionProtocol.TOTAL_ORDER) {
            if (this.transactionMode != TransactionMode.TRANSACTIONAL) {
                throw new CacheConfigurationException("Total Order based protocol not available in " + (Object)((Object)this.transactionMode) + " cache");
            }
            if (!this.clustering().cacheMode().isReplicated() && !this.clustering().cacheMode().isDistributed()) {
                throw new CacheConfigurationException(this.clustering().cacheMode().friendlyCacheModeString() + " is not supported by Total Order based protocol");
            }
            if (this.recovery.create().enabled()) {
                throw new CacheConfigurationException("Total Order based protocol not available with recovery");
            }
            if (this.lockingMode != LockingMode.OPTIMISTIC) {
                throw new CacheConfigurationException("Total Order based protocol not available with " + (Object)((Object)this.lockingMode));
            }
        }
        this.recovery.validate();
    }

    public TransactionConfiguration create() {
        if (this.useEagerLocking) {
            this.lockingMode = LockingMode.PESSIMISTIC;
        }
        if (this.transactionMode == null && this.getBuilder().invocationBatching().enabled) {
            this.transactionMode = TransactionMode.TRANSACTIONAL;
        } else if (this.transactionMode == null) {
            this.transactionMode = TransactionMode.NON_TRANSACTIONAL;
        }
        return new TransactionConfiguration(this.autoCommit, this.cacheStopTimeout, this.eagerLockingSingleNode, this.lockingMode, this.syncCommitPhase, this.syncRollbackPhase, this.transactionManagerLookup, this.transactionSynchronizationRegistryLookup, this.transactionMode, this.useEagerLocking, this.useSynchronization, this.use1PcForAutoCommitTransactions, this.reaperWakeUpInterval, this.completedTxTimeout, this.recovery.create(), this.transactionProtocol);
    }

    public TransactionConfigurationBuilder read(TransactionConfiguration template) {
        this.autoCommit = template.autoCommit();
        this.cacheStopTimeout = template.cacheStopTimeout();
        this.eagerLockingSingleNode = template.eagerLockingSingleNode();
        this.lockingMode = template.lockingMode();
        this.syncCommitPhase = template.syncCommitPhase();
        this.syncRollbackPhase = template.syncRollbackPhase();
        this.transactionManagerLookup = template.transactionManagerLookup();
        this.transactionMode = template.transactionMode();
        this.transactionSynchronizationRegistryLookup = template.transactionSynchronizationRegistryLookup();
        this.useEagerLocking = template.useEagerLocking();
        this.useSynchronization = template.useSynchronization();
        this.use1PcForAutoCommitTransactions = template.use1PcForAutoCommitTransactions();
        this.recovery.read(template.recovery());
        this.reaperWakeUpInterval = template.reaperWakeUpInterval();
        this.completedTxTimeout = template.completedTxTimeout();
        this.transactionProtocol = template.transactionProtocol();
        return this;
    }

    public String toString() {
        return "TransactionConfigurationBuilder{autoCommit=" + this.autoCommit + ", cacheStopTimeout=" + this.cacheStopTimeout + ", eagerLockingSingleNode=" + this.eagerLockingSingleNode + ", lockingMode=" + (Object)((Object)this.lockingMode) + ", syncCommitPhase=" + this.syncCommitPhase + ", syncRollbackPhase=" + this.syncRollbackPhase + ", transactionManagerLookup=" + this.transactionManagerLookup + ", transactionSynchronizationRegistryLookup=" + this.transactionSynchronizationRegistryLookup + ", transactionMode=" + (Object)((Object)this.transactionMode) + ", useEagerLocking=" + this.useEagerLocking + ", useSynchronization=" + this.useSynchronization + ", recovery=" + this.recovery + ", use1PcForAutoCommitTransactions=" + this.use1PcForAutoCommitTransactions + ", completedTxTimeout=" + this.completedTxTimeout + ", reaperWakeUpInterval=" + this.reaperWakeUpInterval + '}';
    }

    public TransactionConfigurationBuilder transactionProtocol(TransactionProtocol transactionProtocol) {
        this.transactionProtocol = transactionProtocol;
        return this;
    }
}

