/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.filter;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.notifications.KeyFilter;

public class SimpleCollectionKeyFilter<K>
implements KeyFilter<K> {
    private final Collection<? extends K> collection;

    public SimpleCollectionKeyFilter(Collection<? extends K> collection) {
        this.collection = collection;
    }

    @Override
    public boolean accept(K key) {
        return this.collection.contains(key);
    }

    public static class Externalizer
    extends AbstractExternalizer<SimpleCollectionKeyFilter> {
        public Set<Class<? extends SimpleCollectionKeyFilter>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{SimpleCollectionKeyFilter.class});
        }

        public void writeObject(ObjectOutput output, SimpleCollectionKeyFilter object) throws IOException {
            output.writeObject(object.collection);
        }

        public SimpleCollectionKeyFilter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new SimpleCollectionKeyFilter((Collection)input.readObject());
        }

        public Integer getId() {
            return 123;
        }
    }
}

