/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security.impl;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import org.infinispan.configuration.cache.AuthorizationConfiguration;
import org.infinispan.configuration.global.GlobalSecurityConfiguration;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Role;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class AuthorizationHelper {
    private static final Log log = LogFactory.getLog(AuthorizationHelper.class);

    public static void checkPermission(Subject subject, int subjectMask, AuthorizationPermission perm) {
        if ((subjectMask & perm.getMask()) != perm.getMask()) {
            if (System.getSecurityManager() == null) {
                throw log.unauthorizedAccess(String.valueOf(subject), perm.toString());
            }
            System.getSecurityManager().checkPermission(perm.getSecurityPermission());
        }
    }

    public static void checkPermission(GlobalSecurityConfiguration globalConfiguration, AuthorizationConfiguration configuration, AuthorizationPermission perm) {
        if (globalConfiguration.authorization().enabled()) {
            AccessControlContext acc = AccessController.getContext();
            Subject subject = Subject.getSubject(acc);
            int subjectMask = AuthorizationHelper.computeSubjectRoleMask(subject, globalConfiguration, configuration);
            AuthorizationHelper.checkPermission(subject, subjectMask, perm);
        }
    }

    public static void checkPermission(GlobalSecurityConfiguration globalConfiguration, AuthorizationPermission perm) {
        AuthorizationHelper.checkPermission(globalConfiguration, null, perm);
    }

    public static int computeSubjectRoleMask(Subject subject, GlobalSecurityConfiguration globalConfiguration, AuthorizationConfiguration configuration) {
        PrincipalRoleMapper roleMapper = globalConfiguration.authorization().principalRoleMapper();
        int mask = 0;
        if (subject != null) {
            for (Principal principal : subject.getPrincipals()) {
                Set<String> roleNames = roleMapper.principalToRoles(principal);
                if (roleNames == null) continue;
                for (String roleName : roleNames) {
                    Role role;
                    if (configuration != null && !configuration.roles().contains(roleName) || (role = globalConfiguration.authorization().roles().get(roleName)) == null) continue;
                    mask |= role.getMask();
                }
            }
        }
        return mask;
    }
}

