/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security.impl;

import java.security.AccessController;
import javax.security.auth.Subject;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.AuthorizationConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalSecurityConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.registry.ClusterRegistry;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.impl.AuthorizationHelper;

public class AuthorizationManagerImpl
implements AuthorizationManager {
    private GlobalSecurityConfiguration globalConfiguration;
    private AuthorizationConfiguration configuration;
    private ClusterRegistry<String, Subject, Integer> subjectRoleMaskCache;
    private String authCacheScope;

    @Inject
    public void init(Cache<?, ?> cache, GlobalConfiguration globalConfiguration, Configuration configuration, ClusterRegistry<String, Subject, Integer> clusterRegistry) {
        this.globalConfiguration = globalConfiguration.security();
        this.configuration = configuration.security().authorization();
        this.subjectRoleMaskCache = clusterRegistry;
        this.authCacheScope = String.format("%s_%s", AuthorizationManager.class.getName(), cache.getName());
    }

    @Override
    public void checkPermission(AuthorizationPermission perm) {
        Integer subjectMask;
        Subject subject = Subject.getSubject(AccessController.getContext());
        Integer n = subjectMask = subject == null ? Integer.valueOf(0) : null;
        if (subjectMask == null) {
            subjectMask = AuthorizationHelper.computeSubjectRoleMask(subject, this.globalConfiguration, this.configuration);
        }
        AuthorizationHelper.checkPermission(subject, subjectMask, perm);
    }
}

