/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.infinispan.AdvancedCache;
import org.infinispan.atomic.Delta;
import org.infinispan.batch.BatchContainer;
import org.infinispan.commons.util.concurrent.NotifyingFuture;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.Converter;
import org.infinispan.notifications.KeyFilter;
import org.infinispan.notifications.KeyValueFilter;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.SecureCache;
import org.infinispan.stats.Stats;
import org.infinispan.util.concurrent.locks.LockManager;

public final class SecureCacheImpl<K, V>
implements SecureCache<K, V> {
    private final AuthorizationManager authzManager;
    private final AdvancedCache<K, V> delegate;

    public SecureCacheImpl(AdvancedCache<K, V> delegate) {
        this.authzManager = delegate.getAuthorizationManager();
        this.delegate = delegate;
    }

    public boolean startBatch() {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.startBatch();
    }

    @Override
    public <C> void addListener(Object listener, KeyValueFilter<? super K, ? super V> filter, Converter<? super K, ? super V, C> converter) {
        this.authzManager.checkPermission(AuthorizationPermission.LISTEN);
        this.delegate.addListener(listener, filter, converter);
    }

    @Override
    public void addListener(Object listener, KeyFilter<? super K> filter) {
        this.authzManager.checkPermission(AuthorizationPermission.LISTEN);
        this.delegate.addListener(listener, filter);
    }

    @Override
    public void addListener(Object listener) {
        this.authzManager.checkPermission(AuthorizationPermission.LISTEN);
        this.delegate.addListener(listener);
    }

    public void start() {
        this.authzManager.checkPermission(AuthorizationPermission.LIFECYCLE);
        this.delegate.start();
    }

    public void stop() {
        this.authzManager.checkPermission(AuthorizationPermission.LIFECYCLE);
        this.delegate.stop();
    }

    public NotifyingFuture<V> putAsync(K key, V value) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.putAsync(key, value);
    }

    public void endBatch(boolean successful) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        this.delegate.endBatch(successful);
    }

    @Override
    public void removeListener(Object listener) {
        this.authzManager.checkPermission(AuthorizationPermission.LISTEN);
        this.delegate.removeListener(listener);
    }

    @Override
    public Set<Object> getListeners() {
        this.authzManager.checkPermission(AuthorizationPermission.LISTEN);
        return this.delegate.getListeners();
    }

    public NotifyingFuture<V> putAsync(K key, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.putAsync(key, value, lifespan, unit);
    }

    @Override
    public AdvancedCache<K, V> withFlags(Flag ... flags) {
        return new SecureCacheImpl<K, V>(this.delegate.withFlags(flags));
    }

    public V putIfAbsent(K key, V value) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return (V)this.delegate.putIfAbsent(key, value);
    }

    public NotifyingFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.putAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getVersion() {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.getVersion();
    }

    public V put(K key, V value) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return (V)this.delegate.put(key, value);
    }

    public NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.putAllAsync(data);
    }

    public V put(K key, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return (V)this.delegate.put(key, value, lifespan, unit);
    }

    public boolean remove(Object key, Object value) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.remove(key, value);
    }

    public NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.putAllAsync(data, lifespan, unit);
    }

    @Override
    public void addInterceptor(CommandInterceptor i, int position) {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        this.delegate.addInterceptor(i, position);
    }

    public V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return (V)this.delegate.putIfAbsent(key, value, lifespan, unit);
    }

    @Override
    public boolean addInterceptorAfter(CommandInterceptor i, Class<? extends CommandInterceptor> afterInterceptor) {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.addInterceptorAfter(i, afterInterceptor);
    }

    public NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.putAllAsync(data, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        this.delegate.putAll(map, lifespan, unit);
    }

    @Override
    public boolean addInterceptorBefore(CommandInterceptor i, Class<? extends CommandInterceptor> beforeInterceptor) {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.addInterceptorBefore(i, beforeInterceptor);
    }

    public boolean replace(K key, V oldValue, V newValue) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.replace(key, oldValue, newValue);
    }

    public NotifyingFuture<Void> clearAsync() {
        this.authzManager.checkPermission(AuthorizationPermission.BULK_WRITE);
        return this.delegate.clearAsync();
    }

    public V replace(K key, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return (V)this.delegate.replace(key, value, lifespan, unit);
    }

    @Override
    public void removeInterceptor(int position) {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        this.delegate.removeInterceptor(position);
    }

    public NotifyingFuture<V> putIfAbsentAsync(K key, V value) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.putIfAbsentAsync(key, value);
    }

    @Override
    public void removeInterceptor(Class<? extends CommandInterceptor> interceptorType) {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        this.delegate.removeInterceptor(interceptorType);
    }

    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.replace(key, oldValue, value, lifespan, unit);
    }

    @Override
    public List<CommandInterceptor> getInterceptorChain() {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.getInterceptorChain();
    }

    public NotifyingFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.putIfAbsentAsync(key, value, lifespan, unit);
    }

    public V replace(K key, V value) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return (V)this.delegate.replace(key, value);
    }

    @Override
    public EvictionManager getEvictionManager() {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.getEvictionManager();
    }

    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return (V)this.delegate.put(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public void putForExternalRead(K key, V value) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        this.delegate.putForExternalRead(key, value);
    }

    @Override
    public ComponentRegistry getComponentRegistry() {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.getComponentRegistry();
    }

    @Override
    public DistributionManager getDistributionManager() {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.getDistributionManager();
    }

    @Override
    public AuthorizationManager getAuthorizationManager() {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.getAuthorizationManager();
    }

    public NotifyingFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.putIfAbsentAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public boolean isEmpty() {
        this.authzManager.checkPermission(AuthorizationPermission.READ);
        return this.delegate.isEmpty();
    }

    @Override
    public boolean lock(K ... keys) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.lock(keys);
    }

    public boolean containsKey(Object key) {
        this.authzManager.checkPermission(AuthorizationPermission.READ);
        return this.delegate.containsKey(key);
    }

    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return (V)this.delegate.putIfAbsent(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public boolean lock(Collection<? extends K> keys) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.lock(keys);
    }

    public NotifyingFuture<V> removeAsync(Object key) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.removeAsync(key);
    }

    public boolean containsValue(Object value) {
        this.authzManager.checkPermission(AuthorizationPermission.READ);
        return this.delegate.containsValue(value);
    }

    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        this.delegate.putAll(map, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public NotifyingFuture<Boolean> removeAsync(Object key, Object value) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.removeAsync(key, value);
    }

    @Override
    public void applyDelta(K deltaAwareValueKey, Delta delta, Object ... locksToAcquire) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        this.delegate.applyDelta(deltaAwareValueKey, delta, locksToAcquire);
    }

    @Override
    public void evict(K key) {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        this.delegate.evict(key);
    }

    public NotifyingFuture<V> replaceAsync(K key, V value) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.replaceAsync(key, value);
    }

    @Override
    public RpcManager getRpcManager() {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.getRpcManager();
    }

    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return (V)this.delegate.replace(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public V get(Object key) {
        this.authzManager.checkPermission(AuthorizationPermission.READ);
        return (V)this.delegate.get(key);
    }

    public NotifyingFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.replaceAsync(key, value, lifespan, unit);
    }

    @Override
    public BatchContainer getBatchContainer() {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.getBatchContainer();
    }

    @Override
    public Configuration getCacheConfiguration() {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.getCacheConfiguration();
    }

    @Override
    public EmbeddedCacheManager getCacheManager() {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.getCacheManager();
    }

    @Override
    public InvocationContextContainer getInvocationContextContainer() {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.getInvocationContextContainer();
    }

    @Override
    public AdvancedCache<K, V> getAdvancedCache() {
        return this;
    }

    @Override
    public ComponentStatus getStatus() {
        return this.delegate.getStatus();
    }

    @Override
    public int size() {
        this.authzManager.checkPermission(AuthorizationPermission.BULK_READ);
        return this.delegate.size();
    }

    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.replace(key, oldValue, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public DataContainer getDataContainer() {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.getDataContainer();
    }

    public NotifyingFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.replaceAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.delegate.getTransactionManager();
    }

    @Override
    public Set<K> keySet() {
        this.authzManager.checkPermission(AuthorizationPermission.BULK_READ);
        return this.delegate.keySet();
    }

    public V remove(Object key) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return (V)this.delegate.remove(key);
    }

    @Override
    public LockManager getLockManager() {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.getLockManager();
    }

    public NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.replaceAsync(key, oldValue, newValue);
    }

    @Override
    public Stats getStats() {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.getStats();
    }

    @Override
    public XAResource getXAResource() {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.getXAResource();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.delegate.getClassLoader();
    }

    public NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.replaceAsync(key, oldValue, newValue, lifespan, unit);
    }

    @Override
    public Collection<V> values() {
        this.authzManager.checkPermission(AuthorizationPermission.BULK_READ);
        return this.delegate.values();
    }

    @Override
    public AdvancedCache<K, V> with(ClassLoader classLoader) {
        return new SecureCacheImpl<K, V>(this.delegate.with(classLoader));
    }

    public NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.replaceAsync(key, oldValue, newValue, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.authzManager.checkPermission(AuthorizationPermission.BULK_READ);
        return this.delegate.entrySet();
    }

    public NotifyingFuture<V> getAsync(K key) {
        this.authzManager.checkPermission(AuthorizationPermission.READ);
        return this.delegate.getAsync(key);
    }

    @Override
    public V put(K key, V value, Metadata metadata) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.put(key, value, metadata);
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        this.delegate.putAll(m);
    }

    @Override
    public V replace(K key, V value, Metadata metadata) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.replace(key, value, metadata);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue, Metadata metadata) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.replace(key, oldValue, newValue, metadata);
    }

    public void clear() {
        this.authzManager.checkPermission(AuthorizationPermission.BULK_WRITE);
        this.delegate.clear();
    }

    @Override
    public V putIfAbsent(K key, V value, Metadata metadata) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.putIfAbsent(key, value, metadata);
    }

    @Override
    public NotifyingFuture<V> putAsync(K key, V value, Metadata metadata) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.putAsync(key, value, metadata);
    }

    @Override
    public CacheEntry getCacheEntry(K key) {
        this.authzManager.checkPermission(AuthorizationPermission.READ);
        return this.delegate.getCacheEntry(key);
    }

    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return String.format("SecureCache '%s'", this.delegate.getName());
    }
}

