/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.totalorder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.transaction.impl.TotalOrderRemoteTransactionState;
import org.infinispan.transaction.totalorder.TotalOrderLatch;
import org.infinispan.transaction.totalorder.TotalOrderLatchImpl;
import org.infinispan.util.concurrent.BlockingTaskAwareExecutorService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TotalOrderManager {
    private static final Log log = LogFactory.getLog(TotalOrderManager.class);
    private final ConcurrentMap<Object, TotalOrderLatch> keysLocked = CollectionFactory.makeConcurrentMap();
    private final AtomicReference<TotalOrderLatch> clear = new AtomicReference<Object>(null);
    private final AtomicReference<TotalOrderLatch> stateTransferInProgress = new AtomicReference<Object>(null);
    private BlockingTaskAwareExecutorService totalOrderExecutor;

    @Inject
    public void inject(@ComponentName(value="org.infinispan.executors.totalOrderExecutor") BlockingTaskAwareExecutorService totalOrderExecutor) {
        this.totalOrderExecutor = totalOrderExecutor;
    }

    public final void ensureOrder(TotalOrderRemoteTransactionState state, Object[] keysModified) throws InterruptedException {
        state.awaitUntilReset();
        TotalOrderLatchImpl transactionSynchronizedBlock = new TotalOrderLatchImpl(state.getGlobalTransaction().globalId());
        state.setTransactionSynchronizedBlock(transactionSynchronizedBlock);
        if (keysModified == null) {
            TotalOrderLatch oldClear = this.clear.get();
            if (oldClear != null) {
                state.addSynchronizedBlock(oldClear);
                this.clear.set(transactionSynchronizedBlock);
            }
            state.addAllSynchronizedBlocks(this.keysLocked.values());
            this.keysLocked.clear();
            state.addKeysLockedForClear();
        } else {
            TotalOrderLatch clearTx = this.clear.get();
            if (clearTx != null) {
                state.addSynchronizedBlock(clearTx);
            }
            for (Object key : keysModified) {
                TotalOrderLatch prevTx = this.keysLocked.put(key, transactionSynchronizedBlock);
                if (prevTx != null) {
                    state.addSynchronizedBlock(prevTx);
                }
                state.addLockedKey(key);
            }
        }
        TotalOrderLatch stateTransfer = this.stateTransferInProgress.get();
        if (stateTransfer != null) {
            state.addSynchronizedBlock(stateTransfer);
        }
        if (log.isTraceEnabled()) {
            log.tracef("Transaction [%s] will wait for %s and locked %s", state.getGlobalTransaction().globalId(), state.getConflictingTransactionBlocks(), state.getLockedKeys() == null ? "[ClearCommand]" : state.getLockedKeys());
        }
    }

    public final void release(TotalOrderRemoteTransactionState state) {
        TotalOrderLatch synchronizedBlock = state.getTransactionSynchronizedBlock();
        if (synchronizedBlock == null) {
            return;
        }
        Collection<Object> lockedKeys = state.getLockedKeys();
        synchronizedBlock.unBlock();
        if (lockedKeys == null) {
            this.clear.compareAndSet(synchronizedBlock, null);
        } else {
            for (Object key : lockedKeys) {
                this.keysLocked.remove(key, synchronizedBlock);
            }
        }
        if (log.isTraceEnabled()) {
            log.tracef("Release %s and locked keys %s. Checking pending tasks!", synchronizedBlock, lockedKeys == null ? "[ClearCommand]" : lockedKeys);
        }
        state.reset();
    }

    public final Collection<TotalOrderLatch> notifyStateTransferStart(int topologyId) {
        ArrayList<TotalOrderLatch> preparingTransactions = new ArrayList<TotalOrderLatch>(this.keysLocked.size());
        preparingTransactions.addAll(this.keysLocked.values());
        TotalOrderLatch clearBlock = this.clear.get();
        if (clearBlock != null) {
            preparingTransactions.add(clearBlock);
        }
        if (this.stateTransferInProgress.get() == null) {
            this.stateTransferInProgress.set(new TotalOrderLatchImpl("StateTransfer-" + topologyId));
        }
        if (log.isTraceEnabled()) {
            log.tracef("State Transfer start. It will wait for %s", preparingTransactions);
        }
        return preparingTransactions;
    }

    public final void notifyStateTransferEnd() {
        TotalOrderLatch block = this.stateTransferInProgress.getAndSet(null);
        if (block != null) {
            block.unBlock();
        }
        if (log.isTraceEnabled()) {
            log.tracef("State Transfer finish. It will release %s", block);
        }
        this.totalOrderExecutor.checkForReadyTasks();
    }

    public final boolean hasAnyLockAcquired() {
        return !this.keysLocked.isEmpty() || this.clear.get() != null;
    }
}

