/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.CollectionKeyFilter;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.BackupResponse;
import org.infinispan.util.ReadOnlyDataContainerBackedKeySet;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.XSiteReplicateCommand;
import org.infinispan.xsite.statetransfer.XSiteState;
import org.infinispan.xsite.statetransfer.XSiteStateProvider;
import org.infinispan.xsite.statetransfer.XSiteStatePushCommand;
import org.infinispan.xsite.statetransfer.XSiteStateTransferControlCommand;
import org.infinispan.xsite.statetransfer.XSiteStateTransferManager;

public class XSiteStateProviderImpl
implements XSiteStateProvider {
    private static final int DEFAULT_CHUNK_SIZE = 1024;
    private static final ExecutorService EXECUTOR_SERVICE = new WithinThreadExecutor();
    private static final Log log = LogFactory.getLog(XSiteStateProviderImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final boolean debug = log.isDebugEnabled();
    private final ConcurrentMap<String, StateProviderRunnable> runningStateTransfer = CollectionFactory.makeConcurrentMap();
    private DataContainer<Object, Object> dataContainer;
    private PersistenceManager persistenceManager;
    private ClusteringDependentLogic clusteringDependentLogic;
    private CommandsFactory commandsFactory;
    private RpcManager rpcManager;
    private ExecutorService executorService;
    private Configuration configuration;
    private XSiteStateTransferManager stateTransferManager;

    @Inject
    public void inject(DataContainer dataContainer, PersistenceManager persistenceManager, RpcManager rpcManager, ClusteringDependentLogic clusteringDependentLogic, CommandsFactory commandsFactory, @ComponentName(value="org.infinispan.executors.transport") ExecutorService executorService, Configuration configuration, XSiteStateTransferManager stateTransferManager) {
        this.dataContainer = dataContainer;
        this.persistenceManager = persistenceManager;
        this.clusteringDependentLogic = clusteringDependentLogic;
        this.commandsFactory = commandsFactory;
        this.rpcManager = rpcManager;
        this.executorService = executorService;
        this.configuration = configuration;
        this.stateTransferManager = stateTransferManager;
    }

    @Override
    public void startStateTransfer(String siteName, Address origin) {
        int chunkSize = 0;
        long timeout = 0L;
        boolean found = false;
        for (BackupConfiguration backupConfiguration : this.configuration.sites().allBackups()) {
            if (!backupConfiguration.site().equals(siteName)) continue;
            chunkSize = backupConfiguration.stateTransfer().chunkSize();
            timeout = backupConfiguration.stateTransfer().timeout();
            found = true;
            break;
        }
        if (!found) {
            throw new CacheException("Unable to start X-Site State Transfer! Backup configuration not found for " + siteName + "!");
        }
        StateProviderRunnable runnable = new StateProviderRunnable(siteName, chunkSize, timeout, origin);
        if (this.runningStateTransfer.putIfAbsent(siteName, runnable) == null) {
            if (debug) {
                log.debugf("Starting state transfer to site '%s'", siteName);
            }
            this.executorService.execute(runnable);
        } else if (debug) {
            log.debugf("Do not start state transfer to site '%s'. It has already started!", siteName);
        }
    }

    @Override
    public void cancelStateTransfer(String siteName) {
        StateProviderRunnable runnable = (StateProviderRunnable)this.runningStateTransfer.remove(siteName);
        if (runnable != null) {
            runnable.canceled.set(true);
        }
    }

    @Override
    public Collection<String> getCurrentStateSending() {
        return new ArrayList<String>(this.runningStateTransfer.keySet());
    }

    private void notifyStateTransferEnd(final String siteName, final Address origin) {
        this.runningStateTransfer.remove(siteName);
        if (this.rpcManager.getAddress().equals(origin)) {
            this.executorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        XSiteStateProviderImpl.this.stateTransferManager.notifyStatePushFinished(siteName, origin);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return null;
                }
            });
        } else {
            XSiteStateTransferControlCommand command = this.commandsFactory.buildXSiteStateTransferControlCommand(XSiteStateTransferControlCommand.StateTransferControl.FINISH_SEND, siteName);
            this.rpcManager.invokeRemotely(Collections.singleton(origin), (ReplicableCommand)command, this.rpcManager.getDefaultRpcOptions(false));
        }
    }

    private boolean shouldSendKey(Object key) {
        return this.clusteringDependentLogic.localNodeIsPrimaryOwner(key);
    }

    private void sendFromSharedBuffer(XSiteBackup xSiteBackup, List<XSiteState> sharedBuffer, Collection<BackupResponse> responses) throws Exception {
        if (sharedBuffer.size() == 0) {
            return;
        }
        Object[] privateBuffer = sharedBuffer.toArray(new XSiteState[sharedBuffer.size()]);
        if (debug) {
            log.debugf("Sending chunk to site '%s'. Chunk has %s keys.", xSiteBackup.getSiteName(), privateBuffer.length);
        } else if (trace) {
            log.debugf("Sending chunk to site '%s'. Chunk contains %s", xSiteBackup.getSiteName(), Arrays.toString(privateBuffer));
        }
        XSiteStatePushCommand command = this.commandsFactory.buildXSiteStatePushCommand((XSiteState[])privateBuffer);
        responses.add(this.invokeRemotelyInRemoteSite(command, xSiteBackup));
    }

    private BackupResponse invokeRemotelyInRemoteSite(XSiteReplicateCommand command, XSiteBackup xSiteBackup) throws Exception {
        return this.rpcManager.getTransport().backupRemotely(Collections.singletonList(xSiteBackup), command);
    }

    private class StateTransferCacheLoaderTask
    implements AdvancedCacheLoader.CacheLoaderTask<Object, Object> {
        private final List<XSiteState> chunk;
        private final XSiteBackup xSiteBackup;
        private final Collection<BackupResponse> responses;
        private final AtomicBoolean canceled;
        private final int chunkSize;

        private StateTransferCacheLoaderTask(XSiteBackup xSiteBackup, List<XSiteState> chunk, int chunkSize, Collection<BackupResponse> responses, AtomicBoolean canceled) {
            this.xSiteBackup = xSiteBackup;
            this.chunk = chunk;
            this.chunkSize = chunkSize;
            this.responses = responses;
            this.canceled = canceled;
        }

        @Override
        public void processEntry(MarshalledEntry<Object, Object> marshalledEntry, AdvancedCacheLoader.TaskContext taskContext) throws InterruptedException {
            if (this.canceled.get()) {
                taskContext.stop();
                return;
            }
            if (this.chunkSize > 0 && this.chunk.size() == this.chunkSize) {
                try {
                    XSiteStateProviderImpl.this.sendFromSharedBuffer(this.xSiteBackup, this.chunk, this.responses);
                }
                catch (Exception e) {
                    log.unableToSendXSiteState(this.xSiteBackup.getSiteName(), e);
                    taskContext.stop();
                }
                this.chunk.clear();
            }
            this.chunk.add(XSiteState.fromCacheLoader(marshalledEntry));
        }

        public void sendRemainingState() throws Exception {
            if (this.chunk.size() > 0) {
                XSiteStateProviderImpl.this.sendFromSharedBuffer(this.xSiteBackup, this.chunk, this.responses);
            }
        }
    }

    private class CacheLoaderFilter
    extends CollectionKeyFilter {
        public CacheLoaderFilter(Collection rejectedKeys) {
            super(rejectedKeys);
        }

        @Override
        public boolean shouldLoadKey(Object key) {
            return XSiteStateProviderImpl.this.shouldSendKey(key) && super.shouldLoadKey(key);
        }
    }

    private class StateProviderRunnable
    implements Runnable {
        private final XSiteBackup xSiteBackup;
        private final int chunkSize;
        private final Address origin;
        private final AtomicBoolean canceled;

        private StateProviderRunnable(String siteName, int chunkSize, long timeout, Address origin) {
            this.chunkSize = chunkSize;
            this.origin = origin;
            this.xSiteBackup = new XSiteBackup(siteName, true, timeout);
            this.canceled = new AtomicBoolean(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                AdvancedCacheLoader stProvider;
                ArrayList<XSiteState> chunk = new ArrayList<XSiteState>(this.chunkSize <= 0 ? 1024 : this.chunkSize);
                LinkedList backupResponseQueue = new LinkedList();
                if (debug) {
                    log.debugf("[X-Site State Transfer - %s] start DataContainer iteration", this.xSiteBackup.getSiteName());
                }
                for (InternalCacheEntry ice : XSiteStateProviderImpl.this.dataContainer) {
                    if (this.canceled.get()) {
                        return;
                    }
                    if (this.chunkSize > 0 && chunk.size() == this.chunkSize) {
                        try {
                            XSiteStateProviderImpl.this.sendFromSharedBuffer(this.xSiteBackup, chunk, backupResponseQueue);
                        }
                        catch (Exception e) {
                            log.unableToSendXSiteState(this.xSiteBackup.getSiteName(), e);
                            XSiteStateProviderImpl.this.notifyStateTransferEnd(this.xSiteBackup.getSiteName(), this.origin);
                            return;
                        }
                        chunk.clear();
                    }
                    if (!XSiteStateProviderImpl.this.shouldSendKey(ice.getKey())) continue;
                    chunk.add(XSiteState.fromDataContainer(ice));
                }
                if (this.canceled.get()) {
                    return;
                }
                if (chunk.size() > 0) {
                    try {
                        XSiteStateProviderImpl.this.sendFromSharedBuffer(this.xSiteBackup, chunk, backupResponseQueue);
                    }
                    catch (Exception e) {
                        log.unableToSendXSiteState(this.xSiteBackup.getSiteName(), e);
                        XSiteStateProviderImpl.this.notifyStateTransferEnd(this.xSiteBackup.getSiteName(), this.origin);
                        return;
                    }
                }
                if (debug) {
                    log.debugf("[X-Site State Transfer - %s] finish DataContainer iteration", this.xSiteBackup.getSiteName());
                }
                if ((stProvider = XSiteStateProviderImpl.this.persistenceManager.getStateTransferProvider()) != null) {
                    StateTransferCacheLoaderTask task;
                    block34: {
                        if (debug) {
                            log.debugf("[X-Site State Transfer - %s] start Persistence iteration", this.xSiteBackup.getSiteName());
                        }
                        CacheLoaderFilter filter = new CacheLoaderFilter(new ReadOnlyDataContainerBackedKeySet(XSiteStateProviderImpl.this.dataContainer));
                        task = new StateTransferCacheLoaderTask(this.xSiteBackup, chunk, this.chunkSize, backupResponseQueue, this.canceled);
                        stProvider.process(filter, task, EXECUTOR_SERVICE, true, true);
                        if (!this.canceled.get()) break block34;
                        return;
                    }
                    try {
                        task.sendRemainingState();
                    }
                    catch (CacheException e) {
                        log.failedLoadingKeysFromCacheStore((Exception)((Object)e));
                    }
                    catch (Exception e) {
                        log.unableToSendXSiteState(this.xSiteBackup.getSiteName(), e);
                    }
                    if (debug) {
                        log.debugf("[X-Site State Transfer - %s] finish Persistence iteration", this.xSiteBackup.getSiteName());
                    }
                } else if (debug) {
                    log.debugf("[X-Site State Transfer - %s] skip Persistence iteration", this.xSiteBackup.getSiteName());
                }
                BackupResponse response = (BackupResponse)backupResponseQueue.poll();
                while (response != null) {
                    if (this.canceled.get()) {
                        return;
                    }
                    try {
                        response.waitForBackupToFinish();
                    }
                    catch (Exception e) {
                        log.unableToWaitForXSiteStateAcks(this.xSiteBackup.getSiteName(), e);
                        XSiteStateProviderImpl.this.notifyStateTransferEnd(this.xSiteBackup.getSiteName(), this.origin);
                        return;
                    }
                    response = (BackupResponse)backupResponseQueue.poll();
                }
            }
            finally {
                XSiteStateProviderImpl.this.notifyStateTransferEnd(this.xSiteBackup.getSiteName(), this.origin);
            }
        }
    }
}

