/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.auth.sasl;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.auth.sasl.SaslContext;
import org.jgroups.protocols.SASL;
import org.jgroups.protocols.SaslHeader;

public class SaslServerContext
implements SaslContext {
    SaslServer server;
    CountDownLatch latch = new CountDownLatch(1);

    public SaslServerContext(String mech, Address local_addr, CallbackHandler callback_handler, Map<String, String> props) throws SaslException {
        this.server = Sasl.createSaslServer(mech, "jgroups", local_addr.toString(), props, callback_handler);
    }

    @Override
    public boolean isSuccessful() {
        return this.server.isComplete();
    }

    @Override
    public boolean needsWrapping() {
        if (this.server.isComplete()) {
            String qop = (String)this.server.getNegotiatedProperty("javax.security.sasl.qop");
            return qop != null && (qop.equalsIgnoreCase("auth-int") || qop.equalsIgnoreCase("auth-conf"));
        }
        return false;
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        return this.server.wrap(outgoing, offset, len);
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        return this.server.unwrap(incoming, offset, len);
    }

    @Override
    public Message nextMessage(Address address, SaslHeader header) throws SaslException {
        Message message = new Message(address).setFlag(Message.Flag.OOB);
        byte[] challenge = this.server.evaluateResponse(header.getPayload());
        if (this.server.isComplete()) {
            this.latch.countDown();
        }
        if (challenge != null) {
            return message.putHeader(SASL.SASL_ID, new SaslHeader(SaslHeader.Type.RESPONSE, challenge));
        }
        return null;
    }

    public void awaitCompletion(long timeout) throws InterruptedException {
        this.latch.await(timeout, TimeUnit.MILLISECONDS);
    }

    public String getAuthorizationID() {
        return this.server.getAuthorizationID();
    }

    @Override
    public void dispose() {
        try {
            this.server.dispose();
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }
}

