/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.lang.reflect.Method;
import java.util.Collection;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.util.Buffer;
import org.jgroups.util.FutureListener;
import org.jgroups.util.NotifyingFuture;
import org.jgroups.util.NullFuture;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class RpcDispatcher
extends MessageDispatcher {
    protected Object server_obj = null;
    protected Marshaller req_marshaller = null;
    protected Marshaller rsp_marshaller = null;
    protected MethodLookup method_lookup = null;

    public RpcDispatcher() {
    }

    public RpcDispatcher(Channel channel, MessageListener l, MembershipListener l2, Object server_obj) {
        super(channel, l, l2);
        this.server_obj = server_obj;
    }

    public RpcDispatcher(Channel channel, Object server_obj) {
        this(channel, null, null, server_obj);
    }

    public static String getName() {
        return "RpcDispatcher";
    }

    public Marshaller getRequestMarshaller() {
        return this.req_marshaller;
    }

    public void setRequestMarshaller(Marshaller m) {
        this.req_marshaller = m;
    }

    public Marshaller getResponseMarshaller() {
        return this.rsp_marshaller;
    }

    public void setResponseMarshaller(Marshaller m) {
        this.rsp_marshaller = m;
        if (this.corr != null) {
            this.corr.setMarshaller(this.rsp_marshaller);
        }
    }

    public Marshaller getMarshaller() {
        return this.req_marshaller;
    }

    public void setMarshaller(Marshaller m) {
        this.setRequestMarshaller(m);
    }

    public Object getServerObject() {
        return this.server_obj;
    }

    public void setServerObject(Object server_obj) {
        this.server_obj = server_obj;
    }

    public MethodLookup getMethodLookup() {
        return this.method_lookup;
    }

    public void setMethodLookup(MethodLookup method_lookup) {
        this.method_lookup = method_lookup;
    }

    public <T> RspList<T> callRemoteMethods(Collection<Address> dests, String method_name, Object[] args, Class[] types, RequestOptions options) throws Exception {
        MethodCall method_call = new MethodCall(method_name, args, types);
        return this.callRemoteMethods(dests, method_call, options);
    }

    public <T> RspList<T> callRemoteMethods(Collection<Address> dests, MethodCall method_call, RequestOptions options) throws Exception {
        if (dests != null && dests.isEmpty()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("destination list of " + method_call.getName() + "() is empty: no need to send message");
            }
            return new RspList();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(new StringBuilder("dests=").append(dests).append(", method_call=").append(method_call).append(", options=").append(options));
        }
        byte[] buf = this.req_marshaller != null ? (Object)this.req_marshaller.objectToBuffer(method_call) : Util.objectToByteBuffer(method_call);
        Message msg = new Message();
        if (buf instanceof Buffer) {
            msg.setBuffer((Buffer)buf);
        } else {
            msg.setBuffer(buf);
        }
        if (options != null) {
            msg.setFlag(options.getFlags());
            if (options.getScope() > 0) {
                msg.setScope(options.getScope());
            }
        }
        RspList retval = super.castMessage(dests, msg, options);
        if (this.log.isTraceEnabled()) {
            this.log.trace("responses: " + retval);
        }
        return retval;
    }

    public <T> NotifyingFuture<RspList<T>> callRemoteMethodsWithFuture(Collection<Address> dests, MethodCall method_call, RequestOptions options, FutureListener<T> listener) throws Exception {
        if (dests != null && dests.isEmpty()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(new StringBuilder("destination list of ").append(method_call.getName()).append("() is empty: no need to send message"));
            }
            return new NullFuture(new RspList());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(new StringBuilder("dests=").append(dests).append(", method_call=").append(method_call).append(", options=").append(options));
        }
        byte[] buf = this.req_marshaller != null ? (Object)this.req_marshaller.objectToBuffer(method_call) : Util.objectToByteBuffer(method_call);
        Message msg = new Message();
        if (buf instanceof Buffer) {
            msg.setBuffer((Buffer)buf);
        } else {
            msg.setBuffer(buf);
        }
        if (options != null) {
            msg.setFlag(options.getFlags());
            if (options.getScope() > 0) {
                msg.setScope(options.getScope());
            }
        }
        NotifyingFuture<RspList<T>> retval = super.castMessageWithFuture(dests, msg, options, listener);
        if (this.log.isTraceEnabled()) {
            this.log.trace("responses: " + retval);
        }
        return retval;
    }

    public <T> NotifyingFuture<RspList<T>> callRemoteMethodsWithFuture(Collection<Address> dests, MethodCall method_call, RequestOptions options) throws Exception {
        return this.callRemoteMethodsWithFuture(dests, method_call, options, null);
    }

    public <T> T callRemoteMethod(Address dest, String method_name, Object[] args, Class[] types, RequestOptions options) throws Exception {
        MethodCall method_call = new MethodCall(method_name, args, types);
        return this.callRemoteMethod(dest, method_call, options);
    }

    public <T> T callRemoteMethod(Address dest, MethodCall call, RequestOptions options) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace("dest=" + dest + ", method_call=" + call + ", options=" + options);
        }
        byte[] buf = this.req_marshaller != null ? (Object)this.req_marshaller.objectToBuffer(call) : Util.objectToByteBuffer(call);
        Message msg = new Message(dest, null, null);
        if (buf instanceof Buffer) {
            msg.setBuffer((Buffer)buf);
        } else {
            msg.setBuffer(buf);
        }
        if (options != null) {
            msg.setFlag(options.getFlags());
            if (options.getScope() > 0) {
                msg.setScope(options.getScope());
            }
        }
        Object retval = super.sendMessage(msg, options);
        if (this.log.isTraceEnabled()) {
            this.log.trace("retval: " + retval);
        }
        return retval;
    }

    public <T> NotifyingFuture<T> callRemoteMethodWithFuture(Address dest, MethodCall call, RequestOptions options, FutureListener<T> listener) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace("dest=" + dest + ", method_call=" + call + ", options=" + options);
        }
        byte[] buf = this.req_marshaller != null ? (Object)this.req_marshaller.objectToBuffer(call) : Util.objectToByteBuffer(call);
        Message msg = new Message(dest, null, null);
        if (buf instanceof Buffer) {
            msg.setBuffer((Buffer)buf);
        } else {
            msg.setBuffer(buf);
        }
        if (options != null) {
            msg.setFlag(options.getFlags());
            if (options.getScope() > 0) {
                msg.setScope(options.getScope());
            }
        }
        return super.sendMessageWithFuture(msg, options, listener);
    }

    public <T> NotifyingFuture<T> callRemoteMethodWithFuture(Address dest, MethodCall call, RequestOptions options) throws Exception {
        return this.callRemoteMethodWithFuture(dest, call, options, null);
    }

    @Override
    protected void correlatorStarted() {
        if (this.corr != null) {
            this.corr.setMarshaller(this.rsp_marshaller);
        }
    }

    @Override
    public Object handle(Message req) throws Exception {
        Object body;
        if (this.server_obj == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("no method handler is registered. Discarding request.");
            }
            return null;
        }
        if (req == null || req.getLength() == 0) {
            if (this.log.isErrorEnabled()) {
                this.log.error("message or message buffer is null");
            }
            return null;
        }
        Object object = body = this.req_marshaller != null ? this.req_marshaller.objectFromBuffer(req.getRawBuffer(), req.getOffset(), req.getLength()) : req.getObject();
        if (!(body instanceof MethodCall)) {
            throw new IllegalArgumentException("message does not contain a MethodCall object");
        }
        MethodCall method_call = (MethodCall)body;
        if (this.log.isTraceEnabled()) {
            this.log.trace("[sender=" + req.getSrc() + "], method_call: " + method_call);
        }
        if (method_call.getMode() == 3) {
            if (this.method_lookup == null) {
                throw new Exception("MethodCall uses ID=" + method_call.getId() + ", but method_lookup has not been set");
            }
            Method m = this.method_lookup.findMethod(method_call.getId());
            if (m == null) {
                throw new Exception("no method found for " + method_call.getId());
            }
            method_call.setMethod(m);
        }
        return method_call.invoke(this.server_obj);
    }

    public static interface Marshaller {
        public Buffer objectToBuffer(Object var1) throws Exception;

        public Object objectFromBuffer(byte[] var1, int var2, int var3) throws Exception;
    }
}

