/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.relay.config;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jgroups.JChannel;
import org.jgroups.stack.Protocol;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RelayConfig {
    protected static final String RELAY_CONFIG = "RelayConfiguration";
    protected static final String SITES = "sites";
    protected static final String SITE = "site";
    protected static final String BRIDGES = "bridges";
    protected static final String BRIDGE = "bridge";
    protected static final String FORWARDS = "forwards";
    protected static final String FORWARD = "forward";

    public static void parse(InputStream input, Map<String, SiteConfig> map) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(input);
        Element root = document.getDocumentElement();
        RelayConfig.match(RELAY_CONFIG, root.getNodeName(), true);
        NodeList children = root.getChildNodes();
        if (children == null || children.getLength() == 0) {
            return;
        }
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            String element_name = node.getNodeName();
            if (SITES.equals(element_name)) {
                RelayConfig.parseSites(map, node);
                continue;
            }
            throw new Exception("expected <sites>, but got <" + element_name + ">");
        }
    }

    protected static void parseSites(Map<String, SiteConfig> map, Node root) throws Exception {
        NodeList children = root.getChildNodes();
        if (children == null || children.getLength() == 0) {
            return;
        }
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            RelayConfig.match(SITE, node.getNodeName(), true);
            NamedNodeMap attrs = node.getAttributes();
            if (attrs == null || attrs.getLength() == 0) continue;
            Attr name_attr = (Attr)attrs.getNamedItem("name");
            String name = name_attr.getValue();
            if (map.containsKey(name)) {
                throw new Exception("Site \"" + name + "\" already defined");
            }
            SiteConfig site_config = new SiteConfig(name);
            map.put(name, site_config);
            RelayConfig.parseBridgesAndForwards(site_config, node);
        }
    }

    protected static void parseBridgesAndForwards(SiteConfig site_config, Node root) throws Exception {
        NodeList children = root.getChildNodes();
        if (children == null || children.getLength() == 0) {
            return;
        }
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            String node_name = node.getNodeName();
            if (BRIDGES.equals(node_name)) {
                RelayConfig.parseBridges(site_config, node);
                continue;
            }
            if (FORWARDS.equals(node_name)) {
                RelayConfig.parseForwards(site_config, node);
                continue;
            }
            throw new Exception("expected \"bridges\" or \"forwards\" keywords");
        }
    }

    protected static void parseBridges(SiteConfig site_config, Node root) throws Exception {
        NodeList children = root.getChildNodes();
        if (children == null || children.getLength() == 0) {
            return;
        }
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            String node_name = node.getNodeName();
            RelayConfig.match(BRIDGE, node_name, true);
            NamedNodeMap attrs = node.getAttributes();
            if (attrs == null || attrs.getLength() == 0) continue;
            Attr name_attr = (Attr)attrs.getNamedItem("name");
            Attr config_attr = (Attr)attrs.getNamedItem("config");
            String name = name_attr != null ? name_attr.getValue() : null;
            String config = config_attr.getValue();
            PropertiesBridgeConfig bridge_config = new PropertiesBridgeConfig(name, config);
            site_config.addBridge(bridge_config);
        }
    }

    protected static void parseForwards(SiteConfig site_config, Node root) throws Exception {
        NodeList children = root.getChildNodes();
        if (children == null || children.getLength() == 0) {
            return;
        }
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            String node_name = node.getNodeName();
            RelayConfig.match(FORWARD, node_name, true);
            NamedNodeMap attrs = node.getAttributes();
            if (attrs == null || attrs.getLength() == 0) continue;
            Attr to_attr = (Attr)attrs.getNamedItem("to");
            Attr gw_attr = (Attr)attrs.getNamedItem("gateway");
            String to = to_attr.getValue();
            String gateway = gw_attr.getValue();
            ForwardConfig forward_config = new ForwardConfig(to, gateway);
            site_config.addForward(forward_config);
        }
    }

    protected static void match(String expected_name, String name, boolean is_element) throws Exception {
        if (!expected_name.equals(name)) {
            throw new Exception((is_element ? "Element " : "Attribute ") + "\"" + name + "\" didn't match \"" + expected_name + "\"");
        }
    }

    public static void main(String[] args) throws Exception {
        FileInputStream input = new FileInputStream("/home/bela/relay2.xml");
        HashMap<String, SiteConfig> sites = new HashMap<String, SiteConfig>();
        RelayConfig.parse(input, sites);
        System.out.println("sites:");
        for (Map.Entry entry : sites.entrySet()) {
            System.out.println((String)entry.getKey() + ":\n" + entry.getValue() + "\n");
        }
    }

    public static class ForwardConfig {
        protected final String to;
        protected final String gateway;

        public ForwardConfig(String to, String gateway) {
            this.to = to;
            this.gateway = gateway;
        }

        public String getGateway() {
            return this.gateway;
        }

        public String getTo() {
            return this.to;
        }

        public String toString() {
            return "forward to=" + this.to + " gateway=" + this.gateway;
        }
    }

    public static class ProgrammaticBridgeConfig
    extends BridgeConfig {
        protected Protocol[] protocols;

        public ProgrammaticBridgeConfig(String cluster_name, Protocol[] prots) {
            super(cluster_name);
            this.protocols = prots;
        }

        @Override
        public JChannel createChannel() throws Exception {
            return new JChannel(this.protocols);
        }

        @Override
        public String toString() {
            return super.toString() + ", protocols=" + ProgrammaticBridgeConfig.printProtocols(this.protocols);
        }

        protected static String printProtocols(Protocol[] protocols) {
            StringBuilder sb = new StringBuilder("[");
            boolean first = true;
            for (Protocol prot : protocols) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(prot.getName());
            }
            sb.append("]");
            return sb.toString();
        }
    }

    public static class PropertiesBridgeConfig
    extends BridgeConfig {
        protected final String config;

        public PropertiesBridgeConfig(String cluster_name, String config) {
            super(cluster_name);
            this.config = config;
        }

        @Override
        public JChannel createChannel() throws Exception {
            return new JChannel(this.config);
        }

        @Override
        public String toString() {
            return "config=" + this.config + super.toString();
        }
    }

    public static abstract class BridgeConfig {
        protected final String cluster_name;

        protected BridgeConfig(String cluster_name) {
            this.cluster_name = cluster_name;
        }

        public String getClusterName() {
            return this.cluster_name;
        }

        public abstract JChannel createChannel() throws Exception;

        public String toString() {
            return "cluster=" + this.cluster_name;
        }
    }

    public static class SiteConfig {
        protected final String name;
        protected final List<BridgeConfig> bridges = new ArrayList<BridgeConfig>();
        protected final List<ForwardConfig> forwards = new ArrayList<ForwardConfig>();

        public SiteConfig(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<BridgeConfig> getBridges() {
            return this.bridges;
        }

        public List<ForwardConfig> getForwards() {
            return this.forwards;
        }

        public SiteConfig addBridge(BridgeConfig bridge_config) {
            this.bridges.add(bridge_config);
            return this;
        }

        public SiteConfig addForward(ForwardConfig forward_config) {
            this.forwards.add(forward_config);
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("name=" + this.name + "\n");
            if (!this.bridges.isEmpty()) {
                for (BridgeConfig bridge_config : this.bridges) {
                    sb.append(bridge_config).append("\n");
                }
            }
            if (!this.forwards.isEmpty()) {
                for (ForwardConfig forward_config : this.forwards) {
                    sb.append(forward_config).append("\n");
                }
            }
            return sb.toString();
        }
    }
}

