/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.PhysicalAddress;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.TUNNEL;
import org.jgroups.stack.GossipData;
import org.jgroups.util.Util;

public class RouterStub
implements Comparable<RouterStub> {
    protected final String router_host;
    protected final int router_port;
    protected Socket sock = null;
    protected DataOutputStream output = null;
    protected DataInputStream input = null;
    protected volatile ConnectionStatus connectionState = ConnectionStatus.INITIAL;
    protected static final Log log = LogFactory.getLog(RouterStub.class);
    protected final ConnectionListener conn_listener;
    protected final InetAddress bind_addr;
    protected int sock_conn_timeout = 3000;
    protected int sock_read_timeout = 3000;
    protected boolean tcp_nodelay = true;
    protected volatile TUNNEL.StubReceiver receiver;
    protected final ReentrantLock lock = new ReentrantLock();

    public RouterStub(String routerHost, int routerPort, InetAddress bindAddress, ConnectionListener l) {
        this.router_host = routerHost != null ? routerHost : "localhost";
        this.router_port = routerPort;
        this.bind_addr = bindAddress;
        this.conn_listener = l;
    }

    public RouterStub(InetSocketAddress addr) {
        this(addr.getHostName(), addr.getPort(), null, null);
    }

    public void setReceiver(TUNNEL.StubReceiver receiver) {
        this.receiver = receiver;
    }

    public TUNNEL.StubReceiver getReceiver() {
        return this.receiver;
    }

    public boolean isTcpNoDelay() {
        return this.tcp_nodelay;
    }

    public void setTcpNoDelay(boolean tcp_nodelay) {
        this.tcp_nodelay = tcp_nodelay;
    }

    @Override
    public int compareTo(RouterStub o) {
        int rc = this.router_host.compareTo(o.router_host);
        if (rc != 0) {
            return rc;
        }
        return this.router_port < o.router_port ? -1 : (this.router_port > o.router_port ? 1 : 0);
    }

    public boolean equals(Object obj) {
        RouterStub o = (RouterStub)obj;
        return this.compareTo(o) == 0;
    }

    public int hashCode() {
        return this.router_host.hashCode() + this.router_port;
    }

    public void interrupt() {
        Thread thread;
        TUNNEL.StubReceiver tmp = this.receiver;
        if (tmp != null && (thread = tmp.getThread()) != null) {
            thread.interrupt();
        }
    }

    public void join(long wait) throws InterruptedException {
        Thread thread;
        TUNNEL.StubReceiver tmp = this.receiver;
        if (tmp != null && (thread = tmp.getThread()) != null) {
            thread.join(wait);
        }
    }

    public int getSocketConnectionTimeout() {
        return this.sock_conn_timeout;
    }

    public void setSocketConnectionTimeout(int sock_conn_timeout) {
        this.sock_conn_timeout = sock_conn_timeout;
    }

    public int getSocketReadTimeout() {
        return this.sock_read_timeout;
    }

    public void setSocketReadTimeout(int sock_read_timeout) {
        this.sock_read_timeout = sock_read_timeout;
    }

    public boolean isConnected() {
        return this.connectionState != ConnectionStatus.CONNECTION_BROKEN && this.connectionState != ConnectionStatus.INITIAL;
    }

    public ConnectionStatus getConnectionStatus() {
        return this.connectionState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String group, Address addr, String logical_name, List<PhysicalAddress> phys_addrs) throws Exception {
        block5: {
            this.lock.lock();
            try {
                this._doConnect();
                GossipData request = new GossipData(1, group, addr, logical_name, phys_addrs);
                request.writeTo(this.output);
                this.output.flush();
                byte result = this.input.readByte();
                if (result == 14) {
                    this.connectionStateChanged(ConnectionStatus.CONNECTED);
                    break block5;
                }
                this.connectionStateChanged(ConnectionStatus.DISCONNECTED);
                throw new Exception("Connect failed received from GR " + this.getGossipRouterAddress());
            }
            finally {
                if (this.lock.isHeldByCurrentThread()) {
                    this.lock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doConnect() throws Exception {
        this.lock.lock();
        try {
            this._doConnect();
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    protected void _doConnect() throws Exception {
        if (!this.isConnected()) {
            try {
                this.sock = new Socket();
                InetSocketAddress dest = new InetSocketAddress(this.router_host, this.router_port);
                InetAddress tmp_bind_addr = this.bind_addr;
                if (!Util.sameAddresses(this.bind_addr, tmp_bind_addr)) {
                    tmp_bind_addr = null;
                }
                this.sock.bind(new InetSocketAddress(tmp_bind_addr, 0));
                this.sock.setSoTimeout(this.sock_read_timeout);
                this.sock.setSoLinger(true, 2);
                this.sock.setTcpNoDelay(this.tcp_nodelay);
                this.sock.setKeepAlive(true);
                Util.connect(this.sock, dest, this.sock_conn_timeout);
                this.output = new DataOutputStream(this.sock.getOutputStream());
                this.input = new DataInputStream(this.sock.getInputStream());
                this.connectionStateChanged(ConnectionStatus.CONNECTION_ESTABLISHED);
            }
            catch (Exception e) {
                Util.close(this.sock);
                Util.close((Closeable)this.input);
                Util.close((Closeable)this.output);
                this.connectionStateChanged(ConnectionStatus.CONNECTION_BROKEN);
                throw new Exception("Could not connect to " + this.getGossipRouterAddress(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkConnection() {
        GossipData request = new GossipData(12);
        this.lock.lock();
        try {
            request.writeTo(this.output);
            this.output.flush();
        }
        catch (Exception e) {
            this.connectionStateChanged(ConnectionStatus.CONNECTION_BROKEN);
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(String group, Address addr) {
        this.lock.lock();
        try {
            GossipData request = new GossipData(2, group, addr);
            request.writeTo(this.output);
            this.output.flush();
        }
        catch (Exception exception) {
        }
        finally {
            this.connectionStateChanged(ConnectionStatus.DISCONNECTED);
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.lock.lock();
        try {
            GossipData request = new GossipData(13);
            request.writeTo(this.output);
            this.output.flush();
        }
        catch (Exception exception) {
        }
        finally {
            Util.close((Closeable)this.output);
            Util.close((Closeable)this.input);
            Util.close(this.sock);
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    public Socket getSocket() {
        return this.sock;
    }

    public List<PingData> getMembers(String group) throws Exception {
        ArrayList<PingData> retval = new ArrayList<PingData>();
        this.lock.lock();
        try {
            if (!this.isConnected() || this.input == null) {
                throw new Exception("not connected");
            }
            if (this.input.available() > 0) {
                this.input.skipBytes(this.input.available());
            }
            GossipData request = new GossipData(4, group, null);
            request.writeTo(this.output);
            this.output.flush();
            int num_rsps = this.input.readShort();
            for (int i = 0; i < num_rsps; ++i) {
                PingData rsp = new PingData();
                rsp.readFrom(this.input);
                retval.add(rsp);
            }
            ArrayList<PingData> arrayList = retval;
            return arrayList;
        }
        catch (Exception e) {
            this.connectionStateChanged(ConnectionStatus.CONNECTION_BROKEN);
            throw new Exception("Connection to " + this.getGossipRouterAddress() + " broken. Could not send GOSSIP_GET request", e);
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    public InetSocketAddress getGossipRouterAddress() {
        return new InetSocketAddress(this.router_host, this.router_port);
    }

    public String toString() {
        return "RouterStub[localsocket=" + (this.sock != null ? this.sock.getLocalSocketAddress() : "null") + ",router_host=" + this.router_host + "::" + this.router_port + ",connected=" + this.isConnected() + "]";
    }

    public void sendToAllMembers(String group, byte[] data, int offset, int length) throws Exception {
        this.sendToMember(group, null, data, offset, length);
    }

    public void sendToMember(String group, Address dest, byte[] data, int offset, int length) throws Exception {
        this.lock.lock();
        try {
            GossipData request = new GossipData(10, group, dest, data, offset, length);
            request.writeTo(this.output);
            this.output.flush();
        }
        catch (Exception e) {
            this.connectionStateChanged(ConnectionStatus.CONNECTION_BROKEN);
            throw new Exception("Connection to " + this.getGossipRouterAddress() + " broken. Could not send message to " + dest, e);
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    public DataInputStream getInputStream() {
        return this.input;
    }

    protected void connectionStateChanged(ConnectionStatus newState) {
        boolean notify = this.connectionState != newState;
        this.connectionState = newState;
        if (notify && this.conn_listener != null) {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
            try {
                this.conn_listener.connectionStatusChange(this, newState);
            }
            catch (Throwable t) {
                log.error("failed notifying ConnectionListener " + this.conn_listener, t);
            }
        }
    }

    public static interface ConnectionListener {
        public void connectionStatusChange(RouterStub var1, ConnectionStatus var2);
    }

    public static enum ConnectionStatus {
        INITIAL,
        CONNECTION_BROKEN,
        CONNECTION_ESTABLISHED,
        CONNECTED,
        DISCONNECTED;

    }
}

