/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.protocols.ENCRYPT;
import org.jgroups.stack.Protocol;

public class bla2 {
    protected static final int NUM_SENDERS = 10;
    protected static final int cipher_pool_size = 16;
    protected static final int NUM_MSGS = 10000;
    protected static final int SIZE = 1000;
    protected static final int EXPECTED_MSGS = 100000;
    protected ENCRYPT encrypt;

    void start() throws Exception {
        this.encrypt = new ENCRYPT();
        TimingProtocol timing_prot = new TimingProtocol();
        this.encrypt.setValue("cipher_pool_size", 16);
        this.encrypt.setValue("suppliedKey", true);
        this.encrypt.setValue("keyStoreName", "/home/bela/keystore/defaultStore.keystore");
        this.encrypt.init();
        this.encrypt.setDownProtocol(timing_prot);
        timing_prot.setUpProtocol(this.encrypt);
        CountDownLatch latch = new CountDownLatch(11);
        Sender[] senders = new Sender[10];
        for (int i = 0; i < senders.length; ++i) {
            senders[i] = new Sender(this.encrypt, 10000, latch);
            senders[i].start();
        }
        timing_prot.startTimer();
        latch.countDown();
        for (Sender sender : senders) {
            sender.join();
        }
        double msgs_per_sec = 100000.0 / ((double)timing_prot.time / 1000.0);
        System.out.printf("time for %d messages: %d ms: %.2f msgs/sec\n", 100000, timing_prot.time, msgs_per_sec);
    }

    public static void main(String[] args) throws Exception {
        new bla2().start();
    }

    protected static class Sender
    extends Thread {
        protected final ENCRYPT encrypt;
        protected final int num_msgs;
        protected final CountDownLatch latch;
        protected int PRINT;

        public Sender(ENCRYPT encrypt, int num_msgs, CountDownLatch latch) {
            this.encrypt = encrypt;
            this.num_msgs = num_msgs;
            this.latch = latch;
            this.PRINT = num_msgs / 2;
        }

        @Override
        public void run() {
            byte[] buffer = new byte[1000];
            this.latch.countDown();
            for (int i = 0; i < this.num_msgs; ++i) {
                Message msg = new Message(null, buffer);
                this.encrypt.down(new Event(1, msg));
                if (i <= 0 || i % this.PRINT != 0) continue;
                System.out.println(Thread.currentThread().getId() + ": " + i);
            }
        }
    }

    protected static class TimingProtocol
    extends Protocol {
        protected AtomicInteger num_msgs = new AtomicInteger(0);
        protected long start = 0L;
        protected long time = 0L;

        protected TimingProtocol() {
        }

        protected void startTimer() {
            this.start = System.currentTimeMillis();
        }

        @Override
        public Object down(Event evt) {
            int current;
            if (evt.getType() == 1 && (current = this.num_msgs.incrementAndGet()) >= 100000 && this.time == 0L) {
                this.time = System.currentTimeMillis() - this.start;
            }
            return null;
        }
    }
}

