/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.XSiteStateTransferConfiguration;

public class XSiteStateTransferConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<XSiteStateTransferConfiguration> {
    public static final int DEFAULT_CHUNK_SIZE = 512;
    private int chunkSize = 512;
    public static final long DEFAULT_TIMEOUT = TimeUnit.MINUTES.toMillis(20L);
    private long timeout = DEFAULT_TIMEOUT;
    private final BackupConfigurationBuilder backupConfigurationBuilder;

    public XSiteStateTransferConfigurationBuilder(ConfigurationBuilder builder, BackupConfigurationBuilder backupConfigurationBuilder) {
        super(builder);
        this.backupConfigurationBuilder = backupConfigurationBuilder;
    }

    public void validate() {
        if (this.timeout <= 0L) {
            throw new CacheConfigurationException("Timeout must be higher or equals than 1 (one).");
        }
    }

    public final XSiteStateTransferConfigurationBuilder chunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
        return this;
    }

    public final XSiteStateTransferConfigurationBuilder timeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public final BackupConfigurationBuilder backup() {
        return this.backupConfigurationBuilder;
    }

    public XSiteStateTransferConfiguration create() {
        return new XSiteStateTransferConfiguration(this.chunkSize, this.timeout);
    }

    public Builder<XSiteStateTransferConfiguration> read(XSiteStateTransferConfiguration template) {
        this.chunkSize = template.chunkSize();
        this.timeout = template.timeout();
        return this;
    }

    public String toString() {
        return "XSiteStateTransferConfigurationBuilder{chunkSize=" + this.chunkSize + ", timeout=" + this.timeout + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XSiteStateTransferConfigurationBuilder that = (XSiteStateTransferConfigurationBuilder)o;
        return this.chunkSize == that.chunkSize && this.timeout == that.timeout;
    }

    public int hashCode() {
        int result = this.chunkSize;
        result = 31 * result + (int)(this.timeout ^ this.timeout >>> 32);
        return result;
    }
}

