/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.RepeatableReadEntry;
import org.infinispan.container.entries.versioned.Versioned;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.InequalVersionComparisonResult;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.metadata.Metadata;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusteredRepeatableReadEntry
extends RepeatableReadEntry
implements Versioned {
    private static final Log log = LogFactory.getLog(ClusteredRepeatableReadEntry.class);

    public ClusteredRepeatableReadEntry(Object key, Object value, Metadata metadata) {
        super(key, value, metadata);
    }

    public boolean performWriteSkewCheck(DataContainer container, TxInvocationContext ctx, EntryVersion versionSeen, VersionGenerator versionGenerator) {
        EntryVersion prevVersion;
        if (versionSeen == null) {
            if (log.isTraceEnabled()) {
                log.tracef("Perform write skew check for key %s but the key was not read. Skipping check!", this.key);
            }
            return true;
        }
        InternalCacheEntry ice = container.get(this.key);
        if (ice == null) {
            if (log.isTraceEnabled()) {
                log.tracef("No entry for key %s found in data container", this.key);
            }
            if ((prevVersion = ((AbstractCacheTransaction)ctx.getCacheTransaction()).getLookedUpRemoteVersion(this.key)) == null) {
                if (log.isTraceEnabled()) {
                    log.tracef("No looked up remote version for key %s found in context", this.key);
                }
                return versionGenerator.nonExistingVersion().compareTo(versionSeen) == InequalVersionComparisonResult.EQUAL;
            }
        } else {
            prevVersion = ice.getMetadata().version();
            if (prevVersion == null) {
                throw new IllegalStateException("Entries cannot have null versions!");
            }
        }
        if (log.isTraceEnabled()) {
            log.tracef("Is going to compare versions %s and %s for key %s.", prevVersion, versionSeen, this.key);
        }
        InequalVersionComparisonResult result = prevVersion.compareTo(versionSeen);
        if (log.isTraceEnabled()) {
            log.tracef("Comparing versions %s and %s for key %s: %s", new Object[]{prevVersion, versionSeen, this.key, result});
        }
        return InequalVersionComparisonResult.AFTER != result;
    }

    @Override
    public EntryVersion getVersion() {
        return this.metadata.version();
    }

    @Override
    public void setVersion(EntryVersion version) {
        this.metadata = this.metadata.builder().version(version).build();
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }
}

