/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distexec.mapreduce;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.atomic.Delta;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.commands.read.MapCombineCommand;
import org.infinispan.commands.read.ReduceCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.concurrent.ParallelIterableMap;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.MapReduceCacheLoaderTask;
import org.infinispan.distexec.mapreduce.MapReduceManager;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.distexec.mapreduce.spi.MapReduceTaskLifecycleService;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.filter.CollectionKeyFilter;
import org.infinispan.filter.CompositeKeyFilter;
import org.infinispan.filter.KeyFilter;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.core.MarshalledValue;
import org.infinispan.persistence.PrimaryOwnerFilter;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class MapReduceManagerImpl
implements MapReduceManager {
    private static final Log log = LogFactory.getLog(MapReduceManagerImpl.class);
    private ClusteringDependentLogic cdl;
    private EmbeddedCacheManager cacheManager;
    private PersistenceManager persistenceManager;
    private ExecutorService executorService;
    private TimeService timeService;
    private int chunkSize;

    MapReduceManagerImpl() {
    }

    @Inject
    public void init(EmbeddedCacheManager cacheManager, PersistenceManager persistenceManager, @ComponentName(value="org.infinispan.executors.transport") ExecutorService asyncTransportExecutor, ClusteringDependentLogic cdl, TimeService timeService, Configuration configuration) {
        this.cacheManager = cacheManager;
        this.persistenceManager = persistenceManager;
        this.cdl = cdl;
        this.executorService = asyncTransportExecutor;
        this.timeService = timeService;
        this.chunkSize = configuration.clustering().stateTransfer().chunkSize();
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public <KIn, VIn, KOut, VOut> Map<KOut, List<VOut>> mapAndCombineForLocalReduction(MapCombineCommand<KIn, VIn, KOut, VOut> mcc) throws InterruptedException {
        CollectableCollector<KOut, VOut> collector = this.map(mcc);
        Map<KOut, List<VOut>> collectedValues = collector.removeCollectedValues();
        return this.combine(mcc, collectedValues);
    }

    @Override
    public <KIn, VIn, KOut, VOut> Set<KOut> mapAndCombineForDistributedReduction(MapCombineCommand<KIn, VIn, KOut, VOut> mcc) throws InterruptedException {
        try {
            return this.mapAndCombine(mcc);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public <KOut, VOut> Map<KOut, VOut> reduce(ReduceCommand<KOut, VOut> reduceCommand) throws InterruptedException {
        ConcurrentMap result = CollectionFactory.makeConcurrentMap((int)256);
        this.reduce(reduceCommand, result);
        return result;
    }

    @Override
    public <KOut, VOut> void reduce(ReduceCommand<KOut, VOut> reduceCommand, String resultCache) throws InterruptedException {
        Cache cache = this.cacheManager.getCache(resultCache);
        this.reduce(reduceCommand, (Map<KOut, VOut>)((Object)cache));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <KOut, VOut> void reduce(ReduceCommand<KOut, VOut> reduceCommand, final Map<KOut, VOut> result) throws InterruptedException {
        boolean noInputKeys;
        Set<KOut> keys = reduceCommand.getKeys();
        final String taskId = reduceCommand.getTaskId();
        boolean bl = noInputKeys = keys == null || keys.isEmpty();
        if (noInputKeys) {
            throw new IllegalStateException("Reduce phase of MapReduceTask " + taskId + " on node " + this.cdl.getAddress() + " executed with empty input keys");
        }
        final Reducer<KOut, VOut> reducer = reduceCommand.getReducer();
        final boolean useIntermediateKeys = reduceCommand.isEmitCompositeIntermediateKeys();
        MapReduceTaskLifecycleService taskLifecycleService = MapReduceTaskLifecycleService.getInstance();
        log.tracef("For m/r task %s invoking %s at %s", taskId, reduceCommand, this.cdl.getAddress());
        long start = log.isTraceEnabled() ? this.timeService.time() : 0L;
        try {
            Cache cache = this.cacheManager.getCache(reduceCommand.getCacheName());
            taskLifecycleService.onPreExecute(reducer, cache);
            IntermediateKeyFilter filter = useIntermediateKeys ? new IntermediateKeyFilter(taskId) : KeyFilter.LOAD_ALL_FILTER;
            DataContainer dc = cache.getAdvancedCache().getDataContainer();
            dc.executeTask(filter, new DataContainerTask<KOut, List<VOut>>(){

                public void apply(Object k, InternalCacheEntry v) {
                    Object key = null;
                    if (useIntermediateKeys) {
                        IntermediateCompositeKey intKey = (IntermediateCompositeKey)k;
                        key = intKey.getKey();
                    } else {
                        key = k;
                    }
                    List value = (List)this.getValue(v);
                    if (value == null) {
                        throw new IllegalStateException("Found invalid value in intermediate cache, for key " + key + " during reduce phase execution on " + MapReduceManagerImpl.this.cacheManager.getAddress() + " for M/R task " + taskId);
                    }
                    Object reduced = reducer.reduce(key, value.iterator());
                    result.put(key, reduced);
                    log.tracef("For m/r task %s reduced %s to %s at %s ", new Object[]{taskId, key, reduced, MapReduceManagerImpl.this.cdl.getAddress()});
                }
            });
        }
        finally {
            if (log.isTraceEnabled()) {
                log.tracef("Reduce for task %s took %s milliseconds", reduceCommand.getTaskId(), this.timeService.timeDuration(start, TimeUnit.MILLISECONDS));
            }
            taskLifecycleService.onPostExecute(reducer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <KIn, VIn, KOut, VOut> CollectableCollector<KOut, VOut> map(MapCombineCommand<KIn, VIn, KOut, VOut> mcc) throws InterruptedException {
        Cache cache = this.cacheManager.getCache(mcc.getCacheName());
        Set<KIn> keys = mcc.getKeys();
        final Mapper mapper = mcc.getMapper();
        boolean inputKeysSpecified = keys != null && !keys.isEmpty();
        MapReduceTaskLifecycleService taskLifecycleService = MapReduceTaskLifecycleService.getInstance();
        final DefaultCollector collector = new DefaultCollector(!inputKeysSpecified);
        DataContainer dc = cache.getAdvancedCache().getDataContainer();
        log.tracef("For m/r task %s invoking %s with input keys %s", mcc.getTaskId(), mcc, keys);
        long start = log.isTraceEnabled() ? this.timeService.time() : 0L;
        try {
            taskLifecycleService.onPreExecute(mapper, cache);
            if (inputKeysSpecified) {
                for (KIn key : keys) {
                    Object value = cache.get(key);
                    mapper.map(key, value, collector);
                }
            } else {
                dc.executeTask(new PrimaryOwnerFilter(this.cdl), new DataContainerTask<KIn, VIn>(){

                    public void apply(Object key, InternalCacheEntry v) {
                        Object value = this.getValue(v);
                        if (value != null) {
                            mapper.map(key, value, collector);
                        }
                    }
                });
            }
            if (this.persistenceManager != null && !inputKeysSpecified) {
                CompositeKeyFilter keyFilter = new CompositeKeyFilter(new PrimaryOwnerFilter(this.cdl), new CollectionKeyFilter(dc.keySet()));
                this.persistenceManager.processOnAllStores(keyFilter, new MapReduceCacheLoaderTask(mapper, collector), true, false);
            }
        }
        finally {
            if (log.isTraceEnabled()) {
                log.tracef("Map phase for task %s took %s milliseconds", mcc.getTaskId(), this.timeService.timeDuration(start, TimeUnit.MILLISECONDS));
            }
            taskLifecycleService.onPostExecute(mapper);
        }
        return collector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <KIn, VIn, KOut, VOut> Set<KOut> mapAndCombine(MapCombineCommand<KIn, VIn, KOut, VOut> mcc) throws Exception {
        Cache cache = this.cacheManager.getCache(mcc.getCacheName());
        Set<KIn> keys = mcc.getKeys();
        int maxCSize = mcc.getMaxCollectorSize();
        Mapper mapper = mcc.getMapper();
        boolean inputKeysSpecified = keys != null && !keys.isEmpty();
        MapReduceTaskLifecycleService taskLifecycleService = MapReduceTaskLifecycleService.getInstance();
        DefaultCollector c = new DefaultCollector(maxCSize, !inputKeysSpecified);
        DataContainer dc = cache.getAdvancedCache().getDataContainer();
        log.tracef("For m/r task %s invoking %s with input keys %s", mcc.getTaskId(), mcc, mcc.getKeys());
        long start = log.isTraceEnabled() ? this.timeService.time() : 0L;
        Set<KOut> intermediateKeys = Collections.synchronizedSet(new HashSet());
        try {
            taskLifecycleService.onPreExecute(mapper, cache);
            if (inputKeysSpecified) {
                for (KIn key : keys) {
                    Object value = cache.get(key);
                    mapper.map(key, value, c);
                }
                Map<KOut, List<VOut>> combinedValues = this.combine(mcc, c.removeCollectedValues());
                Set<KOut> s = this.migrateIntermediateKeysAndValues(mcc, combinedValues);
                intermediateKeys.addAll(s);
            } else {
                MapCombineTask task = new MapCombineTask(c, mcc, maxCSize);
                dc.executeTask(new PrimaryOwnerFilter(this.cdl), task);
                intermediateKeys.addAll(task.getIntermediateKeys());
                Map<KOut, List<VOut>> combinedValues = this.combine(mcc, c.removeCollectedValues());
                Set<KOut> lastOne = this.migrateIntermediateKeysAndValues(mcc, combinedValues);
                intermediateKeys.addAll(lastOne);
            }
            if (this.persistenceManager != null && !inputKeysSpecified) {
                DefaultCollector pmc = new DefaultCollector(maxCSize, true);
                CompositeKeyFilter keyFilter = new CompositeKeyFilter(new PrimaryOwnerFilter(this.cdl), new CollectionKeyFilter(dc.keySet()));
                MapCombineTask task = new MapCombineTask(pmc, mcc, maxCSize);
                this.persistenceManager.processOnAllStores(keyFilter, task, true, false);
                intermediateKeys.addAll(task.getIntermediateKeys());
                Map<KOut, List<VOut>> combinedValues = this.combine(mcc, pmc.removeCollectedValues());
                Set<KOut> lastOne = this.migrateIntermediateKeysAndValues(mcc, combinedValues);
                intermediateKeys.addAll(lastOne);
            }
        }
        finally {
            if (log.isTraceEnabled()) {
                log.tracef("Map phase for task %s took %s milliseconds", mcc.getTaskId(), this.timeService.timeDuration(start, TimeUnit.MILLISECONDS));
            }
            taskLifecycleService.onPostExecute(mapper);
        }
        return intermediateKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <KIn, VIn, KOut, VOut> Map<KOut, List<VOut>> combine(MapCombineCommand<KIn, VIn, KOut, VOut> mcc, Map<KOut, List<VOut>> collectedValues) {
        Map<KOut, List<VOut>> combinedMap = null;
        if (mcc.hasCombiner()) {
            combinedMap = new HashMap<KOut, List<VOut>>();
            Reducer<KOut, VOut> combiner = mcc.getCombiner();
            Cache cache = this.cacheManager.getCache(mcc.getCacheName());
            log.tracef("For m/r task %s invoking combiner %s at %s", mcc.getTaskId(), mcc, this.cdl.getAddress());
            MapReduceTaskLifecycleService taskLifecycleService = MapReduceTaskLifecycleService.getInstance();
            long start = log.isTraceEnabled() ? this.timeService.time() : 0L;
            try {
                taskLifecycleService.onPreExecute(combiner, cache);
                for (Map.Entry<KOut, List<VOut>> e : collectedValues.entrySet()) {
                    List<VOut> mapped = e.getValue();
                    List<Object> combined = mapped.size() == 1 ? mapped : Arrays.asList(combiner.reduce(e.getKey(), mapped.iterator()));
                    combinedMap.put(e.getKey(), combined);
                    log.tracef("For m/r task %s combined %s to %s at %s", new Object[]{mcc.getTaskId(), e.getKey(), combined, this.cdl.getAddress()});
                }
            }
            finally {
                if (log.isTraceEnabled()) {
                    log.tracef("Combine for task %s took %s milliseconds", mcc.getTaskId(), this.timeService.timeDuration(start, TimeUnit.MILLISECONDS));
                }
                taskLifecycleService.onPostExecute(combiner);
            }
        } else {
            combinedMap = collectedValues;
        }
        return combinedMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <KIn, VIn, KOut, VOut> Set<KOut> migrateIntermediateKeysAndValues(MapCombineCommand<KIn, VIn, KOut, VOut> mcc, Map<KOut, List<VOut>> collectedValues) {
        String taskId = mcc.getTaskId();
        String tmpCacheName = mcc.getIntermediateCacheName();
        Cache tmpCache = this.cacheManager.getCache(tmpCacheName);
        if (tmpCache == null) {
            throw new IllegalStateException("Temporary cache for MapReduceTask " + taskId + " named " + tmpCacheName + " not found on " + this.cdl.getAddress());
        }
        HashSet<KOut> mapPhaseKeys = new HashSet<KOut>();
        DistributionManager dm = tmpCache.getAdvancedCache().getDistributionManager();
        boolean emitCompositeIntermediateKeys = mcc.isEmitCompositeIntermediateKeys();
        Map<Address, List<KOut>> keysToNodes = this.mapKeysToNodes(dm, taskId, collectedValues.keySet(), emitCompositeIntermediateKeys);
        long start = log.isTraceEnabled() ? this.timeService.time() : 0L;
        tmpCache = tmpCache.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES);
        try {
            for (Map.Entry<Address, List<KOut>> entry : keysToNodes.entrySet()) {
                List<KOut> keysHashedToAddress = entry.getValue();
                try {
                    log.tracef("For m/r task %s migrating intermediate keys %s to %s", taskId, keysHashedToAddress, entry.getKey());
                    for (KOut key : keysHashedToAddress) {
                        List<VOut> values = collectedValues.get(key);
                        int entryTransferCount = this.chunkSize;
                        for (int i = 0; i < values.size(); i += entryTransferCount) {
                            List<VOut> chunk = values.subList(i, Math.min(values.size(), i + entryTransferCount));
                            DeltaAwareList<VOut> delta = new DeltaAwareList<VOut>(chunk);
                            if (emitCompositeIntermediateKeys) {
                                tmpCache.put(new IntermediateCompositeKey<KOut>(taskId, key), delta);
                                continue;
                            }
                            tmpCache.put(key, delta);
                        }
                        mapPhaseKeys.add(key);
                    }
                }
                catch (Exception e) {
                    throw new CacheException("Could not move intermediate keys/values for M/R task " + taskId, (Throwable)e);
                    return mapPhaseKeys;
                }
            }
        }
        finally {
            if (log.isTraceEnabled()) {
                log.tracef("Migrating keys for task %s took %s milliseconds (Migrated %s keys)", mcc.getTaskId(), this.timeService.timeDuration(start, TimeUnit.MILLISECONDS), mapPhaseKeys.size());
            }
        }
    }

    @Override
    public <T> Map<Address, List<T>> mapKeysToNodes(DistributionManager dm, String taskId, Collection<T> keysToMap, boolean useIntermediateCompositeKey) {
        HashMap<Address, List<T>> addressToKey = new HashMap<Address, List<T>>();
        for (T key : keysToMap) {
            Address ownerOfKey = useIntermediateCompositeKey ? dm.getPrimaryLocation(new IntermediateCompositeKey<T>(taskId, key)) : dm.getPrimaryLocation(key);
            ArrayList<T> keysAtNode = (ArrayList<T>)addressToKey.get(ownerOfKey);
            if (keysAtNode == null) {
                keysAtNode = new ArrayList<T>();
                addressToKey.put(ownerOfKey, keysAtNode);
            }
            keysAtNode.add(key);
        }
        return addressToKey;
    }

    protected <KIn> Set<KIn> filterLocalPrimaryOwner(Set<KIn> nodeLocalKeys, DistributionManager dm) {
        HashSet<KIn> selectedKeys = new HashSet<KIn>();
        for (KIn key : nodeLocalKeys) {
            Address primaryLocation = dm != null ? dm.getPrimaryLocation(key) : this.cdl.getAddress();
            if (primaryLocation == null || !primaryLocation.equals(this.cdl.getAddress())) continue;
            selectedKeys.add(key);
        }
        return selectedKeys;
    }

    public static final class IntermediateCompositeKey<V>
    implements Serializable {
        private static final long serialVersionUID = 4434717760740027918L;
        private final String taskId;
        private final V key;

        public IntermediateCompositeKey(String taskId, V key) {
            this.taskId = taskId;
            this.key = key;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public V getKey() {
            return this.key;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.taskId == null ? 0 : this.taskId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof IntermediateCompositeKey)) {
                return false;
            }
            IntermediateCompositeKey other = (IntermediateCompositeKey)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return !(this.taskId == null ? other.taskId != null : !this.taskId.equals(other.taskId));
        }

        public String toString() {
            return "IntermediateCompositeKey [taskId=" + this.taskId + ", key=" + this.key + "]";
        }
    }

    private static final class DeltaAwareList<E>
    extends LinkedList<E>
    implements DeltaAware,
    Delta {
        private static final long serialVersionUID = 2176345973026460708L;

        public DeltaAwareList(Collection<? extends E> c) {
            super(c);
        }

        @Override
        public Delta delta() {
            return new DeltaAwareList<E>(this);
        }

        @Override
        public void commit() {
            this.clear();
        }

        @Override
        public DeltaAware merge(DeltaAware d) {
            List other = null;
            if (d != null && d instanceof DeltaAwareList) {
                other = (List)((Object)d);
                for (Object e : this) {
                    other.add(e);
                }
                return (DeltaAware)((Object)other);
            }
            return this;
        }
    }

    private static interface CollectableCollector<K, V>
    extends Collector<K, V> {
        public Map<K, List<V>> removeCollectedValues();

        public Map<K, List<V>> removeLRUEntry();
    }

    private static final class DefaultCollector<KOut, VOut>
    implements CollectableCollector<KOut, VOut> {
        private final boolean atomicEmit;
        private Map<KOut, List<VOut>> store;
        private final AtomicInteger emitCount;

        public DefaultCollector(int size, boolean atomicEmit) {
            this.atomicEmit = atomicEmit;
            this.store = new LinkedHashMap<KOut, List<VOut>>(size, 0.75f, true);
            this.emitCount = new AtomicInteger();
        }

        public DefaultCollector(boolean atomicEmit) {
            this(128, atomicEmit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void emit(KOut key, VOut value) {
            if (this.atomicEmit) {
                DefaultCollector defaultCollector = this;
                synchronized (defaultCollector) {
                    this.emitHelper(key, value);
                }
            } else {
                this.emitHelper(key, value);
            }
        }

        protected void emitHelper(KOut key, VOut value) {
            List<VOut> list = this.store.get(key);
            if (list == null) {
                list = new LinkedList<VOut>();
                this.store.put(key, list);
            }
            list.add(value);
            this.emitCount.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<KOut, List<VOut>> removeCollectedValues() {
            HashMap<KOut, List<VOut>> values;
            DefaultCollector defaultCollector = this;
            synchronized (defaultCollector) {
                values = new HashMap<KOut, List<VOut>>(this.store);
                this.store.clear();
                this.emitCount.set(0);
            }
            return values;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<KOut, List<VOut>> removeLRUEntry() {
            Map<Object, Object> lrus = Collections.emptyMap();
            DefaultCollector defaultCollector = this;
            synchronized (defaultCollector) {
                Iterator<KOut> iterator = this.store.keySet().iterator();
                if (iterator.hasNext()) {
                    KOut out = iterator.next();
                    List<VOut> list = this.store.remove(out);
                    lrus = Collections.singletonMap(out, list);
                    this.emitCount.addAndGet(-list.size());
                }
            }
            return lrus;
        }

        public int size() {
            return this.emitCount.get();
        }
    }

    private static final class IntermediateKeyFilter<T>
    implements KeyFilter<IntermediateCompositeKey<T>> {
        private final String taskId;

        public IntermediateKeyFilter(String taskId) {
            if (taskId == null || taskId.isEmpty()) {
                throw new IllegalArgumentException("Invalid task Id " + taskId);
            }
            this.taskId = taskId;
        }

        @Override
        public boolean accept(IntermediateCompositeKey<T> key) {
            if (key != null) {
                return this.taskId.equals(key.getTaskId());
            }
            return false;
        }
    }

    private final class MapCombineTask<K, V, KOut, VOut>
    extends DataContainerTask<K, V>
    implements AdvancedCacheLoader.CacheLoaderTask {
        DefaultCollector<KOut, VOut> collector;
        MapCombineCommand<K, V, KOut, VOut> mcc;
        Set<KOut> intermediateKeys;
        int maxCollectorSize;

        public MapCombineTask(DefaultCollector<KOut, VOut> collector, MapCombineCommand<K, V, KOut, VOut> mcc, int maxCollectorSize) {
            this.collector = collector;
            this.mcc = mcc;
            this.intermediateKeys = Collections.synchronizedSet(new HashSet());
            this.maxCollectorSize = maxCollectorSize;
        }

        public Set<KOut> getIntermediateKeys() {
            return this.intermediateKeys;
        }

        @Override
        V getValue(InternalCacheEntry entry) {
            if (entry != null) {
                Object value = entry.getValue();
                if (value instanceof MarshalledValue) {
                    value = ((MarshalledValue)value).get();
                }
                return value;
            }
            return null;
        }

        public void apply(Object key, InternalCacheEntry v) {
            V value = this.getValue(v);
            if (value != null) {
                this.mcc.getMapper().map(key, value, this.collector);
            }
            this.combineAndMigrate();
        }

        protected void combineAndMigrate() throws CacheException {
            Map<KOut, List<VOut>> batch;
            if (this.collector.size() > this.maxCollectorSize && !(batch = this.collector.removeCollectedValues()).isEmpty()) {
                Map<KOut, List<VOut>> combinedValues = MapReduceManagerImpl.this.combine(this.mcc, batch);
                Set migratedKeys = MapReduceManagerImpl.this.migrateIntermediateKeysAndValues(this.mcc, combinedValues);
                this.intermediateKeys.addAll(migratedKeys);
            }
        }

        public void processEntry(MarshalledEntry marshalledEntry, AdvancedCacheLoader.TaskContext taskContext) throws InterruptedException {
            this.mcc.getMapper().map(marshalledEntry.getKey(), this.getValue(marshalledEntry), this.collector);
            this.combineAndMigrate();
        }

        private Object getValue(MarshalledEntry marshalledEntry) {
            Object loadedValue = marshalledEntry.getValue();
            if (loadedValue instanceof MarshalledValue) {
                return ((MarshalledValue)loadedValue).get();
            }
            return loadedValue;
        }
    }

    private abstract class DataContainerTask<K, V>
    implements ParallelIterableMap.KeyValueAction<Object, InternalCacheEntry> {
        private DataContainerTask() {
        }

        V getValue(InternalCacheEntry entry) {
            if (entry != null) {
                Object value = entry.getValue();
                if (value instanceof MarshalledValue) {
                    value = ((MarshalledValue)value).get();
                }
                return value;
            }
            return null;
        }
    }
}

