/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.read.ValuesCommand;
import org.infinispan.commands.tx.AbstractTransactionBoundaryCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.DisplayType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.impl.TransactionCoordinator;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.recovery.RecoverableTransactionIdentifier;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="Transactions", description="Component that manages the cache's participation in JTA transactions.")
public class TxInterceptor
extends CommandInterceptor {
    private TransactionTable txTable;
    private final AtomicLong prepares = new AtomicLong(0L);
    private final AtomicLong commits = new AtomicLong(0L);
    private final AtomicLong rollbacks = new AtomicLong(0L);
    private boolean statisticsEnabled;
    protected TransactionCoordinator txCoordinator;
    protected RpcManager rpcManager;
    private static final Log log = LogFactory.getLog(TxInterceptor.class);
    private RecoveryManager recoveryManager;
    private boolean isTotalOrder;
    private boolean useOnePhaseForAutoCommitTx;

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void init(TransactionTable txTable, Configuration c, TransactionCoordinator txCoordinator, RpcManager rpcManager, RecoveryManager recoveryManager) {
        this.cacheConfiguration = c;
        this.txTable = txTable;
        this.txCoordinator = txCoordinator;
        this.rpcManager = rpcManager;
        this.recoveryManager = recoveryManager;
        this.statisticsEnabled = this.cacheConfiguration.jmxStatistics().enabled();
        this.isTotalOrder = c.transaction().transactionProtocol().isTotalOrder();
        this.useOnePhaseForAutoCommitTx = this.cacheConfiguration.transaction().use1PcForAutoCommitTransactions();
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (this.statisticsEnabled) {
            this.prepares.incrementAndGet();
        }
        Object result = this.invokeNextInterceptorAndVerifyTransaction(ctx, command);
        if (!ctx.isOriginLocal()) {
            if (command.isOnePhaseCommit()) {
                this.txTable.remoteTransactionCommitted(command.getGlobalTransaction(), true);
            } else {
                this.txTable.remoteTransactionPrepared(command.getGlobalTransaction());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeNextInterceptorAndVerifyTransaction(TxInvocationContext ctx, AbstractTransactionBoundaryCommand command) throws Throwable {
        Object object;
        try {
            object = this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable throwable) {
            if (!ctx.isOriginLocal()) {
                boolean originatorMissing = !this.rpcManager.getTransport().getMembers().contains(command.getOrigin());
                boolean alreadyCompleted = this.txTable.isTransactionCompleted(command.getGlobalTransaction());
                if (log.isTraceEnabled()) {
                    log.tracef("invokeNextInterceptorAndVerifyTransaction :: originatorMissing=%s, alreadyCompleted=%s", originatorMissing, alreadyCompleted);
                }
                if (alreadyCompleted || originatorMissing) {
                    if (log.isTraceEnabled()) {
                        log.tracef("Rolling back remote transaction %s because either already completed(%s) or originator no longer in the cluster(%s).", command.getGlobalTransaction(), alreadyCompleted, originatorMissing);
                    }
                    RollbackCommand rollback = new RollbackCommand(command.getCacheName(), command.getGlobalTransaction());
                    try {
                        this.invokeNextInterceptor(ctx, rollback);
                    }
                    finally {
                        RemoteTransaction remoteTx = (RemoteTransaction)ctx.getCacheTransaction();
                        remoteTx.markForRollback(true);
                        this.txTable.removeRemoteTransaction(command.getGlobalTransaction());
                    }
                }
            }
            throw throwable;
        }
        if (!ctx.isOriginLocal()) {
            boolean originatorMissing = !this.rpcManager.getTransport().getMembers().contains(command.getOrigin());
            boolean alreadyCompleted = this.txTable.isTransactionCompleted(command.getGlobalTransaction());
            if (log.isTraceEnabled()) {
                log.tracef("invokeNextInterceptorAndVerifyTransaction :: originatorMissing=%s, alreadyCompleted=%s", originatorMissing, alreadyCompleted);
            }
            if (alreadyCompleted || originatorMissing) {
                if (log.isTraceEnabled()) {
                    log.tracef("Rolling back remote transaction %s because either already completed(%s) or originator no longer in the cluster(%s).", command.getGlobalTransaction(), alreadyCompleted, originatorMissing);
                }
                RollbackCommand rollback = new RollbackCommand(command.getCacheName(), command.getGlobalTransaction());
                try {
                    this.invokeNextInterceptor(ctx, rollback);
                }
                finally {
                    RemoteTransaction remoteTx = (RemoteTransaction)ctx.getCacheTransaction();
                    remoteTx.markForRollback(true);
                    this.txTable.removeRemoteTransaction(command.getGlobalTransaction());
                }
            }
        }
        return object;
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        if (!ctx.isOriginLocal() && this.txTable.isTransactionCompleted(gtx)) {
            log.tracef("Transaction %s already completed, skipping commit", gtx);
            return null;
        }
        if (this.statisticsEnabled) {
            this.commits.incrementAndGet();
        }
        this.txTable.markTransactionCompleted(gtx);
        Object result = this.invokeNextInterceptor(ctx, command);
        if (!ctx.isOriginLocal() || this.isTotalOrder) {
            this.txTable.remoteTransactionCommitted(gtx, false);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (this.statisticsEnabled) {
            this.rollbacks.incrementAndGet();
        }
        if (!ctx.isOriginLocal() || this.isTotalOrder) {
            this.txTable.remoteTransactionRollback(command.getGlobalTransaction());
        }
        try {
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            if (this.recoveryManager != null) {
                GlobalTransaction gtx = command.getGlobalTransaction();
                this.recoveryManager.removeRecoveryInformation(((RecoverableTransactionIdentifier)((Object)gtx)).getXid());
            }
        }
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        this.enlistIfNeeded(ctx);
        if (ctx.isOriginLocal()) {
            command.setGlobalTransaction(ctx.getGlobalTransaction());
        }
        return this.invokeNextInterceptorAndVerifyTransaction(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitKeySetCommand(InvocationContext ctx, KeySetCommand command) throws Throwable {
        return this.enlistReadAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitValuesCommand(InvocationContext ctx, ValuesCommand command) throws Throwable {
        return this.enlistReadAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitEntrySetCommand(InvocationContext ctx, EntrySetCommand command) throws Throwable {
        return this.enlistReadAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand invalidateCommand) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, invalidateCommand);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.enlistReadAndInvokeNext(ctx, command);
    }

    private Object enlistReadAndInvokeNext(InvocationContext ctx, VisitableCommand command) throws Throwable {
        this.enlistIfNeeded(ctx);
        return this.invokeNextInterceptor(ctx, command);
    }

    private void enlistIfNeeded(InvocationContext ctx) throws SystemException {
        if (TxInterceptor.shouldEnlist(ctx)) {
            this.enlist((TxInvocationContext)ctx);
        }
    }

    private Object enlistWriteAndInvokeNext(InvocationContext ctx, WriteCommand command) throws Throwable {
        Object rv;
        LocalTransaction localTransaction = null;
        if (TxInterceptor.shouldEnlist(ctx)) {
            boolean implicitWith1Pc;
            localTransaction = this.enlist((TxInvocationContext)ctx);
            boolean bl = implicitWith1Pc = this.useOnePhaseForAutoCommitTx && localTransaction.isImplicitTransaction();
            if (implicitWith1Pc) {
                command.setFlags(Flag.SKIP_LOCKING);
            }
        }
        try {
            rv = this.invokeNextInterceptor(ctx, command);
        }
        catch (Throwable throwable) {
            if (ctx.isOriginLocal() && ctx.isInTxScope() && !command.hasFlag(Flag.FAIL_SILENTLY)) {
                TxInvocationContext txCtx = (TxInvocationContext)ctx;
                txCtx.getTransaction().setRollbackOnly();
            }
            throw throwable;
        }
        if (localTransaction != null && command.isSuccessful()) {
            localTransaction.addModification(command);
        }
        return rv;
    }

    public LocalTransaction enlist(TxInvocationContext ctx) throws SystemException {
        Transaction transaction = ctx.getTransaction();
        if (transaction == null) {
            throw new IllegalStateException("This should only be called in an tx scope");
        }
        int status = transaction.getStatus();
        if (this.isNotValid(status)) {
            throw new IllegalStateException("Transaction " + transaction + " is not in a valid state to be invoking cache operations on.");
        }
        LocalTransaction localTransaction = this.txTable.getLocalTransaction(transaction);
        this.txTable.enlist(transaction, localTransaction);
        return localTransaction;
    }

    private boolean isNotValid(int status) {
        return status != 0 && status != 7 && status != 8;
    }

    private static boolean shouldEnlist(InvocationContext ctx) {
        return ctx.isInTxScope() && ctx.isOriginLocal();
    }

    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset Statistics")
    public void resetStatistics() {
        this.prepares.set(0L);
        this.commits.set(0L);
        this.rollbacks.set(0L);
    }

    @ManagedAttribute(displayName="Statistics enabled", dataType=DataType.TRAIT, writable=true)
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @ManagedAttribute(description="Number of transaction prepares performed since last reset", displayName="Prepares", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getPrepares() {
        return this.prepares.get();
    }

    @ManagedAttribute(description="Number of transaction commits performed since last reset", displayName="Commits", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getCommits() {
        return this.commits.get();
    }

    @ManagedAttribute(description="Number of transaction rollbacks performed since last reset", displayName="Rollbacks", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getRollbacks() {
        return this.rollbacks.get();
    }
}

