/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.iteration.impl;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.iteration.impl.EntryRetriever;
import org.infinispan.remoting.transport.Address;

public class EntryResponseCommand<K, C>
extends BaseRpcCommand
implements TopologyAffectedCommand {
    public static final byte COMMAND_ID = 42;
    private UUID identifier;
    private Set<Integer> completedSegments;
    private Set<Integer> inDoubtSegments;
    private Collection<Map.Entry<K, C>> values;
    private int topologyId = -1;
    private Address origin;
    private EntryRetriever<K, ?> entryRetrieverManager;

    private EntryResponseCommand() {
        super(null);
    }

    public EntryResponseCommand(String cacheName) {
        super(cacheName);
    }

    public EntryResponseCommand(Address origin, String cacheName, UUID identifier, Set<Integer> completedSegments, Set<Integer> inDoubtSegments, Collection<Map.Entry<K, C>> values) {
        super(cacheName);
        this.origin = origin;
        this.identifier = identifier;
        this.completedSegments = completedSegments;
        this.inDoubtSegments = inDoubtSegments;
        this.values = values;
    }

    @Inject
    public void init(EntryRetriever<K, ?> entryRetrieverManager) {
        this.entryRetrieverManager = entryRetrieverManager;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        this.entryRetrieverManager.receiveResponse(this.identifier, this.origin, this.completedSegments, this.inDoubtSegments, this.values);
        return null;
    }

    @Override
    public byte getCommandId() {
        return 42;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.origin, this.identifier, this.completedSegments, this.inDoubtSegments, this.values, this.topologyId};
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        int i = 0;
        this.origin = (Address)parameters[i++];
        this.identifier = (UUID)parameters[i++];
        this.completedSegments = (Set)parameters[i++];
        this.inDoubtSegments = (Set)parameters[i++];
        this.values = (Collection)parameters[i++];
        this.topologyId = (Integer)parameters[i++];
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    @Override
    public String toString() {
        return "EntryResponseCommand{identifier=" + this.identifier + ", completedSegments=" + this.completedSegments + ", inDoubtSegments=" + this.inDoubtSegments + ", values=" + this.values + ", topologyId=" + this.topologyId + ", origin=" + this.origin + '}';
    }
}

