/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.iteration.impl;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.commons.util.CloseableIterable;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.filter.Converter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.iteration.impl.EntryRetriever;
import org.infinispan.util.concurrent.ConcurrentHashSet;

public class TrackingEntryIterable<K, V, C>
implements CloseableIterable<Map.Entry<K, C>> {
    protected final EntryRetriever<K, V> entryRetriever;
    protected final KeyValueFilter<? super K, ? super V> filter;
    protected final Converter<? super K, ? super V, ? extends C> converter;
    protected final AtomicBoolean closed = new AtomicBoolean(false);
    protected final Set<CloseableIterator<Map.Entry<K, C>>> iterators = new ConcurrentHashSet<CloseableIterator<Map.Entry<K, C>>>();

    public TrackingEntryIterable(EntryRetriever<K, V> retriever, KeyValueFilter<? super K, ? super V> filter, Converter<? super K, ? super V, ? extends C> converter) {
        if (retriever == null) {
            throw new NullPointerException("Retriever cannot be null!");
        }
        if (filter == null) {
            throw new NullPointerException("Filter cannot be null!");
        }
        this.entryRetriever = retriever;
        this.filter = filter;
        this.converter = converter;
    }

    public void close() throws IOException {
        this.closed.set(true);
        for (CloseableIterator<Map.Entry<K, C>> iterator : this.iterators) {
            iterator.close();
        }
    }

    public Iterator<Map.Entry<K, C>> iterator() {
        if (this.closed.get()) {
            throw new IllegalStateException("Iterable has been closed - cannot be reused");
        }
        CloseableIterator<Map.Entry<? super K, ? extends C>> iterator = this.entryRetriever.retrieveEntries(this.filter, this.converter, null);
        this.iterators.add(iterator);
        if (this.closed.get()) {
            try {
                iterator.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new IllegalStateException("Iterable has been closed - cannot be reused");
        }
        return iterator;
    }
}

