/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.security.auth.Subject;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commons.CacheListenerException;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.distexec.DistributedExecutionCompletionService;
import org.infinispan.distexec.DistributedExecutorService;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.filter.Converter;
import org.infinispan.filter.KeyFilter;
import org.infinispan.filter.KeyFilterAsKeyValueFilter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.SecurityActions;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryEvicted;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryInvalidated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryLoaded;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.annotation.DataRehashed;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.annotation.TransactionCompleted;
import org.infinispan.notifications.cachelistener.annotation.TransactionRegistered;
import org.infinispan.notifications.cachelistener.cluster.ClusterCacheNotifier;
import org.infinispan.notifications.cachelistener.cluster.ClusterListenerRemoveCallable;
import org.infinispan.notifications.cachelistener.cluster.ClusterListenerReplicateCallable;
import org.infinispan.notifications.cachelistener.cluster.RemoteClusterListener;
import org.infinispan.notifications.cachelistener.event.CacheEntriesEvictedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvictedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryInvalidatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryLoadedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryPassivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryVisitedEvent;
import org.infinispan.notifications.cachelistener.event.DataRehashedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.notifications.cachelistener.event.TransactionCompletedEvent;
import org.infinispan.notifications.cachelistener.event.TransactionRegisteredEvent;
import org.infinispan.notifications.cachelistener.event.impl.EventImpl;
import org.infinispan.notifications.impl.AbstractListenerImpl;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheTopology;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public final class CacheNotifierImpl<K, V>
extends AbstractListenerImpl<Event<? extends K, ? extends V>, K, V>
implements ClusterCacheNotifier<K, V> {
    private static final Log log = LogFactory.getLog(CacheNotifierImpl.class);
    private static final Map<Class<? extends Annotation>, Class<?>> allowedListeners = new HashMap(16);
    private static final Map<Class<? extends Annotation>, Class<?>> clusterAllowedListeners = new HashMap();
    final List<AbstractListenerImpl.ListenerInvocation> cacheEntryCreatedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> cacheEntryRemovedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> cacheEntryVisitedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> cacheEntryModifiedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> cacheEntryActivatedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> cacheEntryPassivatedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> cacheEntryLoadedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> cacheEntryInvalidatedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> cacheEntriesEvictedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> transactionRegisteredListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> transactionCompletedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> dataRehashedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> topologyChangedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> cacheEntryEvictedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    private Cache<K, V> cache;
    private ClusteringDependentLogic clusteringDependentLogic;
    private TransactionManager transactionManager;
    private DistributedExecutorService distExecutorService;
    private Configuration config;
    private final Map<Object, UUID> clusterListenerIDs = new ConcurrentHashMap<Object, UUID>();

    public CacheNotifierImpl() {
        this.listenersMap.put(CacheEntryCreated.class, this.cacheEntryCreatedListeners);
        this.listenersMap.put(CacheEntryRemoved.class, this.cacheEntryRemovedListeners);
        this.listenersMap.put(CacheEntryVisited.class, this.cacheEntryVisitedListeners);
        this.listenersMap.put(CacheEntryModified.class, this.cacheEntryModifiedListeners);
        this.listenersMap.put(CacheEntryActivated.class, this.cacheEntryActivatedListeners);
        this.listenersMap.put(CacheEntryPassivated.class, this.cacheEntryPassivatedListeners);
        this.listenersMap.put(CacheEntryLoaded.class, this.cacheEntryLoadedListeners);
        this.listenersMap.put(CacheEntriesEvicted.class, this.cacheEntriesEvictedListeners);
        this.listenersMap.put(TransactionRegistered.class, this.transactionRegisteredListeners);
        this.listenersMap.put(TransactionCompleted.class, this.transactionCompletedListeners);
        this.listenersMap.put(CacheEntryInvalidated.class, this.cacheEntryInvalidatedListeners);
        this.listenersMap.put(DataRehashed.class, this.dataRehashedListeners);
        this.listenersMap.put(TopologyChanged.class, this.topologyChangedListeners);
        this.listenersMap.put(CacheEntryEvicted.class, this.cacheEntryEvictedListeners);
    }

    @Inject
    void injectDependencies(Cache<K, V> cache, ClusteringDependentLogic clusteringDependentLogic, TransactionManager transactionManager, Configuration config) {
        this.cache = cache;
        this.clusteringDependentLogic = clusteringDependentLogic;
        this.transactionManager = transactionManager;
        this.config = config;
    }

    @Override
    public void start() {
        super.start();
        this.distExecutorService = SecurityActions.getDefaultExecutorService(this.cache);
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected Map<Class<? extends Annotation>, Class<?>> getAllowedMethodAnnotations() {
        return allowedListeners;
    }

    @Override
    protected final Transaction suspendIfNeeded() {
        if (this.transactionManager == null) {
            return null;
        }
        try {
            switch (this.transactionManager.getStatus()) {
                case 0: 
                case 6: {
                    return null;
                }
            }
            return this.transactionManager.suspend();
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace("An error occurred while trying to suspend a transaction.", e);
            }
            return null;
        }
    }

    @Override
    protected final void resumeIfNeeded(Transaction transaction) {
        block3: {
            if (transaction == null || this.transactionManager == null) {
                return;
            }
            try {
                this.transactionManager.resume(transaction);
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block3;
                log.tracef(e, "An error occurred while trying to resume a suspended transaction. tx=%s", transaction);
            }
        }
    }

    @Override
    public void notifyCacheEntryCreated(K key, V value, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (!this.cacheEntryCreatedListeners.isEmpty()) {
            EventImpl<K, V> e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_CREATED);
            this.configureEvent(e, key, value, pre, ctx, command);
            boolean isLocalNodePrimaryOwner = this.clusteringDependentLogic.localNodeIsPrimaryOwner(key);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryCreatedListeners) {
                listener.invoke(e, isLocalNodePrimaryOwner);
            }
        }
    }

    @Override
    public void notifyCacheEntryModified(K key, V value, boolean created, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (!this.cacheEntryModifiedListeners.isEmpty()) {
            EventImpl<K, V> e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_MODIFIED);
            this.configureEvent(e, key, value, pre, ctx, command);
            e.setCreated(created);
            boolean isLocalNodePrimaryOwner = this.clusteringDependentLogic.localNodeIsPrimaryOwner(key);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryModifiedListeners) {
                listener.invoke(e, isLocalNodePrimaryOwner);
            }
        }
    }

    @Override
    public void notifyCacheEntryRemoved(K key, V value, V oldValue, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.isNotificationAllowed(command, this.cacheEntryRemovedListeners)) {
            EventImpl<K, V> e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_REMOVED);
            this.configureEvent(e, key, value, pre, ctx, command);
            e.setOldValue(oldValue);
            this.setTx(ctx, e);
            boolean isLocalNodePrimaryOwner = this.clusteringDependentLogic.localNodeIsPrimaryOwner(key);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryRemovedListeners) {
                listener.invoke(e, isLocalNodePrimaryOwner);
            }
        }
    }

    private void configureEvent(EventImpl<K, V> e, K key, V value, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        Set<Flag> flags;
        boolean originLocal = ctx.isOriginLocal();
        e.setOriginLocal(originLocal);
        e.setValue(value);
        e.setPre(pre);
        CacheEntry entry = ctx.lookupEntry(key);
        if (entry != null) {
            e.setMetadata(entry.getMetadata());
        }
        if (command != null && (flags = command.getFlags()) != null && flags.contains((Object)Flag.COMMAND_RETRY)) {
            e.setCommandRetried(true);
        }
        e.setKey(key);
        this.setTx(ctx, e);
    }

    @Override
    public void notifyCacheEntryVisited(K key, V value, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.isNotificationAllowed(command, this.cacheEntryVisitedListeners)) {
            EventImpl<K, V> e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_VISITED);
            e.setPre(pre);
            e.setKey(key);
            e.setValue(value);
            this.setTx(ctx, e);
            boolean isLocalNodePrimaryOwner = this.clusteringDependentLogic.localNodeIsPrimaryOwner(key);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryVisitedListeners) {
                listener.invoke(e, isLocalNodePrimaryOwner);
            }
        }
    }

    @Override
    public void notifyCacheEntriesEvicted(Collection<InternalCacheEntry<? extends K, ? extends V>> entries, InvocationContext ctx, FlagAffectedCommand command) {
        if (!entries.isEmpty()) {
            if (this.isNotificationAllowed(command, this.cacheEntriesEvictedListeners)) {
                EventImpl<K, V> e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_EVICTED);
                Map evictedKeysAndValues = InfinispanCollections.transformCollectionToMap(entries, (InfinispanCollections.MapMakerFunction)new InfinispanCollections.MapMakerFunction<K, V, InternalCacheEntry<? extends K, ? extends V>>(){

                    public Map.Entry<K, V> transform(final InternalCacheEntry<? extends K, ? extends V> input) {
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return input.getKey();
                            }

                            @Override
                            public V getValue() {
                                return input.getValue();
                            }

                            @Override
                            public V setValue(V value) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                });
                e.setEntries(evictedKeysAndValues);
                for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntriesEvictedListeners) {
                    listener.invoke(e);
                }
            }
            if (this.isNotificationAllowed(command, this.cacheEntryEvictedListeners)) {
                for (InternalCacheEntry<K, V> ice : entries) {
                    EventImpl e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_EVICTED);
                    e.setKey(ice.getKey());
                    e.setValue(ice.getValue());
                    boolean isLocalNodePrimaryOwner = this.clusteringDependentLogic.localNodeIsPrimaryOwner(ice.getKey());
                    for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryEvictedListeners) {
                        listener.invoke(e, isLocalNodePrimaryOwner);
                    }
                }
            }
        }
    }

    @Override
    public void notifyCacheEntryEvicted(K key, V value, InvocationContext ctx, FlagAffectedCommand command) {
        EventImpl<K, V> e;
        boolean isLocalNodePrimaryOwner = this.clusteringDependentLogic.localNodeIsPrimaryOwner(key);
        if (this.isNotificationAllowed(command, this.cacheEntriesEvictedListeners)) {
            e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_EVICTED);
            Map<K, V> map = Collections.singletonMap(key, value);
            e.setEntries(map);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntriesEvictedListeners) {
                listener.invoke(e, isLocalNodePrimaryOwner);
            }
        }
        if (this.isNotificationAllowed(command, this.cacheEntryEvictedListeners)) {
            e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_EVICTED);
            e.setKey(key);
            e.setValue(value);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryEvictedListeners) {
                listener.invoke(e, isLocalNodePrimaryOwner);
            }
        }
    }

    @Override
    public void notifyCacheEntryInvalidated(K key, V value, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.isNotificationAllowed(command, this.cacheEntryInvalidatedListeners)) {
            boolean originLocal = ctx.isOriginLocal();
            EventImpl<K, V> e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_INVALIDATED);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setKey(key);
            e.setValue(value);
            this.setTx(ctx, e);
            boolean isLocalNodePrimaryOwner = this.clusteringDependentLogic.localNodeIsPrimaryOwner(key);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryInvalidatedListeners) {
                listener.invoke(e, isLocalNodePrimaryOwner);
            }
        }
    }

    @Override
    public void notifyCacheEntryLoaded(K key, V value, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.isNotificationAllowed(command, this.cacheEntryLoadedListeners)) {
            boolean originLocal = ctx.isOriginLocal();
            EventImpl<K, V> e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_LOADED);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setKey(key);
            e.setValue(value);
            this.setTx(ctx, e);
            boolean isLocalNodePrimaryOwner = this.clusteringDependentLogic.localNodeIsPrimaryOwner(key);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryLoadedListeners) {
                listener.invoke(e, isLocalNodePrimaryOwner);
            }
        }
    }

    @Override
    public void notifyCacheEntryActivated(K key, V value, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.isNotificationAllowed(command, this.cacheEntryActivatedListeners)) {
            boolean originLocal = ctx.isOriginLocal();
            EventImpl<K, V> e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_ACTIVATED);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setKey(key);
            e.setValue(value);
            this.setTx(ctx, e);
            boolean isLocalNodePrimaryOwner = this.clusteringDependentLogic.localNodeIsPrimaryOwner(key);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryActivatedListeners) {
                listener.invoke(e, isLocalNodePrimaryOwner);
            }
        }
    }

    private void setTx(InvocationContext ctx, EventImpl<K, V> e) {
        if (ctx != null && ctx.isInTxScope()) {
            GlobalTransaction tx = ((TxInvocationContext)ctx).getGlobalTransaction();
            e.setTransactionId(tx);
        }
    }

    @Override
    public void notifyCacheEntryPassivated(K key, V value, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.isNotificationAllowed(command, this.cacheEntryPassivatedListeners)) {
            EventImpl<K, V> e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_PASSIVATED);
            e.setPre(pre);
            e.setKey(key);
            e.setValue(value);
            boolean isLocalNodePrimaryOwner = this.clusteringDependentLogic.localNodeIsPrimaryOwner(key);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryPassivatedListeners) {
                listener.invoke(e, isLocalNodePrimaryOwner);
            }
        }
    }

    @Override
    public void notifyTransactionCompleted(GlobalTransaction transaction, boolean successful, InvocationContext ctx) {
        if (!this.transactionCompletedListeners.isEmpty()) {
            boolean isOriginLocal = ctx.isOriginLocal();
            EventImpl<K, V> e = EventImpl.createEvent(this.cache, Event.Type.TRANSACTION_COMPLETED);
            e.setOriginLocal(isOriginLocal);
            e.setTransactionId(transaction);
            e.setTransactionSuccessful(successful);
            for (AbstractListenerImpl.ListenerInvocation listener : this.transactionCompletedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyTransactionRegistered(GlobalTransaction globalTransaction, boolean isOriginLocal) {
        if (!this.transactionRegisteredListeners.isEmpty()) {
            EventImpl<K, V> e = EventImpl.createEvent(this.cache, Event.Type.TRANSACTION_REGISTERED);
            e.setOriginLocal(isOriginLocal);
            e.setTransactionId(globalTransaction);
            for (AbstractListenerImpl.ListenerInvocation listener : this.transactionRegisteredListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyDataRehashed(ConsistentHash readCH, ConsistentHash writeCH, ConsistentHash unionCH, int newTopologyId, boolean pre) {
        if (!this.dataRehashedListeners.isEmpty()) {
            EventImpl<K, V> e = EventImpl.createEvent(this.cache, Event.Type.DATA_REHASHED);
            e.setPre(pre);
            e.setConsistentHashAtStart(readCH);
            e.setConsistentHashAtEnd(writeCH);
            e.setUnionConsistentHash(unionCH);
            e.setNewTopologyId(newTopologyId);
            for (AbstractListenerImpl.ListenerInvocation listener : this.dataRehashedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyTopologyChanged(CacheTopology oldTopology, CacheTopology newTopology, int newTopologyId, boolean pre) {
        if (!this.topologyChangedListeners.isEmpty()) {
            EventImpl<K, V> e = EventImpl.createEvent(this.cache, Event.Type.TOPOLOGY_CHANGED);
            e.setPre(pre);
            if (oldTopology != null) {
                e.setConsistentHashAtStart(oldTopology.getReadConsistentHash());
            }
            e.setConsistentHashAtEnd(newTopology.getWriteConsistentHash());
            e.setNewTopologyId(newTopologyId);
            for (AbstractListenerImpl.ListenerInvocation listener : this.topologyChangedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyClusterListeners(Collection<? extends Event<? extends K, ? extends V>> events, UUID uuid) {
        block5: for (Event<K, V> event : events) {
            if (event.isPre()) {
                throw new IllegalArgumentException("Events for cluster listener should never be pre change");
            }
            switch (event.getType()) {
                case CACHE_ENTRY_MODIFIED: {
                    for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryModifiedListeners) {
                        if (!listener.clustered || !uuid.equals(listener.generatedId)) continue;
                        listener.invoke(event, true, true);
                    }
                    continue block5;
                }
                case CACHE_ENTRY_CREATED: {
                    for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryCreatedListeners) {
                        if (!listener.clustered || !uuid.equals(listener.generatedId)) continue;
                        listener.invoke(event, true, true);
                    }
                    continue block5;
                }
                case CACHE_ENTRY_REMOVED: {
                    for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryRemovedListeners) {
                        if (!listener.clustered || !uuid.equals(listener.generatedId)) continue;
                        listener.invoke(event, true, true);
                    }
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected event type encountered!");
                }
            }
        }
    }

    @Override
    public Collection<DistributedCallable> retrieveClusterListenerCallablesToInstall() {
        HashSet<Object> enlistedAlready = new HashSet<Object>();
        HashSet<DistributedCallable> callables = new HashSet<DistributedCallable>();
        if (log.isTraceEnabled()) {
            log.tracef("Request received to get cluster listeners currently registered", new Object[0]);
        }
        this.registerClusterListenerCallablesToInstall(enlistedAlready, callables, this.cacheEntryModifiedListeners);
        this.registerClusterListenerCallablesToInstall(enlistedAlready, callables, this.cacheEntryCreatedListeners);
        this.registerClusterListenerCallablesToInstall(enlistedAlready, callables, this.cacheEntryRemovedListeners);
        if (log.isTraceEnabled()) {
            log.tracef("Cluster listeners found %s", callables);
        }
        return callables;
    }

    private void registerClusterListenerCallablesToInstall(Set<Object> enlistedAlready, Set<DistributedCallable> callables, List<AbstractListenerImpl.ListenerInvocation> listenerInvocations) {
        for (AbstractListenerImpl.ListenerInvocation listener : listenerInvocations) {
            if (enlistedAlready.contains(listener.target)) continue;
            if (listener.clustered) {
                callables.add(new ClusterListenerReplicateCallable(listener.generatedId, this.cache.getCacheManager().getAddress(), listener.filter, listener.converter));
                enlistedAlready.add(listener.target);
                continue;
            }
            if (!(listener.target instanceof RemoteClusterListener)) continue;
            RemoteClusterListener lcl = (RemoteClusterListener)listener.target;
            callables.add(new ClusterListenerReplicateCallable(lcl.getId(), lcl.getOwnerAddress(), listener.filter, listener.converter));
            enlistedAlready.add(listener.target);
        }
    }

    public boolean isNotificationAllowed(FlagAffectedCommand cmd, List<AbstractListenerImpl.ListenerInvocation> listeners) {
        return (cmd == null || !cmd.hasFlag(Flag.SKIP_LISTENER_NOTIFICATION)) && !listeners.isEmpty();
    }

    @Override
    public void addListener(Object listener, KeyFilter<? super K> filter, ClassLoader classLoader) {
        this.validateAndAddListenerInvocation(listener, new KeyFilterAsKeyValueFilter(filter), null, classLoader);
    }

    @Override
    public <C> void addListener(Object listener, KeyValueFilter<? super K, ? super V> filter, Converter<? super K, ? super V, C> converter, ClassLoader classLoader) {
        this.validateAndAddListenerInvocation(listener, filter, converter, classLoader);
    }

    @Override
    public void addListener(Object listener, KeyFilter filter) {
        this.addListener(listener, filter, null);
    }

    @Override
    public <C> void addListener(Object listener, KeyValueFilter<? super K, ? super V> filter, Converter<? super K, ? super V, C> converter) {
        this.validateAndAddListenerInvocation(listener, filter, converter, null);
    }

    @Override
    protected <C> void addedListener(Object listener, UUID generatedId, boolean hasClusteredMethods, KeyValueFilter<? super K, ? super V> filter, Converter<? super K, ? super V, C> converter) {
        if (hasClusteredMethods) {
            if (this.config.clustering().cacheMode().isInvalidation()) {
                throw new UnsupportedOperationException("Cluster listeners cannot be used with Invalidation Caches!");
            }
            this.clusterListenerIDs.put(listener, generatedId);
            EmbeddedCacheManager manager = this.cache.getCacheManager();
            Address ourAddress = manager.getAddress();
            List<Address> members = manager.getMembers();
            if (members != null && members.size() > 1) {
                DistributedExecutionCompletionService<Void> decs = new DistributedExecutionCompletionService<Void>(this.distExecutorService);
                log.tracef("Replicating cluster listener to other nodes %s for cluster listener with id %s", members, generatedId);
                ClusterListenerReplicateCallable<? super K, ? super V> callable = new ClusterListenerReplicateCallable<K, V>(generatedId, ourAddress, filter, converter);
                for (Address member : members) {
                    if (member.equals(ourAddress)) continue;
                    decs.submit(member, callable);
                }
                for (int i = 0; i < members.size() - 1; ++i) {
                    try {
                        decs.take().get();
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new CacheListenerException((Throwable)e);
                    }
                    catch (ExecutionException e) {
                        throw new CacheListenerException((Throwable)e);
                    }
                }
                int extraCount = 0;
                List<Address> membersAfter = manager.getMembers();
                for (Address member : membersAfter) {
                    if (members.contains(member) || member.equals(ourAddress)) continue;
                    log.tracef("Found additional node %s that joined during replication of cluster listener with id %s", member, generatedId);
                    ++extraCount;
                    decs.submit(member, callable);
                }
                for (int i = 0; i < extraCount; ++i) {
                    try {
                        decs.take().get();
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new CacheListenerException((Throwable)e);
                    }
                    catch (ExecutionException e) {
                        throw new CacheListenerException((Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    protected AbstractListenerImpl.ListenerInvocation createListenerInvocation(Object listener, Method m, Listener l, KeyValueFilter filter, Converter converter, ClassLoader classLoader, UUID generatedId, Subject subject) {
        return new AbstractListenerImpl.ListenerInvocation(this, listener, m, l.sync(), l.clustered() ? true : l.primaryOnly(), l.clustered(), filter, converter, classLoader, generatedId, subject);
    }

    @Override
    public void removeListener(Object listener) {
        super.removeListener(listener);
        UUID id = this.clusterListenerIDs.remove(listener);
        if (id != null) {
            List<Future<Void>> futures = this.distExecutorService.submitEverywhere(new ClusterListenerRemoveCallable(id));
            for (Future<Void> future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    throw new CacheListenerException((Throwable)e);
                }
                catch (ExecutionException e) {
                    throw new CacheListenerException((Throwable)e);
                }
            }
        }
    }

    static {
        allowedListeners.put(CacheEntryCreated.class, CacheEntryCreatedEvent.class);
        allowedListeners.put(CacheEntryRemoved.class, CacheEntryRemovedEvent.class);
        allowedListeners.put(CacheEntryVisited.class, CacheEntryVisitedEvent.class);
        allowedListeners.put(CacheEntryModified.class, CacheEntryModifiedEvent.class);
        allowedListeners.put(CacheEntryActivated.class, CacheEntryActivatedEvent.class);
        allowedListeners.put(CacheEntryPassivated.class, CacheEntryPassivatedEvent.class);
        allowedListeners.put(CacheEntryLoaded.class, CacheEntryLoadedEvent.class);
        allowedListeners.put(CacheEntriesEvicted.class, CacheEntriesEvictedEvent.class);
        allowedListeners.put(TransactionRegistered.class, TransactionRegisteredEvent.class);
        allowedListeners.put(TransactionCompleted.class, TransactionCompletedEvent.class);
        allowedListeners.put(CacheEntryInvalidated.class, CacheEntryInvalidatedEvent.class);
        allowedListeners.put(DataRehashed.class, DataRehashedEvent.class);
        allowedListeners.put(TopologyChanged.class, TopologyChangedEvent.class);
        allowedListeners.put(CacheEntryEvicted.class, CacheEntryEvictedEvent.class);
        clusterAllowedListeners.put(CacheEntryCreated.class, CacheEntryCreatedEvent.class);
        clusterAllowedListeners.put(CacheEntryModified.class, CacheEntryModifiedEvent.class);
        clusterAllowedListeners.put(CacheEntryRemoved.class, CacheEntryRemovedEvent.class);
    }
}

