/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.impl;

import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import javax.security.auth.Subject;
import javax.transaction.Transaction;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.filter.Converter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.notifications.IncorrectListenerException;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.event.impl.EventImpl;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.infinispan.util.logging.Log;

public abstract class AbstractListenerImpl<T, K, V> {
    protected final Map<Class<? extends Annotation>, List<ListenerInvocation>> listenersMap = new HashMap<Class<? extends Annotation>, List<ListenerInvocation>>(16, 0.99f);
    protected ExecutorService syncProcessor;
    protected ExecutorService asyncProcessor;

    @Inject
    void injectExecutor(@ComponentName(value="org.infinispan.executors.notification") ExecutorService executor) {
        this.asyncProcessor = executor;
    }

    @Start(priority=9)
    public void start() {
        this.syncProcessor = new WithinThreadExecutor();
    }

    @Stop(priority=99)
    void stop() {
        for (List<ListenerInvocation> list : this.listenersMap.values()) {
            if (list == null) continue;
            list.clear();
        }
        if (this.syncProcessor != null) {
            this.syncProcessor.shutdownNow();
        }
    }

    protected abstract Log getLog();

    protected abstract Map<Class<? extends Annotation>, Class<?>> getAllowedMethodAnnotations();

    protected List<ListenerInvocation> getListenerCollectionForAnnotation(Class<? extends Annotation> annotation) {
        List<ListenerInvocation> list = this.listenersMap.get(annotation);
        if (list == null) {
            throw new CacheException("Unknown listener annotation: " + annotation);
        }
        return list;
    }

    public void removeListener(Object listener) {
        for (Class<Annotation> annotation : this.getAllowedMethodAnnotations().keySet()) {
            this.removeListenerInvocation(annotation, listener);
        }
    }

    private void removeListenerInvocation(Class<? extends Annotation> annotation, Object listener) {
        if (listener == null) {
            return;
        }
        List<ListenerInvocation> l = this.getListenerCollectionForAnnotation(annotation);
        HashSet<ListenerInvocation> markedForRemoval = new HashSet<ListenerInvocation>(4);
        for (ListenerInvocation li : l) {
            if (!listener.equals(li.target)) continue;
            markedForRemoval.add(li);
        }
        l.removeAll(markedForRemoval);
    }

    public void addListener(Object listener) {
        this.addListener(listener, null);
    }

    public void addListener(Object listener, ClassLoader classLoader) {
        this.validateAndAddListenerInvocation(listener, null, null, classLoader);
    }

    public Set<Object> getListeners() {
        HashSet<Object> result = new HashSet<Object>(this.listenersMap.size());
        for (List<ListenerInvocation> list : this.listenersMap.values()) {
            for (ListenerInvocation li : list) {
                result.add(li.target);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    protected <C> void validateAndAddListenerInvocation(Object listener, KeyValueFilter<? super K, ? super V> filter, Converter<? super K, ? super V, C> converter, ClassLoader classLoader) {
        Listener l = AbstractListenerImpl.testListenerClassValidity(listener.getClass());
        UUID generatedId = UUID.randomUUID();
        boolean foundMethods = false;
        boolean foundClusterMethods = false;
        Map<Class<Annotation>, Class<?>> allowedListeners = this.getAllowedMethodAnnotations();
        for (Method m : listener.getClass().getMethods()) {
            for (Map.Entry<Class<Annotation>, Class<?>> annotationEntry : allowedListeners.entrySet()) {
                Class<Annotation> key = annotationEntry.getKey();
                Class<?> value = annotationEntry.getValue();
                if (!m.isAnnotationPresent(key)) continue;
                AbstractListenerImpl.testListenerMethodValidity(m, value, key.getName());
                m.setAccessible(true);
                this.addListenerInvocation(key, this.createListenerInvocation(listener, m, l, filter, converter, classLoader, generatedId, Subject.getSubject(AccessController.getContext())));
                foundMethods = true;
                if (!l.clustered()) continue;
                foundClusterMethods = true;
            }
        }
        if (!foundMethods) {
            this.getLog().noAnnotateMethodsFoundInListener(listener.getClass());
        } else {
            this.addedListener(listener, generatedId, foundClusterMethods, filter, converter);
        }
    }

    protected <C> ListenerInvocation createListenerInvocation(Object listener, Method m, Listener l, KeyValueFilter<? super K, ? super V> filter, Converter<? super K, ? super V, C> converter, ClassLoader classLoader, UUID generatedId, Subject subject) {
        return new ListenerInvocation(listener, m, l.sync(), l.primaryOnly(), l.clustered(), filter, converter, classLoader, generatedId, subject);
    }

    protected <C> void addedListener(Object listener, UUID generatedId, boolean hasClusteredMethods, KeyValueFilter<? super K, ? super V> filter, Converter<? super K, ? super V, C> converter) {
    }

    private void addListenerInvocation(Class<? extends Annotation> annotation, ListenerInvocation li) {
        List<ListenerInvocation> result = this.getListenerCollectionForAnnotation(annotation);
        result.add(li);
    }

    protected static Listener testListenerClassValidity(Class<?> listenerClass) {
        Listener l = (Listener)ReflectionUtil.getAnnotation(listenerClass, Listener.class);
        if (l == null) {
            throw new IncorrectListenerException(String.format("Cache listener class %s must be annotated with org.infinispan.notifications.annotation.Listener", listenerClass.getName()));
        }
        return l;
    }

    protected static void testListenerMethodValidity(Method m, Class<?> allowedParameter, String annotationName) {
        if (m.getParameterTypes().length != 1 || !m.getParameterTypes()[0].isAssignableFrom(allowedParameter)) {
            throw new IncorrectListenerException("Methods annotated with " + annotationName + " must accept exactly one parameter, of assignable from type " + allowedParameter.getName());
        }
        if (!m.getReturnType().equals(Void.TYPE)) {
            throw new IncorrectListenerException("Methods annotated with " + annotationName + " should have a return type of void.");
        }
    }

    protected abstract Transaction suspendIfNeeded();

    protected abstract void resumeIfNeeded(Transaction var1);

    private Throwable getRealException(Throwable re) {
        if (re.getCause() == null) {
            return re;
        }
        Throwable cause = re.getCause();
        if (cause instanceof RuntimeException || cause instanceof Error) {
            return this.getRealException(cause);
        }
        return re;
    }

    static ClassLoader setContextClassLoader(final ClassLoader loader) {
        PrivilegedAction<ClassLoader> action = new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(loader);
                return contextClassLoader;
            }
        };
        return AccessController.doPrivileged(action);
    }

    protected class ListenerInvocation {
        public final Object target;
        public final Method method;
        public final boolean sync;
        public final boolean onlyPrimary;
        public final boolean clustered;
        public final WeakReference<ClassLoader> classLoader;
        public final KeyValueFilter<? super K, ? super V> filter;
        public final Converter<? super K, ? super V, ?> converter;
        public final UUID generatedId;
        public final Subject subject;

        public ListenerInvocation(Object target, Method method, boolean sync, boolean onlyPrimary, boolean clustered, KeyValueFilter<? super K, ? super V> filter, Converter<? super K, ? super V, ?> converter, ClassLoader classLoader, UUID generatedId, Subject subject) {
            this.target = target;
            this.method = method;
            this.sync = sync;
            this.onlyPrimary = onlyPrimary;
            this.clustered = clustered;
            this.filter = filter;
            this.converter = converter;
            this.classLoader = new WeakReference<ClassLoader>(classLoader);
            this.generatedId = generatedId;
            this.subject = subject;
        }

        public void invoke(T event) {
            this.invoke(event, false, true);
        }

        public void invoke(T event, boolean isLocalNodePrimaryOwner) {
            this.invoke(event, isLocalNodePrimaryOwner, false);
        }

        public void invoke(final T event, boolean isLocalNodePrimaryOwner, final boolean unKeyed) {
            if (unKeyed || this.shouldInvoke(event, isLocalNodePrimaryOwner)) {
                Runnable r = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block18: {
                            ClassLoader contextClassLoader = null;
                            Transaction transaction = AbstractListenerImpl.this.suspendIfNeeded();
                            if (ListenerInvocation.this.classLoader != null && ListenerInvocation.this.classLoader.get() != null) {
                                contextClassLoader = AbstractListenerImpl.setContextClassLoader((ClassLoader)ListenerInvocation.this.classLoader.get());
                            }
                            try {
                                if (!unKeyed && ListenerInvocation.this.converter != null) {
                                    if (event instanceof EventImpl) {
                                        EventImpl eventImpl = (EventImpl)event;
                                        eventImpl.setValue(ListenerInvocation.this.converter.convert(eventImpl.getKey(), eventImpl.getValue(), eventImpl.getMetadata()));
                                    } else {
                                        throw new IllegalArgumentException("Provided event should be EventImpl when a converter isbeing used!");
                                    }
                                }
                                if (ListenerInvocation.this.subject != null) {
                                    try {
                                        Subject.doAs(ListenerInvocation.this.subject, new PrivilegedExceptionAction<Void>(){

                                            @Override
                                            public Void run() throws Exception {
                                                ListenerInvocation.this.method.invoke(ListenerInvocation.this.target, event);
                                                return null;
                                            }
                                        });
                                        break block18;
                                    }
                                    catch (PrivilegedActionException e) {
                                        Throwable cause = e.getCause();
                                        if (cause instanceof InvocationTargetException) {
                                            throw (InvocationTargetException)cause;
                                        }
                                        if (cause instanceof IllegalAccessException) {
                                            throw (IllegalAccessException)cause;
                                        }
                                        throw new InvocationTargetException(cause);
                                    }
                                }
                                ListenerInvocation.this.method.invoke(ListenerInvocation.this.target, event);
                            }
                            catch (InvocationTargetException exception) {
                                Throwable cause = AbstractListenerImpl.this.getRealException(exception);
                                if (ListenerInvocation.this.sync) {
                                    throw AbstractListenerImpl.this.getLog().exceptionInvokingListener(cause.getClass().getName(), ListenerInvocation.this.method, ListenerInvocation.this.target, cause);
                                }
                                AbstractListenerImpl.this.getLog().unableToInvokeListenerMethod(ListenerInvocation.this.method, ListenerInvocation.this.target, cause);
                            }
                            catch (IllegalAccessException exception) {
                                AbstractListenerImpl.this.getLog().unableToInvokeListenerMethod(ListenerInvocation.this.method, ListenerInvocation.this.target, exception);
                                AbstractListenerImpl.this.removeListener(ListenerInvocation.this.target);
                            }
                            finally {
                                if (ListenerInvocation.this.classLoader != null && ListenerInvocation.this.classLoader.get() != null) {
                                    AbstractListenerImpl.setContextClassLoader(contextClassLoader);
                                }
                                AbstractListenerImpl.this.resumeIfNeeded(transaction);
                            }
                        }
                    }
                };
                if (this.sync) {
                    AbstractListenerImpl.this.syncProcessor.execute(r);
                } else {
                    AbstractListenerImpl.this.asyncProcessor.execute(r);
                }
            }
        }

        private boolean shouldInvoke(T event, boolean isLocalNodePrimaryOwner) {
            if (this.onlyPrimary && !isLocalNodePrimaryOwner) {
                return false;
            }
            if (event instanceof EventImpl) {
                EventImpl eventImpl = (EventImpl)event;
                if (eventImpl.isPre() && this.clustered) {
                    return false;
                }
                if (this.filter != null && !this.filter.accept(eventImpl.getKey(), eventImpl.getValue(), eventImpl.getMetadata())) {
                    return false;
                }
            }
            return true;
        }
    }
}

