/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.filter.KeyFilter;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.metadata.impl.InternalMetadataImpl;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PersistenceUtil {
    private static Log log = LogFactory.getLog(PersistenceUtil.class);

    public static KeyFilter notNull(KeyFilter filter) {
        return filter == null ? KeyFilter.LOAD_ALL_FILTER : filter;
    }

    public static <K> int count(AdvancedCacheLoader<K, ?> acl, KeyFilter<? super K> filter) {
        final AtomicInteger result = new AtomicInteger(0);
        acl.process(filter, new AdvancedCacheLoader.CacheLoaderTask(){

            public void processEntry(MarshalledEntry marshalledEntry, AdvancedCacheLoader.TaskContext taskContext) throws InterruptedException {
                result.incrementAndGet();
            }
        }, new WithinThreadExecutor(), false, false);
        return result.get();
    }

    public static <K> Set<K> toKeySet(AdvancedCacheLoader<K, ?> acl, KeyFilter<? super K> filter) {
        if (acl == null) {
            return Collections.emptySet();
        }
        final HashSet set = new HashSet();
        acl.process(filter, new AdvancedCacheLoader.CacheLoaderTask<K, Object>(){

            @Override
            public void processEntry(MarshalledEntry<K, Object> marshalledEntry, AdvancedCacheLoader.TaskContext taskContext) throws InterruptedException {
                set.add(marshalledEntry.getKey());
            }
        }, new WithinThreadExecutor(), false, false);
        return set;
    }

    public static <K> Set<InternalCacheEntry> toEntrySet(AdvancedCacheLoader<K, ?> acl, KeyFilter<? super K> filter, final InternalEntryFactory ief) {
        if (acl == null) {
            return Collections.emptySet();
        }
        final HashSet<InternalCacheEntry> set = new HashSet<InternalCacheEntry>();
        acl.process(filter, new AdvancedCacheLoader.CacheLoaderTask(){

            public void processEntry(MarshalledEntry ce, AdvancedCacheLoader.TaskContext taskContext) throws InterruptedException {
                set.add(ief.create(ce.getKey(), ce.getValue(), ce.getMetadata()));
            }
        }, new WithinThreadExecutor(), true, true);
        return set;
    }

    public static long getExpiryTime(InternalMetadata internalMetadata) {
        return internalMetadata == null ? -1L : internalMetadata.expiryTime();
    }

    public static InternalMetadata internalMetadata(InternalCacheEntry ice) {
        return ice.getMetadata() == null ? null : new InternalMetadataImpl(ice);
    }

    public static InternalMetadata internalMetadata(InternalCacheValue icv) {
        return icv.getMetadata() == null ? null : new InternalMetadataImpl(icv.getMetadata(), icv.getCreated(), icv.getLastUsed());
    }
}

