/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security.impl;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import org.infinispan.configuration.cache.AuthorizationConfiguration;
import org.infinispan.configuration.global.GlobalSecurityConfiguration;
import org.infinispan.security.AuditContext;
import org.infinispan.security.AuditLogger;
import org.infinispan.security.AuditResponse;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Role;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class AuthorizationHelper {
    private static final Log log = LogFactory.getLog(AuthorizationHelper.class);
    private final GlobalSecurityConfiguration globalConfiguration;
    private final AuditLogger audit;
    private final AuditContext context;
    private final String name;

    public AuthorizationHelper(GlobalSecurityConfiguration globalConfiguration, AuditContext context, String name) {
        this.globalConfiguration = globalConfiguration;
        this.audit = globalConfiguration.authorization().auditLogger();
        this.context = context;
        this.name = name;
    }

    public void checkPermission(Subject subject, int subjectMask, AuthorizationPermission perm) {
        if ((subjectMask & perm.getMask()) != perm.getMask()) {
            if (System.getSecurityManager() == null) {
                try {
                    if (subject != null) {
                        throw new AccessControlException(perm.toString());
                    }
                    AccessController.getContext().checkPermission(perm.getSecurityPermission());
                }
                catch (AccessControlException ace) {
                    this.audit.audit(subject, this.context, this.name, perm, AuditResponse.DENY);
                    throw log.unauthorizedAccess(String.valueOf(subject), perm.toString());
                }
            } else {
                System.getSecurityManager().checkPermission(perm.getSecurityPermission());
            }
        }
        this.audit.audit(subject, this.context, this.name, perm, AuditResponse.ALLOW);
    }

    public void checkPermission(AuthorizationConfiguration configuration, AuthorizationPermission perm) {
        if (this.globalConfiguration.authorization().enabled()) {
            AccessControlContext acc = AccessController.getContext();
            Subject subject = Subject.getSubject(acc);
            int subjectMask = AuthorizationHelper.computeSubjectRoleMask(subject, this.globalConfiguration, configuration);
            this.checkPermission(subject, subjectMask, perm);
        }
    }

    public void checkPermission(AuthorizationPermission perm) {
        this.checkPermission(null, perm);
    }

    public static int computeSubjectRoleMask(Subject subject, GlobalSecurityConfiguration globalConfiguration, AuthorizationConfiguration configuration) {
        PrincipalRoleMapper roleMapper = globalConfiguration.authorization().principalRoleMapper();
        int mask = 0;
        if (subject != null) {
            for (Principal principal : subject.getPrincipals()) {
                Set<String> roleNames = roleMapper.principalToRoles(principal);
                if (roleNames == null) continue;
                for (String roleName : roleNames) {
                    Role role;
                    if (configuration != null && !configuration.roles().contains(roleName) || (role = globalConfiguration.authorization().roles().get(roleName)) == null) continue;
                    mask |= role.getMask();
                }
            }
        }
        return mask;
    }
}

