/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.TransactionBoundaryCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.remoting.RemoteException;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.statetransfer.AffectedKeysVisitor;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.topology.CacheTopology;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StateTransferInterceptor
extends CommandInterceptor {
    private static final Log log = LogFactory.getLog(StateTransferInterceptor.class);
    private static boolean trace = log.isTraceEnabled();
    private StateTransferLock stateTransferLock;
    private StateTransferManager stateTransferManager;
    private CommandsFactory commandFactory;
    private boolean useVersioning;
    private long transactionDataTimeout;
    private final AffectedKeysVisitor affectedKeysVisitor = new AffectedKeysVisitor();

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void init(StateTransferLock stateTransferLock, Configuration configuration, CommandsFactory commandFactory, StateTransferManager stateTransferManager) {
        this.stateTransferLock = stateTransferLock;
        this.commandFactory = commandFactory;
        this.stateTransferManager = stateTransferManager;
        this.useVersioning = configuration.transaction().transactionMode().isTransactional() && configuration.locking().writeSkewCheck() && configuration.transaction().lockingMode() == LockingMode.OPTIMISTIC && configuration.versioning().enabled();
        this.transactionDataTimeout = configuration.clustering().sync().replTimeout();
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (ctx.getCacheTransaction() instanceof RemoteTransaction) {
            ((RemoteTransaction)ctx.getCacheTransaction()).setLookedUpEntriesTopology(command.getTopologyId());
        }
        return this.handleTxCommand(ctx, command);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (ctx.getCacheTransaction() instanceof RemoteTransaction) {
            RemoteTransaction remoteTx = (RemoteTransaction)ctx.getCacheTransaction();
            if (trace) {
                log.tracef("Remote tx topology id %d and command topology is %d", remoteTx.lookedUpEntriesTopology(), command.getTopologyId());
            }
            if (remoteTx.lookedUpEntriesTopology() < command.getTopologyId()) {
                remoteTx.setLookedUpEntriesTopology(command.getTopologyId());
                PrepareCommand prepareCommand = this.useVersioning ? this.commandFactory.buildVersionedPrepareCommand(ctx.getGlobalTransaction(), ctx.getModifications(), false) : this.commandFactory.buildPrepareCommand(ctx.getGlobalTransaction(), ctx.getModifications(), false);
                this.commandFactory.initializeReplicableCommand(prepareCommand, true);
                prepareCommand.setOrigin(ctx.getOrigin());
                log.tracef("Replaying the transactions received as a result of state transfer %s", prepareCommand);
                prepareCommand.perform(null);
            }
        }
        return this.handleTxCommand(ctx, command);
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        return this.handleTxCommand(ctx, command);
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        return this.handleTxCommand(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitInvalidateL1Command(InvocationContext ctx, InvalidateL1Command command) throws Throwable {
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        return this.invokeNextInterceptor(ctx, command);
    }

    private Object handleTxCommand(TxInvocationContext ctx, TransactionBoundaryCommand command) throws Throwable {
        Address address = ctx.isOriginLocal() ? ctx.getOrigin() : ctx.getGlobalTransaction().getAddress();
        return this.handleTopologyAffectedCommand(ctx, command, address, true);
    }

    private Object handleNonTxWriteCommand(InvocationContext ctx, WriteCommand command) throws Throwable {
        log.tracef("handleNonTxWriteCommand for command %s", command);
        if (this.isLocalOnly(ctx, command)) {
            return this.invokeNextInterceptor(ctx, command);
        }
        this.updateTopologyId(command);
        if (!ctx.isOriginLocal()) {
            return this.invokeNextInterceptor(ctx, command);
        }
        int commandTopologyId = command.getTopologyId();
        try {
            Object localResult = this.invokeNextInterceptor(ctx, command);
            return localResult;
        }
        catch (CacheException e) {
            Throwable ce = e;
            while (ce instanceof RemoteException) {
                ce = ce.getCause();
            }
            if (!(ce instanceof OutdatedTopologyException) && !(ce instanceof SuspectException)) {
                throw e;
            }
            log.tracef("Retrying command because of topology change: %s", command);
            int newTopologyId = Math.max(this.stateTransferManager.getCacheTopology().getTopologyId(), commandTopologyId + 1);
            command.setTopologyId(newTopologyId);
            command.setFlags(Flag.COMMAND_RETRY);
            this.stateTransferLock.waitForTransactionData(newTopologyId, this.transactionDataTimeout, TimeUnit.MILLISECONDS);
            Object localResult = this.handleNonTxWriteCommand(ctx, command);
            return localResult;
        }
    }

    @Override
    protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        if (command instanceof TopologyAffectedCommand) {
            return this.handleTopologyAffectedCommand(ctx, command, ctx.getOrigin(), true);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private Object handleTopologyAffectedCommand(InvocationContext ctx, VisitableCommand command, Address origin, boolean sync) throws Throwable {
        log.tracef("handleTopologyAffectedCommand for command %s", command);
        if (this.isLocalOnly(ctx, command)) {
            return this.invokeNextInterceptor(ctx, command);
        }
        this.updateTopologyId((TopologyAffectedCommand)((Object)command));
        Object localResult = this.invokeNextInterceptor(ctx, command);
        boolean isNonTransactionalWrite = !ctx.isInTxScope() && command instanceof WriteCommand;
        boolean isTransactionalAndNotRolledBack = false;
        if (ctx.isInTxScope()) {
            boolean bl = isTransactionalAndNotRolledBack = !((AbstractCacheTransaction)((TxInvocationContext)ctx).getCacheTransaction()).isMarkedForRollback();
        }
        if (isNonTransactionalWrite || isTransactionalAndNotRolledBack) {
            Map<Address, Response> responseMap = this.stateTransferManager.forwardCommandIfNeeded((TopologyAffectedCommand)((Object)command), this.getAffectedKeys(ctx, command), origin, sync);
            localResult = this.mergeResponses(responseMap, localResult, ctx, command);
        }
        return localResult;
    }

    private Object mergeResponses(Map<Address, Response> responseMap, Object localResult, InvocationContext context, VisitableCommand command) {
        if (command instanceof VersionedPrepareCommand) {
            return this.mergeVersionedPrepareCommand(responseMap, (TxInvocationContext)context, localResult);
        }
        return localResult;
    }

    private Object mergeVersionedPrepareCommand(Map<Address, Response> responseMap, TxInvocationContext txInvocationContext, Object localResult) {
        if (txInvocationContext.isOriginLocal()) {
            Object cacheTransaction = txInvocationContext.getCacheTransaction();
            for (Response response : responseMap.values()) {
                SuccessfulResponse sr;
                EntryVersionsMap uv;
                if (response == null || !response.isSuccessful() || (uv = (EntryVersionsMap)(sr = (SuccessfulResponse)response).getResponseValue()) == null) continue;
                cacheTransaction.setUpdatedEntryVersions(uv.merge(cacheTransaction.getUpdatedEntryVersions()));
            }
            return localResult;
        }
        EntryVersionsMap mergeResult = localResult instanceof EntryVersionsMap ? (EntryVersionsMap)localResult : new EntryVersionsMap();
        for (Response response : responseMap.values()) {
            SuccessfulResponse sr;
            EntryVersionsMap uv;
            if (response == null || !response.isSuccessful() || (uv = (EntryVersionsMap)(sr = (SuccessfulResponse)response).getResponseValue()) == null) continue;
            mergeResult = mergeResult.merge(uv);
        }
        return mergeResult;
    }

    private void updateTopologyId(TopologyAffectedCommand command) throws InterruptedException {
        CacheTopology cacheTopology;
        if (command.getTopologyId() == -1 && (cacheTopology = this.stateTransferManager.getCacheTopology()) != null) {
            command.setTopologyId(cacheTopology.getTopologyId());
        }
    }

    private boolean isLocalOnly(InvocationContext ctx, VisitableCommand command) {
        boolean transactionalWrite = ctx.isInTxScope() && command instanceof WriteCommand;
        boolean cacheModeLocal = false;
        if (command instanceof FlagAffectedCommand) {
            cacheModeLocal = ((FlagAffectedCommand)command).hasFlag(Flag.CACHE_MODE_LOCAL);
        }
        return cacheModeLocal || transactionalWrite;
    }

    private Set<Object> getAffectedKeys(InvocationContext ctx, VisitableCommand command) {
        Set affectedKeys = null;
        try {
            affectedKeys = (Set)command.acceptVisitor(ctx, this.affectedKeysVisitor);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (affectedKeys == null) {
            affectedKeys = InfinispanCollections.emptySet();
        }
        return affectedKeys;
    }
}

