/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.concurrent.NotifyingFutureImpl;
import org.infinispan.commons.util.concurrent.NotifyingNotifiableFuture;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.SitesConfiguration;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.remoting.LocalInvocation;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ResponseGenerator;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.BackupResponse;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.XSiteReplicateCommand;
import org.infinispan.xsite.statetransfer.XSiteStateTransferCollector;
import org.infinispan.xsite.statetransfer.XSiteStateTransferControlCommand;
import org.infinispan.xsite.statetransfer.XSiteStateTransferManager;

public class XSiteStateTransferManagerImpl
implements XSiteStateTransferManager {
    private final ConcurrentMap<String, XSiteStateTransferCollector> siteCollector = CollectionFactory.makeConcurrentMap();
    private RpcManager rpcManager;
    private Configuration configuration;
    private CommandsFactory commandsFactory;
    private ResponseGenerator responseGenerator;
    private ExecutorService asyncExecutor;

    @Inject
    public void inject(RpcManager rpcManager, Configuration configuration, CommandsFactory commandsFactory, ResponseGenerator responseGenerator, @ComponentName(value="org.infinispan.executors.transport") ExecutorService asyncExecutor) {
        this.rpcManager = rpcManager;
        this.configuration = configuration;
        this.commandsFactory = commandsFactory;
        this.responseGenerator = responseGenerator;
        this.asyncExecutor = asyncExecutor;
    }

    @Override
    public void notifyStatePushFinished(String siteName, Address node) throws Throwable {
        XSiteStateTransferCollector collector = (XSiteStateTransferCollector)this.siteCollector.get(siteName);
        if (collector == null) {
            return;
        }
        XSiteBackup xSiteBackup = this.findSite(siteName);
        if (collector.confirmStateTransfer(node)) {
            this.siteCollector.remove(siteName);
            this.controlStateTransferOnRemoteSite(xSiteBackup, XSiteStateTransferControlCommand.StateTransferControl.FINISH_RECEIVE);
        }
    }

    @Override
    public final void startPushState(String siteName) throws Throwable {
        if (siteName == null) {
            throw new NullPointerException("Site name cannot be null!");
        }
        XSiteBackup xSiteBackup = this.findSite(siteName);
        if (xSiteBackup == null) {
            throw new IllegalArgumentException("Site " + siteName + " not found!");
        }
        if (this.siteCollector.putIfAbsent(siteName, new XSiteStateTransferCollector(this.rpcManager.getMembers())) != null) {
            throw new Exception(String.format("X-Site state transfer to '%s' already started!", siteName));
        }
        try {
            this.controlStateTransferOnRemoteSite(xSiteBackup, XSiteStateTransferControlCommand.StateTransferControl.START_RECEIVE);
            this.controlStateTransferOnLocalSite(XSiteStateTransferControlCommand.StateTransferControl.START_SEND, siteName);
        }
        catch (Throwable throwable) {
            this.handleFailure(xSiteBackup);
            throw new Exception(throwable);
        }
    }

    @Override
    public List<String> getRunningStateTransfers() {
        return this.siteCollector.isEmpty() ? Collections.emptyList() : new ArrayList(this.siteCollector.keySet());
    }

    private void handleFailure(XSiteBackup xSiteBackup) {
        try {
            this.controlStateTransferOnLocalSite(XSiteStateTransferControlCommand.StateTransferControl.CANCEL_SEND, xSiteBackup.getSiteName());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.controlStateTransferOnRemoteSite(xSiteBackup, XSiteStateTransferControlCommand.StateTransferControl.FINISH_RECEIVE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void controlStateTransferOnRemoteSite(XSiteBackup xSiteBackup, XSiteStateTransferControlCommand.StateTransferControl control) throws Throwable {
        XSiteStateTransferControlCommand command = this.commandsFactory.buildXSiteStateTransferControlCommand(control, null);
        BackupResponse response = this.invokeRemotelyInRemoteSite(command, xSiteBackup);
        response.waitForBackupToFinish();
        if (!response.getFailedBackups().values().isEmpty()) {
            throw response.getFailedBackups().values().iterator().next();
        }
    }

    private void controlStateTransferOnLocalSite(XSiteStateTransferControlCommand.StateTransferControl control, String siteName) throws Exception {
        XSiteStateTransferControlCommand command = this.commandsFactory.buildXSiteStateTransferControlCommand(control, siteName);
        for (Map.Entry<Address, Response> entry : this.invokeRemotelyInLocalSite(command).entrySet()) {
            if (!(entry.getValue() instanceof ExceptionResponse)) continue;
            throw ((ExceptionResponse)entry.getValue()).getException();
        }
    }

    private XSiteBackup findSite(String siteName) {
        SitesConfiguration sites = this.configuration.sites();
        for (BackupConfiguration bc : sites.allBackups()) {
            if (!bc.site().equals(siteName)) continue;
            return new XSiteBackup(bc.site(), true, bc.stateTransfer().timeout());
        }
        return null;
    }

    private Map<Address, Response> invokeRemotelyInLocalSite(CacheRpcCommand command) throws Exception {
        this.commandsFactory.initializeReplicableCommand(command, false);
        NotifyingFutureImpl remoteFuture = new NotifyingFutureImpl();
        this.rpcManager.invokeRemotelyInFuture(null, (ReplicableCommand)command, this.rpcManager.getDefaultRpcOptions(true, false), (NotifyingNotifiableFuture<Object>)remoteFuture);
        Future<Response> localFuture = this.asyncExecutor.submit(LocalInvocation.newInstance(this.responseGenerator, command, this.commandsFactory, this.rpcManager.getAddress()));
        HashMap<Address, Response> responseMap = new HashMap<Address, Response>();
        responseMap.put(this.rpcManager.getAddress(), localFuture.get());
        responseMap.putAll((Map)remoteFuture.get());
        return responseMap;
    }

    private BackupResponse invokeRemotelyInRemoteSite(XSiteReplicateCommand command, XSiteBackup xSiteBackup) throws Exception {
        return this.rpcManager.getTransport().backupRemotely(Collections.singletonList(xSiteBackup), command);
    }
}

