/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.binary;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.executors.ExecutorAllCompletionService;
import org.infinispan.filter.KeyFilter;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.TaskContextImpl;
import org.infinispan.persistence.jdbc.JdbcUtil;
import org.infinispan.persistence.jdbc.TableManipulation;
import org.infinispan.persistence.jdbc.configuration.JdbcBinaryStoreConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.connectionfactory.ManagedConnectionFactory;
import org.infinispan.persistence.jdbc.logging.Log;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.support.Bucket;
import org.infinispan.util.concurrent.locks.StripedLock;
import org.infinispan.util.logging.LogFactory;

@ConfiguredBy(value=JdbcBinaryStoreConfiguration.class)
public class JdbcBinaryStore
implements AdvancedLoadWriteStore {
    private static final Log log = (Log)LogFactory.getLog(JdbcBinaryStore.class, Log.class);
    private StripedLock locks;
    private JdbcBinaryStoreConfiguration configuration;
    private ConnectionFactory connectionFactory;
    private TableManipulation tableManipulation;
    private InitializationContext ctx;
    private Equivalence<Object> keyEquivalence;

    public void init(InitializationContext ctx) {
        this.ctx = ctx;
        this.configuration = (JdbcBinaryStoreConfiguration)ctx.getConfiguration();
    }

    public void start() {
        this.locks = new StripedLock(this.configuration.lockConcurrencyLevel());
        if (this.configuration.manageConnectionFactory()) {
            ConnectionFactory factory = ConnectionFactory.getConnectionFactory(this.configuration.connectionFactory().connectionFactoryClass());
            factory.start(this.configuration.connectionFactory(), factory.getClass().getClassLoader());
            this.doConnectionFactoryInitialization(factory);
        }
        this.keyEquivalence = this.ctx.getCache().getCacheConfiguration().dataContainer().keyEquivalence();
    }

    public void stop() {
        Throwable cause = null;
        try {
            this.tableManipulation.stop();
        }
        catch (Throwable t) {
            cause = t;
            log.debug("Exception while stopping", t);
        }
        try {
            if (this.configuration.connectionFactory() instanceof ManagedConnectionFactory) {
                log.tracef("Stopping mananged connection factory: %s", this.connectionFactory);
                this.connectionFactory.stop();
            }
        }
        catch (Throwable t) {
            if (cause == null) {
                cause = t;
            }
            log.debug("Exception while stopping", t);
        }
        if (cause != null) {
            throw new PersistenceException("Exceptions occurred while stopping store", cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(MarshalledEntry entry) {
        log.tracef("store(%s)", entry);
        InternalMetadata m = entry.getMetadata();
        if (m != null && m.isExpired(this.ctx.getTimeService().wallClockTime())) {
            this.delete(entry.getKey());
            return;
        }
        Integer bucketId = this.getBuckedId(entry.getKey());
        this.lockBucketForWriting(bucketId);
        try {
            this.storeInBucket(entry, bucketId);
        }
        finally {
            this.unlock(bucketId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MarshalledEntry load(Object key) {
        Integer bucketId = this.getBuckedId(key);
        this.lockBucketForReading(bucketId);
        try {
            Bucket bucket = this.loadBucket(bucketId);
            if (bucket == null) {
                MarshalledEntry marshalledEntry = null;
                return marshalledEntry;
            }
            MarshalledEntry marshalledEntry = bucket.getEntry(key, this.ctx.getTimeService());
            return marshalledEntry;
        }
        finally {
            this.unlock(bucketId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object key) {
        Integer bucketId = this.getBuckedId(key);
        this.lockBucketForReading(bucketId);
        try {
            Bucket bucket = this.loadBucket(bucketId);
            boolean bl = bucket != null && bucket.contains(key, this.ctx.getTimeService());
            return bl;
        }
        finally {
            this.unlock(bucketId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean delete(Object key) {
        log.tracef("delete(%s)", key);
        Integer bucketId = this.getBuckedId(key);
        try {
            this.lockBucketForWriting(bucketId);
            boolean bl = this.removeKeyFromBucket(key, bucketId);
            return bl;
        }
        finally {
            this.unlock(bucketId);
            log.tracef("Exit delete(%s)", key);
        }
    }

    public void process(final KeyFilter filter, final AdvancedCacheLoader.CacheLoaderTask task, Executor executor, boolean fetchValue, boolean fetchMetadata) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = this.tableManipulation.getLoadNonExpiredAllRowsSql();
            if (log.isTraceEnabled()) {
                log.tracef("Running sql %s", sql);
            }
            conn = this.connectionFactory.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setLong(1, this.ctx.getTimeService().wallClockTime());
            rs = ps.executeQuery();
            rs.setFetchSize(this.tableManipulation.getFetchSize());
            ExecutorAllCompletionService ecs = new ExecutorAllCompletionService(executor);
            final TaskContextImpl taskContext = new TaskContextImpl();
            while (rs.next()) {
                InputStream binaryStream = rs.getBinaryStream(1);
                final Bucket bucket = this.unmarshallBucket(binaryStream);
                ecs.submit((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        try {
                            for (MarshalledEntry me : bucket.getStoredEntries(filter, JdbcBinaryStore.this.ctx.getTimeService()).values()) {
                                if (taskContext.isStopped()) continue;
                                task.processEntry(me, (AdvancedCacheLoader.TaskContext)taskContext);
                            }
                            return null;
                        }
                        catch (Exception e) {
                            log.errorExecutingParallelStoreTask(e);
                            throw e;
                        }
                    }
                });
            }
            ecs.waitUntilAllCompleted();
            if (ecs.isExceptionThrown()) {
                throw new PersistenceException("Execution exception!", (Throwable)ecs.getFirstException());
            }
        }
        catch (SQLException e) {
            try {
                log.sqlFailureFetchingAllStoredEntries(e);
                throw new PersistenceException("SQL error while fetching all StoredEntries", (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(rs);
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(rs);
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(conn);
    }

    public void clear() {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            String sql = this.tableManipulation.getDeleteAllRowsSql();
            conn = this.connectionFactory.getConnection();
            ps = conn.prepareStatement(sql);
            int result = ps.executeUpdate();
            if (log.isTraceEnabled()) {
                log.tracef("Successfully removed %d rows.", result);
            }
        }
        catch (SQLException ex) {
            try {
                log.failedClearingJdbcCacheStore(ex);
                throw new PersistenceException("Failed clearing cache store", (Throwable)ex);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(conn);
    }

    public int size() {
        return PersistenceUtil.count((AdvancedCacheLoader)this, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge(Executor threadPool, AdvancedCacheWriter.PurgeListener task) {
        String sql;
        HashSet<Bucket> emptyBuckets;
        PreparedStatement ps;
        Connection conn;
        block22: {
            conn = null;
            ps = null;
            ResultSet rs = null;
            HashSet<Object> expiredBuckets = new HashSet<Bucket>();
            int batchSize = 100;
            ExecutorAllCompletionService eacs = new ExecutorAllCompletionService(threadPool);
            emptyBuckets = new HashSet<Bucket>(100);
            int taskCount = 0;
            try {
                sql = this.tableManipulation.getSelectExpiredRowsSql();
                conn = this.connectionFactory.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setLong(1, this.ctx.getTimeService().wallClockTime());
                rs = ps.executeQuery();
                while (rs.next()) {
                    Integer bucketId = rs.getInt(2);
                    if (this.immediateLockForWriting(bucketId)) {
                        if (log.isTraceEnabled()) {
                            log.tracef("Adding bucket keyed %s for purging.", bucketId);
                        }
                        InputStream binaryStream = rs.getBinaryStream(1);
                        Bucket bucket = this.unmarshallBucket(binaryStream);
                        bucket.setBucketId(bucketId);
                        expiredBuckets.add(bucket);
                        if (expiredBuckets.size() != 100) continue;
                        eacs.submit((Callable)new BucketPurger(expiredBuckets, task, this.ctx.getMarshaller(), conn, emptyBuckets));
                        ++taskCount;
                        expiredBuckets = new HashSet(100);
                        continue;
                    }
                    if (!log.isTraceEnabled()) continue;
                    log.tracef("Could not acquire write lock for %s, this won't be purged even though it has expired elements", bucketId);
                }
                if (!expiredBuckets.isEmpty()) {
                    eacs.submit((Callable)new BucketPurger(expiredBuckets, task, this.ctx.getMarshaller(), conn, emptyBuckets));
                }
            }
            catch (Exception ex) {
                try {
                    this.releaseLocks(expiredBuckets);
                    log.failedClearingJdbcCacheStore(ex);
                    throw new PersistenceException("Failed clearing JdbcBinaryStore", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    JdbcUtil.safeClose(ps);
                    JdbcUtil.safeClose(rs);
                    throw throwable;
                }
            }
            JdbcUtil.safeClose(ps);
            JdbcUtil.safeClose(rs);
            eacs.waitUntilAllCompleted();
            if (eacs.isExceptionThrown()) {
                this.releaseLocks(emptyBuckets);
            }
            if (!emptyBuckets.isEmpty()) break block22;
            this.connectionFactory.releaseConnection(conn);
            return;
        }
        try {
            if (log.isTraceEnabled()) {
                log.tracef("About to remove empty buckets %s", emptyBuckets);
            }
            try {
                sql = this.tableManipulation.getDeleteRowSql();
                ps = conn.prepareStatement(sql);
                int deletionCount = 0;
                for (Bucket bucket : emptyBuckets) {
                    ps.setString(1, bucket.getBucketIdAsString());
                    ps.addBatch();
                    if (++deletionCount % 100 != 0) continue;
                    if (log.isTraceEnabled()) {
                        log.tracef("Flushing deletion batch, total deletion count so far is %d", deletionCount);
                    }
                    ps.executeBatch();
                }
                if (deletionCount % 100 != 0) {
                    int[] batchResult = ps.executeBatch();
                    if (log.isTraceEnabled()) {
                        log.tracef("Flushed the batch and received following results: %s", Arrays.toString(batchResult));
                    }
                }
            }
            catch (Exception ex) {
                log.failedClearingJdbcCacheStore(ex);
                throw new PersistenceException("Failed clearing JdbcBinaryStore", (Throwable)ex);
            }
            finally {
                this.releaseLocks(emptyBuckets);
                JdbcUtil.safeClose(ps);
            }
            this.connectionFactory.releaseConnection(conn);
        }
        catch (Throwable throwable) {
            this.connectionFactory.releaseConnection(conn);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void insertBucket(Bucket bucket) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            String sql = this.tableManipulation.getInsertRowSql();
            ByteBuffer byteBuffer = JdbcUtil.marshall(this.ctx.getMarshaller(), bucket.getStoredEntries());
            if (log.isTraceEnabled()) {
                log.tracef("Running insertBucket. Sql: '%s', on bucket: %s stored value size is %d bytes", sql, bucket, byteBuffer.getLength());
            }
            conn = this.connectionFactory.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setBinaryStream(1, (InputStream)new ByteArrayInputStream(byteBuffer.getBuf(), byteBuffer.getOffset(), byteBuffer.getLength()), byteBuffer.getLength());
            ps.setLong(2, bucket.timestampOfFirstEntryToExpire());
            ps.setString(3, bucket.getBucketIdAsString());
            int insertedRows = ps.executeUpdate();
            if (insertedRows != 1) {
                throw new PersistenceException("Unexpected insert result: '" + insertedRows + "'. Expected values is 1");
            }
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(conn);
            return;
        }
        catch (SQLException ex) {
            log.sqlFailureInsertingBucket(bucket, ex);
            throw new PersistenceException(String.format("Sql failure while inserting bucket: %s", bucket), (Throwable)ex);
            catch (InterruptedException ie) {
                if (log.isTraceEnabled()) {
                    log.trace("Interrupted while marshalling to insert a bucket");
                }
                Thread.currentThread().interrupt();
                return;
            }
        }
        finally {
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(conn);
        }
    }

    /*
     * Exception decompiling
     */
    protected void updateBucket(Bucket bucket) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Bucket loadBucket(Integer bucketId) {
        Bucket bucket;
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block6: {
            conn = null;
            ps = null;
            rs = null;
            String sql = this.tableManipulation.getSelectRowSql();
            if (log.isTraceEnabled()) {
                log.tracef("Running loadBucket. Sql: '%s', on key: %s", sql, bucketId);
            }
            conn = this.connectionFactory.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setString(1, String.valueOf(bucketId));
            rs = ps.executeQuery();
            if (rs.next()) break block6;
            Bucket bucket2 = null;
            JdbcUtil.safeClose(rs);
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(conn);
            return bucket2;
        }
        try {
            String bucketName = rs.getString(1);
            InputStream inputStream = rs.getBinaryStream(2);
            Bucket bucket3 = this.unmarshallBucket(inputStream);
            bucket3.setBucketId(bucketName);
            bucket = bucket3;
        }
        catch (SQLException e) {
            try {
                log.sqlFailureLoadingKey(String.valueOf(bucketId), e);
                throw new PersistenceException(String.format("Sql failure while loading key: %s", bucketId), (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(rs);
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(rs);
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(conn);
        return bucket;
    }

    private void releaseLocks(Collection<Bucket> expiredBucketKeys) {
        for (Bucket bucket : expiredBucketKeys) {
            this.unlock(bucket.getBucketId());
        }
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void doConnectionFactoryInitialization(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        this.tableManipulation = new TableManipulation(this.configuration.table());
        this.tableManipulation.setCacheName(this.ctx.getCache().getName());
        this.tableManipulation.start(connectionFactory);
    }

    public TableManipulation getTableManipulation() {
        return this.tableManipulation;
    }

    protected void storeInBucket(MarshalledEntry me, Integer bucketId) {
        Bucket bucket = this.loadBucket(bucketId);
        if (bucket != null) {
            bucket.addEntry(me.getKey(), me);
            this.updateBucket(bucket);
        } else {
            bucket = new Bucket(this.keyEquivalence);
            bucket.setBucketId(bucketId);
            bucket.addEntry(me.getKey(), me);
            this.insertBucket(bucket);
        }
    }

    protected boolean removeKeyFromBucket(Object key, Integer bucketId) {
        Bucket bucket = this.loadBucket(bucketId);
        if (bucket == null) {
            return false;
        }
        boolean success = bucket.removeEntry(key);
        if (success) {
            this.updateBucket(bucket);
        }
        return success;
    }

    public Integer getBuckedId(Object key) {
        return this.keyEquivalence.hashCode(key) & 0xFFFFFC00;
    }

    protected final void unlock(Integer key) {
        this.locks.releaseLock((Object)key);
    }

    protected final void lockBucketForWriting(Integer key) {
        this.locks.acquireLock((Object)key, true);
    }

    protected final void lockBucketForReading(Integer bucket) {
        this.locks.acquireLock((Object)bucket, false);
    }

    protected final boolean immediateLockForWriting(Integer key) {
        return this.locks.acquireLock((Object)key, true, 0L);
    }

    public JdbcBinaryStoreConfiguration getConfiguration() {
        return this.configuration;
    }

    private Bucket unmarshallBucket(InputStream stream) throws PersistenceException {
        Map entries = (Map)JdbcUtil.unmarshall(this.ctx.getMarshaller(), stream);
        return new Bucket(entries, this.keyEquivalence);
    }

    private class BucketPurger
    implements Callable<Void> {
        private final Collection<Bucket> buckets;
        private final AdvancedCacheWriter.PurgeListener purgeListener;
        private final StreamingMarshaller marshaller;
        private final Connection conn;
        private final Collection<Bucket> emptyBuckets;

        private BucketPurger(Collection<Bucket> buckets, AdvancedCacheWriter.PurgeListener purgeListener, StreamingMarshaller marshaller, Connection conn, Collection<Bucket> emptyBuckets) {
            this.buckets = buckets;
            this.purgeListener = purgeListener;
            this.marshaller = marshaller;
            this.conn = conn;
            this.emptyBuckets = emptyBuckets;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            PreparedStatement ps = null;
            try {
                String sql = JdbcBinaryStore.this.tableManipulation.getUpdateRowSql();
                ps = this.conn.prepareStatement(sql);
                Iterator<Bucket> it = this.buckets.iterator();
                while (it.hasNext()) {
                    Bucket bucket = it.next();
                    for (Object key : bucket.removeExpiredEntries(JdbcBinaryStore.this.ctx.getTimeService())) {
                        if (this.purgeListener == null) continue;
                        this.purgeListener.entryPurged(key);
                    }
                    if (!bucket.isEmpty()) {
                        ByteBuffer byteBuffer = JdbcUtil.marshall(this.marshaller, bucket);
                        ps.setBinaryStream(1, (InputStream)new ByteArrayInputStream(byteBuffer.getBuf(), byteBuffer.getOffset(), byteBuffer.getLength()), byteBuffer.getLength());
                        ps.setLong(2, bucket.timestampOfFirstEntryToExpire());
                        ps.setString(3, bucket.getBucketIdAsString());
                        ps.addBatch();
                        continue;
                    }
                    it.remove();
                    this.emptyBuckets.add(bucket);
                }
                ps.executeBatch();
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(ps);
                JdbcBinaryStore.this.releaseLocks(this.buckets);
                throw throwable;
            }
            JdbcUtil.safeClose(ps);
            JdbcBinaryStore.this.releaseLocks(this.buckets);
            return null;
        }
    }
}

