/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import java.lang.reflect.Constructor;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationUtils;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.JdbcStoreConfigurationChildBuilder;
import org.infinispan.persistence.jdbc.configuration.ManagedConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.PooledConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.SimpleConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.logging.Log;

public abstract class AbstractJdbcStoreConfigurationBuilder<T extends AbstractJdbcStoreConfiguration, S extends AbstractJdbcStoreConfigurationBuilder<T, S>>
extends AbstractStoreConfigurationBuilder<T, S>
implements JdbcStoreConfigurationChildBuilder<S> {
    private static final Log log = (Log)LogFactory.getLog(AbstractJdbcStoreConfigurationBuilder.class, Log.class);
    protected ConnectionFactoryConfigurationBuilder<ConnectionFactoryConfiguration> connectionFactory;
    protected boolean manageConnectionFactory = true;

    public AbstractJdbcStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder);
    }

    @Override
    public PooledConnectionFactoryConfigurationBuilder<S> connectionPool() {
        return (PooledConnectionFactoryConfigurationBuilder)((Object)this.connectionFactory((ConnectionFactoryConfigurationBuilder)((Object)PooledConnectionFactoryConfigurationBuilder.class)));
    }

    @Override
    public ManagedConnectionFactoryConfigurationBuilder<S> dataSource() {
        return (ManagedConnectionFactoryConfigurationBuilder)((Object)this.connectionFactory((ConnectionFactoryConfigurationBuilder)((Object)ManagedConnectionFactoryConfigurationBuilder.class)));
    }

    @Override
    public SimpleConnectionFactoryConfigurationBuilder<S> simpleConnection() {
        return (SimpleConnectionFactoryConfigurationBuilder)((Object)this.connectionFactory((ConnectionFactoryConfigurationBuilder)((Object)SimpleConnectionFactoryConfigurationBuilder.class)));
    }

    public <C extends ConnectionFactoryConfigurationBuilder<?>> C connectionFactory(Class<C> klass) {
        if (this.connectionFactory != null) {
            throw new IllegalStateException("A ConnectionFactory has already been configured for this store");
        }
        try {
            ConnectionFactoryConfigurationBuilder builder;
            Constructor<C> constructor = klass.getDeclaredConstructor(AbstractJdbcStoreConfigurationBuilder.class);
            this.connectionFactory = builder = (ConnectionFactoryConfigurationBuilder)constructor.newInstance(this);
            return (C)builder;
        }
        catch (Exception e) {
            throw new CacheConfigurationException("Could not instantiate loader configuration builder '" + klass.getName() + "'", (Throwable)e);
        }
    }

    public <C extends ConnectionFactoryConfigurationBuilder<?>> C connectionFactory(C builder) {
        if (this.connectionFactory != null) {
            throw new IllegalStateException("A ConnectionFactory has already been configured for this store");
        }
        this.connectionFactory = builder;
        return builder;
    }

    public S manageConnectionFactory(boolean manageConnectionFactory) {
        this.manageConnectionFactory = manageConnectionFactory;
        return (S)((AbstractJdbcStoreConfigurationBuilder)this.self());
    }

    public void validate() {
        super.validate();
        if (this.manageConnectionFactory && this.connectionFactory == null) {
            throw log.missingConnectionFactory();
        }
        if (!this.manageConnectionFactory && this.connectionFactory != null) {
            throw log.unmanagedConnectionFactory();
        }
    }

    public Builder<?> read(T template) {
        Class cfb = ConfigurationUtils.builderFor((Object)((AbstractJdbcStoreConfiguration)((Object)template)).connectionFactory());
        this.connectionFactory((ConnectionFactoryConfigurationBuilder)((Object)cfb));
        this.connectionFactory.read(((AbstractJdbcStoreConfiguration)((Object)template)).connectionFactory());
        this.manageConnectionFactory = ((AbstractJdbcStoreConfiguration)((Object)template)).manageConnectionFactory();
        return super.read(template);
    }
}

