/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic.sharded.collections;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.SortedMap;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicObjectFactory;
import org.infinispan.atomic.Utils;
import org.infinispan.atomic.sharded.collections.ShardedTreeMap;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="ShardedTreeMapTest")
public class ShardedTreeMapTest
extends MultipleCacheManagersTest {
    private static int NCALLS = 100;
    private static int NCACHES = 3;
    private static List<Cache> caches = new ArrayList<Cache>();

    @Test(enabled=true)
    public void basicUsageTest() throws Exception {
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)this.cacheManagers.iterator().next();
        Cache cache = cacheManager.getCache();
        AtomicObjectFactory factory = new AtomicObjectFactory(cache);
        SortedMap map = (SortedMap)factory.getInstanceOf(ShardedTreeMap.class, (Object)"test", false, null, false, new Object[]{3});
        for (int i = 0; i < NCALLS; ++i) {
            map.put(i, i);
            map.get(i);
        }
        factory.disposeInstanceOf(ShardedTreeMap.class, (Object)"test", true);
        map = (SortedMap)factory.getInstanceOf(ShardedTreeMap.class, (Object)"test", false, null, false, new Object[]{3});
        int a = map.size();
        this.log.debug((Object)a);
        AssertJUnit.assertEquals((int)NCALLS, (int)map.size());
        AssertJUnit.assertEquals((int)(NCALLS / 2), (int)map.subMap(0, NCALLS / 2).size());
        SortedMap map2 = (SortedMap)factory.getInstanceOf(ShardedTreeMap.class, (Object)"test2", false, null, false, new Object[]{3});
        HashMap<Integer, Integer> toAdd = new HashMap<Integer, Integer>();
        for (int i = 0; i < NCALLS; ++i) {
            toAdd.put(i, i);
            toAdd.get(i);
        }
        map2.putAll(toAdd);
        AssertJUnit.assertEquals((int)NCALLS, (int)map2.size());
        AssertJUnit.assertEquals(map2.lastKey(), (Object)(NCALLS - 1));
    }

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = AbstractCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        TransportFlags flags = new TransportFlags();
        this.createClusteredCaches(NCACHES, builder, flags);
    }

    protected void initAndTest() {
        for (Cache c : caches) {
            assert (c.isEmpty());
        }
        caches.iterator().next().put((Object)"k1", (Object)"value");
        Utils.assertOnAllCaches(caches, "k1", "value");
    }
}

