/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicObjectFactory;
import org.infinispan.atomic.Utils;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="AtomicObjectFactoryTest")
public class AtomicObjectFactoryTest
extends MultipleCacheManagersTest {
    private static int NCALLS = 1000;
    private static int NCACHES = 2;
    private static List<Cache> caches = new ArrayList<Cache>();
    private static Log log = LogFactory.getLog(AtomicObjectFactory.class);

    @Test(enabled=true)
    public void basicUsageTest() throws Exception {
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)this.cacheManagers.iterator().next();
        Cache cache = cacheManager.getCache();
        AtomicObjectFactory factory = new AtomicObjectFactory(cache);
        Set set = (Set)factory.getInstanceOf(HashSet.class, (Object)"set");
        set.add("smthing");
        AssertJUnit.assertTrue((boolean)set.contains("smthing"));
        assert (set.size() == 1);
        factory.disposeInstanceOf(HashSet.class, (Object)"set", true);
        set = (Set)factory.getInstanceOf(HashSet.class, (Object)"set", false, null, false, new Object[0]);
        AssertJUnit.assertTrue((boolean)set.contains("smthing"));
        ArrayList list = (ArrayList)factory.getInstanceOf(ArrayList.class, (Object)"list", true);
        AssertJUnit.assertTrue((!list.contains("foo") ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!cache.containsKey((Object)"list") ? 1 : 0) != 0);
    }

    @Test(enabled=true)
    public void basicPerformanceTest() throws Exception {
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)this.cacheManagers.iterator().next();
        Cache cache = cacheManager.getCache();
        AtomicObjectFactory factory = new AtomicObjectFactory(cache);
        Map map = (Map)factory.getInstanceOf(HashMap.class, (Object)"map", true);
        for (int i = 0; i < NCALLS * 10; ++i) {
            map.containsKey("1");
        }
        long start = System.currentTimeMillis();
        for (int i = 0; i < NCALLS * 10; ++i) {
            map.containsKey("1");
        }
        log.debug((Object)(System.currentTimeMillis() - start));
    }

    @Test(enabled=true)
    public void distributedCacheTest() throws Exception {
        ExecutorService service = Executors.newCachedThreadPool();
        ArrayList<HashSet> sets = new ArrayList<HashSet>();
        ArrayList<AtomicObjectFactory> factories = new ArrayList<AtomicObjectFactory>();
        ArrayList<Future<Integer>> futures = new ArrayList<Future<Integer>>();
        for (EmbeddedCacheManager embeddedCacheManager : this.cacheManagers) {
            Cache cache = embeddedCacheManager.getCache();
            caches.add(cache);
            AtomicObjectFactory factory = new AtomicObjectFactory(cache);
            factories.add(factory);
            HashSet set = (HashSet)factory.getInstanceOf(HashSet.class, (Object)"aset", false, null, false, new Object[0]);
            set.add(-1);
            sets.add(set);
        }
        for (Set set : sets) {
            futures.add(service.submit(new ExerciseAtomicSetTask(set, NCALLS)));
        }
        Integer total = 0;
        for (Future future : futures) {
            total = total + (Integer)future.get();
        }
        AssertJUnit.assertEquals((String)("obtained = " + total + "; espected = " + NCALLS), (Object)NCALLS, (Object)total);
    }

    @Test(enabled=true)
    public void distributedPersistenceTest() throws Exception {
        Iterator it = this.cacheManagers.iterator();
        EmbeddedCacheManager manager1 = (EmbeddedCacheManager)it.next();
        EmbeddedCacheManager manager2 = (EmbeddedCacheManager)it.next();
        Cache cache1 = manager1.getCache();
        AtomicObjectFactory factory1 = new AtomicObjectFactory(cache1);
        HashSet set1 = (HashSet)factory1.getInstanceOf(HashSet.class, (Object)"persist");
        set1.add("smthing");
        factory1.disposeInstanceOf(HashSet.class, (Object)"persist", true);
        Cache cache2 = manager2.getCache();
        AtomicObjectFactory factory2 = new AtomicObjectFactory(cache2);
        HashSet set2 = (HashSet)factory2.getInstanceOf(HashSet.class, (Object)"persist", true, null, false, new Object[0]);
        AssertJUnit.assertTrue((boolean)set2.contains("smthing"));
    }

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = AbstractCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        TransportFlags flags = new TransportFlags();
        this.createClusteredCaches(NCACHES, builder, flags);
    }

    protected void initAndTest() {
        for (Cache c : caches) {
            assert (c.isEmpty());
        }
        caches.iterator().next().put((Object)"k1", (Object)"value");
        Utils.assertOnAllCaches(caches, "k1", "value");
    }

    private class ExerciseAtomicSetTask
    implements Callable<Integer> {
        private int ncalls;
        private Set set;

        public ExerciseAtomicSetTask(Set s, int n) {
            this.ncalls = n;
            this.set = s;
        }

        @Override
        public Integer call() throws Exception {
            int ret = 0;
            for (int i = 0; i < this.ncalls; ++i) {
                boolean r = this.set.add(i);
                if (!r) continue;
                ++ret;
            }
            return ret;
        }
    }
}

