/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.cloud;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.infinispan.Cache;
import org.infinispan.config.ConfigurationException;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.bucket.Bucket;
import org.infinispan.loaders.bucket.BucketBasedCacheStore;
import org.infinispan.loaders.cloud.CloudCacheStoreConfig;
import org.infinispan.loaders.modifications.Modification;
import org.infinispan.marshall.Marshaller;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jclouds.blobstore.AsyncBlobStore;
import org.jclouds.blobstore.BlobMap;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.BlobStoreContextFactory;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.enterprise.config.EnterpriseConfigurationModule;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;

public class CloudCacheStore
extends BucketBasedCacheStore {
    private static final Log log = LogFactory.getLog(CloudCacheStore.class);
    private final ThreadLocal<Set<Future<?>>> asyncCommandFutures = new ThreadLocal();
    private CloudCacheStoreConfig cfg;
    private String containerName;
    private BlobStoreContext ctx;
    private BlobStore blobStore;
    private AsyncBlobStore asyncBlobStore;
    private boolean pollFutures = false;

    public Class<? extends CacheStoreConfig> getConfigurationClass() {
        return CloudCacheStoreConfig.class;
    }

    private String getThisContainerName() {
        return this.cfg.getBucketPrefix() + "-" + this.cache.getName().toLowerCase().replace("_", "").replace(".", "");
    }

    protected boolean supportsMultiThreadedPurge() {
        return true;
    }

    public void init(CacheLoaderConfig cfg, Cache<?, ?> cache, Marshaller m) throws CacheLoaderException {
        this.cfg = (CloudCacheStoreConfig)cfg;
        this.init(cfg, cache, m, null, null, null);
    }

    public void init(CacheLoaderConfig cfg, Cache<?, ?> cache, Marshaller m, BlobStoreContext ctx, BlobStore blobStore, AsyncBlobStore asyncBlobStore) throws CacheLoaderException {
        super.init(cfg, cache, m);
        this.cfg = (CloudCacheStoreConfig)cfg;
        this.cache = cache;
        this.marshaller = m;
        this.ctx = ctx;
        this.blobStore = blobStore;
        this.asyncBlobStore = asyncBlobStore;
    }

    public void start() throws CacheLoaderException {
        super.start();
        if (this.cfg.getCloudService() == null) {
            throw new ConfigurationException("CloudService must be set!");
        }
        if (this.cfg.getIdentity() == null) {
            throw new ConfigurationException("Identity must be set");
        }
        if (this.cfg.getPassword() == null) {
            throw new ConfigurationException("Password must be set");
        }
        if (this.cfg.getBucketPrefix() == null) {
            throw new ConfigurationException("CloudBucket must be set");
        }
        this.containerName = this.getThisContainerName();
        try {
            this.ctx = (BlobStoreContext)new BlobStoreContextFactory().createContext(this.cfg.getCloudService(), this.cfg.getIdentity(), this.cfg.getPassword(), (Iterable)ImmutableSet.of((Object)new EnterpriseConfigurationModule(), (Object)new Log4JLoggingModule()), new Properties());
            this.blobStore = this.ctx.getBlobStore();
            this.asyncBlobStore = this.ctx.getAsyncBlobStore();
            if (!this.blobStore.containerExists(this.containerName)) {
                this.blobStore.createContainerInLocation("DEFAULT", this.containerName);
            }
            this.pollFutures = this.cfg.getAsyncStoreConfig().isEnabled() == false;
        }
        catch (IOException ioe) {
            throw new CacheLoaderException("Unable to create context", (Throwable)ioe);
        }
    }

    protected Set<InternalCacheEntry> loadAllLockSafe() throws CacheLoaderException {
        HashSet<InternalCacheEntry> result = new HashSet<InternalCacheEntry>();
        for (Map.Entry entry : this.ctx.createBlobMap(this.containerName).entrySet()) {
            Bucket bucket = this.readFromBlob((Blob)entry.getValue(), (String)entry.getKey());
            if (bucket.removeExpiredEntries()) {
                this.updateBucket(bucket);
            }
            result.addAll(bucket.getStoredEntries());
        }
        return result;
    }

    protected void fromStreamLockSafe(ObjectInput objectInput) throws CacheLoaderException {
        String source;
        try {
            source = (String)objectInput.readObject();
        }
        catch (Exception e) {
            throw this.convertToCacheLoaderException("Error while reading from stream", e);
        }
        if (this.containerName.equals(source)) {
            log.info((Object)"Attempt to load the same cloud bucket ({0}) ignored", new Object[]{source});
        }
    }

    protected void toStreamLockSafe(ObjectOutput objectOutput) throws CacheLoaderException {
        try {
            objectOutput.writeObject(this.containerName);
        }
        catch (Exception e) {
            throw this.convertToCacheLoaderException("Error while writing to stream", e);
        }
    }

    protected void clearLockSafe() {
        Set<Future<?>> futures = this.asyncCommandFutures.get();
        if (futures == null) {
            this.blobStore.clearContainer(this.containerName);
        } else {
            futures.add((Future<?>)this.asyncBlobStore.clearContainer(this.containerName));
        }
    }

    private CacheLoaderException convertToCacheLoaderException(String m, Throwable c) {
        if (c instanceof CacheLoaderException) {
            return (CacheLoaderException)c;
        }
        return new CacheLoaderException(m, c);
    }

    protected Bucket loadBucket(String hash) throws CacheLoaderException {
        try {
            return this.readFromBlob(this.blobStore.getBlob(this.containerName, hash), hash);
        }
        catch (KeyNotFoundException e) {
            return null;
        }
    }

    private void purge(BlobMap blobMap) throws CacheLoaderException {
        for (Map.Entry entry : blobMap.entrySet()) {
            Bucket bucket = this.readFromBlob((Blob)entry.getValue(), (String)entry.getKey());
            if (!bucket.removeExpiredEntries()) continue;
            this.updateBucket(bucket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purgeInternal() throws CacheLoaderException {
        if (!this.cfg.isLazyPurgingOnly()) {
            this.acquireGlobalLock(false);
            try {
                final BlobMap blobMap = this.ctx.createBlobMap(this.containerName);
                if (this.multiThreadedPurge) {
                    this.purgerService.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                CloudCacheStore.this.purge(blobMap);
                            }
                            catch (Exception e) {
                                log.warn((Object)"Problems purging", (Throwable)e);
                            }
                        }
                    });
                } else {
                    this.purge(blobMap);
                }
            }
            finally {
                this.releaseGlobalLock(false);
            }
        }
    }

    protected void insertBucket(Bucket bucket) throws CacheLoaderException {
        Blob blob = this.blobStore.newBlob(this.getBucketName(bucket));
        this.writeToBlob(blob, bucket);
        Set<Future<?>> futures = this.asyncCommandFutures.get();
        if (futures == null) {
            this.blobStore.putBlob(this.containerName, blob);
        } else {
            futures.add((Future<?>)this.asyncBlobStore.putBlob(this.containerName, blob));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyModifications(List<? extends Modification> modifications) throws CacheLoaderException {
        block8: {
            HashSet futures = new HashSet();
            this.asyncCommandFutures.set(futures);
            try {
                super.applyModifications(modifications);
                if (!this.pollFutures) break block8;
                CacheLoaderException exception = null;
                try {
                    for (Future<?> f : this.asyncCommandFutures.get()) {
                        f.get();
                    }
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException ee) {
                    exception = this.convertToCacheLoaderException("Caught exception in async process", ee.getCause());
                }
                if (exception != null) {
                    throw exception;
                }
            }
            finally {
                this.asyncCommandFutures.remove();
            }
        }
    }

    protected void updateBucket(Bucket bucket) throws CacheLoaderException {
        this.insertBucket(bucket);
    }

    private void writeToBlob(Blob blob, Bucket bucket) throws CacheLoaderException {
        try {
            blob.setPayload(this.marshaller.objectToByteBuffer((Object)bucket));
        }
        catch (IOException e) {
            throw new CacheLoaderException((Throwable)e);
        }
    }

    private Bucket readFromBlob(Blob blob, String bucketName) throws CacheLoaderException {
        if (blob == null) {
            return null;
        }
        try {
            Bucket bucket = (Bucket)this.marshaller.objectFromInputStream(blob.getContent());
            if (bucket != null) {
                bucket.setBucketName(bucketName);
            }
            return bucket;
        }
        catch (Exception e) {
            throw this.convertToCacheLoaderException("Unable to read blob", e);
        }
    }

    private String getBucketName(Bucket bucket) {
        log.warn((Object)"Bucket is {0}", new Object[]{bucket});
        String bucketName = bucket.getBucketName();
        if (bucketName.startsWith("-")) {
            bucketName = bucketName.replace("-", "A");
        }
        return bucketName;
    }
}

