/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.cloud;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.CacheImpl;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalEntryFactory;
import org.infinispan.io.UnclosableObjectInputStream;
import org.infinispan.io.UnclosableObjectOutputStream;
import org.infinispan.loaders.BaseCacheStoreTest;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.cloud.CloudCacheStore;
import org.infinispan.loaders.cloud.CloudCacheStoreConfig;
import org.infinispan.marshall.StreamingMarshaller;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="loaders.cloud.CloudCacheStoreTest")
public class CloudCacheStoreTest
extends BaseCacheStoreTest {
    private static final String csBucket = "Bucket1";
    private static final String cs2Bucket = "Bucket2";
    protected CacheStore cs2;

    private CacheStore buildCloudCacheStoreWithStubCloudService(String bucketName) throws CacheLoaderException {
        CloudCacheStore cs = new CloudCacheStore();
        CloudCacheStoreConfig cfg = new CloudCacheStoreConfig();
        cfg.setBucketPrefix(bucketName);
        cfg.setCloudService("transient");
        cfg.setIdentity("unit-test-stub");
        cfg.setPassword("unit-test-stub");
        cfg.setProxyHost("unit-test-stub");
        cfg.setProxyPort("unit-test-stub");
        cfg.setCompress(false);
        cfg.setPurgeSynchronously(Boolean.valueOf(true));
        cs.init((CacheLoaderConfig)cfg, (Cache)new CacheImpl("aName"), this.getMarshaller());
        return cs;
    }

    protected CacheStore createCacheStore() throws Exception {
        CacheStore store = this.buildCloudCacheStoreWithStubCloudService(csBucket);
        store.start();
        return store;
    }

    protected CacheStore createAnotherCacheStore() throws Exception {
        CacheStore store = this.buildCloudCacheStoreWithStubCloudService(cs2Bucket);
        store.start();
        return store;
    }

    @BeforeMethod
    public void setUp() throws Exception {
        super.setUp();
        this.cs.clear();
        Set entries = this.cs.loadAll();
        assert (entries.isEmpty());
        this.cs2 = this.createAnotherCacheStore();
        this.cs2.clear();
        entries = this.cs2.loadAll();
        assert (entries.isEmpty());
    }

    @AfterMethod
    public void tearDown() throws CacheLoaderException {
        for (CacheStore cacheStore : Arrays.asList(this.cs, this.cs2)) {
            if (cacheStore == null) continue;
            cacheStore.clear();
            cacheStore.stop();
        }
        this.cs = null;
        this.cs2 = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=false, description="Disabled until JClouds gains a proper streaming API")
    public void testStreamingAPI() throws CacheLoaderException, IOException {
        this.cs.store(InternalEntryFactory.create((Object)"k1", (Object)"v1", (long)-1L, (long)-1L));
        this.cs.store(InternalEntryFactory.create((Object)"k2", (Object)"v2", (long)-1L, (long)-1L));
        this.cs.store(InternalEntryFactory.create((Object)"k3", (Object)"v3", (long)-1L, (long)-1L));
        StreamingMarshaller marshaller = this.getMarshaller();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutput oo = marshaller.startObjectOutput((OutputStream)out, false);
        try {
            this.cs.toStream((ObjectOutput)new UnclosableObjectOutputStream(oo));
        }
        finally {
            marshaller.finishObjectOutput(oo);
            out.close();
        }
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ObjectInput oi = marshaller.startObjectInput((InputStream)in, false);
        try {
            this.cs2.fromStream((ObjectInput)new UnclosableObjectInputStream(oi));
        }
        finally {
            marshaller.finishObjectInput(oi);
            in.close();
        }
        Set set = this.cs2.loadAll();
        Assert.assertEquals((int)set.size(), (int)3);
        HashSet<String> expected = new HashSet<String>();
        expected.add("k1");
        expected.add("k2");
        expected.add("k3");
        for (InternalCacheEntry se : set) {
            assert (expected.remove(se.getKey()));
        }
        assert (expected.isEmpty());
    }

    public void testNegativeHashCodes() throws CacheLoaderException {
        ObjectWithNegativeHashcode objectWithNegativeHashcode = new ObjectWithNegativeHashcode();
        this.cs.store(InternalEntryFactory.create((Object)objectWithNegativeHashcode, (Object)"hello", (long)-1L, (long)-1L));
        InternalCacheEntry ice = this.cs.load((Object)objectWithNegativeHashcode);
        assert (ice.getKey().equals(objectWithNegativeHashcode));
        assert (ice.getValue().equals("hello"));
    }

    @Test(enabled=false, description="Disabled until we can build the blobstore stub to retain state somewhere.")
    public void testStopStartDoesNotNukeValues() throws InterruptedException, CacheLoaderException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=false, description="Disabled until JClouds gains a proper streaming API")
    public void testStreamingAPIReusingStreams() throws CacheLoaderException, IOException {
        this.cs.store(InternalEntryFactory.create((Object)"k1", (Object)"v1", (long)-1L, (long)-1L));
        this.cs.store(InternalEntryFactory.create((Object)"k2", (Object)"v2", (long)-1L, (long)-1L));
        this.cs.store(InternalEntryFactory.create((Object)"k3", (Object)"v3", (long)-1L, (long)-1L));
        StreamingMarshaller marshaller = this.getMarshaller();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] dummyStartBytes = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] dummyEndBytes = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        ObjectOutput oo = marshaller.startObjectOutput((OutputStream)out, false);
        try {
            oo.write(dummyStartBytes);
            this.cs.toStream((ObjectOutput)new UnclosableObjectOutputStream(oo));
            oo.flush();
            oo.write(dummyEndBytes);
        }
        finally {
            marshaller.finishObjectOutput(oo);
            out.close();
        }
        byte[] dummy = new byte[8];
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ObjectInput oi = marshaller.startObjectInput((InputStream)in, false);
        try {
            byte i;
            int bytesRead = oi.read(dummy, 0, 8);
            assert (bytesRead == 8);
            for (i = 1; i < 9; ++i) {
                assert (dummy[i - 1] == i) : "Start byte stream corrupted!";
            }
            this.cs2.fromStream((ObjectInput)new UnclosableObjectInputStream(oi));
            bytesRead = oi.read(dummy, 0, 8);
            assert (bytesRead == 8);
            for (i = 8; i > 0; --i) {
                assert (dummy[8 - i] == i) : "Start byte stream corrupted!";
            }
        }
        finally {
            marshaller.finishObjectInput(oi);
            in.close();
        }
        Set set = this.cs2.loadAll();
        Assert.assertEquals((int)set.size(), (int)3);
        HashSet<String> expected = new HashSet<String>();
        expected.add("k1");
        expected.add("k2");
        expected.add("k3");
        for (InternalCacheEntry se : set) {
            assert (expected.remove(se.getKey()));
        }
        assert (expected.isEmpty());
    }

    private static class ObjectWithNegativeHashcode
    implements Serializable {
        String s = "hello";
        private static final long serialVersionUID = 5010691348616186237L;

        private ObjectWithNegativeHashcode() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObjectWithNegativeHashcode blah = (ObjectWithNegativeHashcode)o;
            return !(this.s == null ? blah.s != null : !this.s.equals(blah.s));
        }

        public int hashCode() {
            return -700;
        }
    }
}

