/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.cloud.configuration;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    BUCKET_PREFIX("bucketPrefix"),
    CLOUD_SERVICE("cloudService"),
    CLOUD_SERVICE_LOCATION("cloudServiceLocation"),
    COMPRESS("compress"),
    IDENTITY("identity"),
    LAZY_PURGING_ONLY("lazyPurgingOnly"),
    MAX_CONNECTIONS("maxConnections"),
    PASSWORD("password"),
    PROXY_HOST("proxyHost"),
    PROXY_PORT("proxyPort"),
    REQUEST_TIMEOUT("requestTimeout"),
    SECURE("secure");

    private static final Map<String, Attribute> attributes;
    private final String name;

    public static Attribute forName(String localName) {
        Attribute attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>(64);
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

