/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.cloud.configuration;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.infinispan.configuration.cache.CacheLoaderConfiguration;
import org.infinispan.loaders.cloud.configuration.CloudCacheStoreConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="loaders.cloud.configuration.XmlFileParsingTest")
public class XmlFileParsingTest
extends AbstractInfinispanTest {
    private EmbeddedCacheManager cacheManager;

    @AfterMethod
    public void cleanup() {
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }

    public void testRemoteCacheStore() throws Exception {
        String config = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:5.3 http://www.infinispan.org/schemas/infinispan-config-5.3.xsd\"\n      xmlns=\"urn:infinispan:config:5.3\">   <default>\n     <loaders>\n       <cloudStore xmlns=\"urn:infinispan:config:cloud:5.3\" cloudService=\"transient\" identity=\"me\" password=\"s3cr3t\" secure=\"true\" proxyHost=\"my-proxy\" proxyPort=\"8080\" fetchPersistentState=\"true\">\n         <async enabled=\"true\" />\n       </cloudStore>\n     </loaders>\n   </default>\n</infinispan>";
        CloudCacheStoreConfiguration store = (CloudCacheStoreConfiguration)this.buildCacheManagerWithCacheStore(config);
        assert (store.cloudService().equals("transient"));
        assert (store.identity().equals("me"));
        assert (store.password().equals("s3cr3t"));
        assert (store.proxyHost().equals("my-proxy"));
        assert (store.proxyPort() == 8080);
        assert (store.secure());
        assert (store.fetchPersistentState());
        assert (store.async().enabled());
    }

    private CacheLoaderConfiguration buildCacheManagerWithCacheStore(String config) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());
        this.cacheManager = TestCacheManagerFactory.fromStream((InputStream)is);
        assert (this.cacheManager.getDefaultCacheConfiguration().loaders().cacheLoaders().size() == 1);
        return (CacheLoaderConfiguration)this.cacheManager.getDefaultCacheConfiguration().loaders().cacheLoaders().get(0);
    }
}

