/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.cloud;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.infinispan.Cache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderMetadata;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.bucket.Bucket;
import org.infinispan.loaders.bucket.BucketBasedCacheStore;
import org.infinispan.loaders.cloud.CloudCacheStoreConfig;
import org.infinispan.loaders.cloud.logging.Log;
import org.infinispan.loaders.modifications.Modification;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.util.stream.Streams;
import org.jclouds.blobstore.AsyncBlobStore;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.BlobStoreContextFactory;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.domain.Location;
import org.jclouds.enterprise.config.EnterpriseConfigurationModule;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;

@CacheLoaderMetadata(configurationClass=CloudCacheStoreConfig.class)
public class CloudCacheStore
extends BucketBasedCacheStore {
    static final Log log = (Log)LogFactory.getLog(CloudCacheStore.class, Log.class);
    final ThreadLocal<List<Future<?>>> asyncCommandFutures = new ThreadLocal();
    CloudCacheStoreConfig cfg;
    String containerName;
    BlobStoreContext ctx;
    BlobStore blobStore;
    AsyncBlobStore asyncBlobStore;
    boolean pollFutures = false;
    boolean constructInternalBlobstores = true;
    protected static final String EARLIEST_EXPIRY_TIME = "metadata_eet";
    private MessageDigest md5;

    public CloudCacheStore() {
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ignore) {
            this.md5 = null;
        }
    }

    public Class<? extends CacheStoreConfig> getConfigurationClass() {
        return CloudCacheStoreConfig.class;
    }

    private String getThisContainerName() {
        return this.cfg.getBucketPrefix() + "-" + this.cache.getName().toLowerCase().replace("_", "").replace(".", "");
    }

    protected boolean supportsMultiThreadedPurge() {
        return true;
    }

    public void init(CacheLoaderConfig cfg, Cache<?, ?> cache, StreamingMarshaller m) throws CacheLoaderException {
        this.cfg = (CloudCacheStoreConfig)cfg;
        this.init(cfg, cache, m, null, null, null, true);
    }

    public void init(CacheLoaderConfig cfg, Cache<?, ?> cache, StreamingMarshaller m, BlobStoreContext ctx, BlobStore blobStore, AsyncBlobStore asyncBlobStore, boolean constructInternalBlobstores) throws CacheLoaderException {
        super.init(cfg, cache, m);
        this.cfg = (CloudCacheStoreConfig)cfg;
        this.marshaller = m;
        this.ctx = ctx;
        this.blobStore = blobStore;
        this.asyncBlobStore = asyncBlobStore;
        this.constructInternalBlobstores = constructInternalBlobstores;
    }

    public void start() throws CacheLoaderException {
        super.start();
        if (this.constructInternalBlobstores) {
            if (this.cfg.getCloudService() == null) {
                throw new CacheConfigurationException("CloudService must be set!");
            }
            if (this.cfg.getIdentity() == null) {
                throw new CacheConfigurationException("Identity must be set");
            }
            if (this.cfg.getPassword() == null) {
                throw new CacheConfigurationException("Password must be set");
            }
        }
        if (this.cfg.getBucketPrefix() == null) {
            throw new CacheConfigurationException("CloudBucket must be set");
        }
        this.containerName = this.getThisContainerName();
        try {
            if (this.constructInternalBlobstores) {
                this.ctx = new BlobStoreContextFactory().createContext(this.cfg.getCloudService(), this.cfg.getIdentity(), this.cfg.getPassword(), (Iterable)ImmutableSet.of((Object)new EnterpriseConfigurationModule(), (Object)new Log4JLoggingModule()), new Properties());
                this.blobStore = this.ctx.getBlobStore();
                this.asyncBlobStore = this.ctx.getAsyncBlobStore();
            }
            if (!this.blobStore.containerExists(this.containerName)) {
                String loc;
                ImmutableMap idToLocation;
                Location chosenLoc = null;
                if (this.cfg.getCloudServiceLocation() != null && this.cfg.getCloudServiceLocation().trim().length() > 0 && (chosenLoc = (Location)(idToLocation = Maps.uniqueIndex((Iterable)this.blobStore.listAssignableLocations(), (Function)new Function<Location, String>(){

                    public String apply(Location input) {
                        return input.getId();
                    }
                })).get(loc = this.cfg.getCloudServiceLocation().trim().toLowerCase())) == null) {
                    log.unableToConfigureCloudService(loc, this.cfg.getCloudService(), idToLocation.keySet());
                }
                this.blobStore.createContainerInLocation(chosenLoc, this.containerName);
            }
            this.pollFutures = this.cfg.getAsyncStoreConfig().isEnabled() == false;
        }
        catch (RuntimeException ioe) {
            throw new CacheLoaderException("Unable to create context", (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loopOverBuckets(BucketBasedCacheStore.BucketHandler handler) throws CacheLoaderException {
        for (Map.Entry entry : this.ctx.createBlobMap(this.containerName).entrySet()) {
            Bucket bucket = this.readFromBlob((Blob)entry.getValue(), (String)entry.getKey());
            if (bucket != null) {
                if (bucket.removeExpiredEntries()) {
                    this.upgradeLock(bucket.getBucketId());
                    try {
                        this.updateBucket(bucket);
                    }
                    finally {
                        this.downgradeLock(bucket.getBucketId());
                    }
                }
                if (!handler.handle(bucket)) continue;
                break;
            }
            throw new CacheLoaderException("Blob not found: " + (String)entry.getKey());
        }
    }

    protected void fromStreamLockSafe(ObjectInput objectInput) throws CacheLoaderException {
        String source;
        try {
            source = (String)objectInput.readObject();
        }
        catch (Exception e) {
            throw this.convertToCacheLoaderException("Error while reading from stream", e);
        }
        if (this.containerName.equals(source)) {
            log.attemptToLoadSameBucketIgnored(source);
        }
    }

    protected void toStreamLockSafe(ObjectOutput objectOutput) throws CacheLoaderException {
        try {
            objectOutput.writeObject(this.containerName);
        }
        catch (Exception e) {
            throw this.convertToCacheLoaderException("Error while writing to stream", e);
        }
    }

    protected void clearLockSafe() {
        List<Future<?>> futures = this.asyncCommandFutures.get();
        if (futures == null) {
            this.blobStore.clearContainer(this.containerName);
        } else {
            futures.add((Future<?>)this.asyncBlobStore.clearContainer(this.containerName));
        }
    }

    private CacheLoaderException convertToCacheLoaderException(String m, Throwable c) {
        if (c instanceof CacheLoaderException) {
            return (CacheLoaderException)c;
        }
        return new CacheLoaderException(m, c);
    }

    protected Bucket loadBucket(Integer hash) throws CacheLoaderException {
        if (hash == null) {
            throw new NullPointerException("hash");
        }
        String bucketName = hash.toString();
        return this.readFromBlob(this.blobStore.getBlob(this.containerName, this.encodeBucketName(bucketName)), bucketName);
    }

    void purge() {
        long currentTime = this.timeService.wallClockTime();
        PageSet ps = this.blobStore.list(this.containerName);
        for (StorageMetadata sm : ps) {
            long lastExpirableEntry = this.readLastExpirableEntryFromMetadata(sm.getUserMetadata());
            if (lastExpirableEntry >= currentTime) continue;
            this.scanBlobForExpiredEntries(sm.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanBlobForExpiredEntries(String blobName) {
        block6: {
            Blob blob = this.blobStore.getBlob(this.containerName, blobName);
            try {
                Bucket bucket = this.readFromBlob(blob, blobName);
                if (bucket != null) {
                    if (!bucket.removeExpiredEntries()) break block6;
                    this.upgradeLock(bucket.getBucketId());
                    try {
                        this.updateBucket(bucket);
                        break block6;
                    }
                    finally {
                        this.downgradeLock(bucket.getBucketId());
                    }
                }
                throw new CacheLoaderException("Blob not found: " + blobName);
            }
            catch (CacheLoaderException e) {
                log.unableToReadBlob(blobName, e);
            }
        }
    }

    private long readLastExpirableEntryFromMetadata(Map<String, String> metadata) {
        String eet = metadata.get(EARLIEST_EXPIRY_TIME);
        long eetLong = -1L;
        if (eet != null) {
            eetLong = Long.parseLong(eet);
        }
        return eetLong;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purgeInternal() throws CacheLoaderException {
        if (!this.cfg.isLazyPurgingOnly()) {
            boolean success = this.acquireGlobalLock(false);
            try {
                if (this.multiThreadedPurge) {
                    this.purgerService.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                CloudCacheStore.this.purge();
                            }
                            catch (Exception e) {
                                log.problemsPurging(e);
                            }
                        }
                    });
                } else {
                    this.purge();
                }
            }
            finally {
                if (success) {
                    this.releaseGlobalLock(false);
                }
            }
        }
    }

    protected void updateBucket(Bucket bucket) throws CacheLoaderException {
        BlobBuilder builder = this.blobStore.blobBuilder(this.encodeBucketName(bucket.getBucketIdAsString()));
        Blob blob = builder.build();
        this.writeToBlob(blob, bucket);
        List<Future<?>> futures = this.asyncCommandFutures.get();
        if (futures == null) {
            this.blobStore.putBlob(this.containerName, blob);
        } else {
            futures.add((Future<?>)this.asyncBlobStore.putBlob(this.containerName, blob));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyModifications(List<? extends Modification> modifications) throws CacheLoaderException {
        block9: {
            List<Object> futures = new LinkedList();
            this.asyncCommandFutures.set(futures);
            try {
                super.applyModifications(modifications);
                if (!this.pollFutures) break block9;
                CacheLoaderException exception = null;
                try {
                    futures = this.asyncCommandFutures.get();
                    if (log.isTraceEnabled()) {
                        log.tracef("Futures, in order: %s", futures);
                    }
                    for (Future future : futures) {
                        Object o = future.get();
                        if (!log.isTraceEnabled()) continue;
                        log.tracef("Future %s returned %s", future, o);
                    }
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException ee) {
                    exception = this.convertToCacheLoaderException("Caught exception in async process", ee.getCause());
                }
                if (exception != null) {
                    throw exception;
                }
            }
            finally {
                this.asyncCommandFutures.remove();
            }
        }
    }

    private void writeToBlob(Blob blob, Bucket bucket) throws CacheLoaderException {
        long earliestExpiryTime = -1L;
        for (InternalCacheEntry e : bucket.getEntries().values()) {
            long t = e.getExpiryTime();
            if (t == -1L) continue;
            if (earliestExpiryTime == -1L) {
                earliestExpiryTime = t;
                continue;
            }
            earliestExpiryTime = Math.min(earliestExpiryTime, t);
        }
        try {
            byte[] payloadBuffer = this.marshaller.objectToByteBuffer((Object)bucket);
            if (this.cfg.isCompress()) {
                byte[] compress = this.compress(payloadBuffer, blob);
                blob.setPayload(compress);
            } else {
                blob.setPayload(payloadBuffer);
            }
            if (earliestExpiryTime > -1L) {
                Map<String, String> md = Collections.singletonMap(EARLIEST_EXPIRY_TIME, String.valueOf(earliestExpiryTime));
                blob.getMetadata().setUserMetadata(md);
            }
        }
        catch (IOException e) {
            throw new CacheLoaderException((Throwable)e);
        }
        catch (InterruptedException ie) {
            if (log.isTraceEnabled()) {
                log.trace("Interrupted while writing blob");
            }
            Thread.currentThread().interrupt();
        }
    }

    private Bucket readFromBlob(Blob blob, String bucketName) throws CacheLoaderException {
        if (blob == null) {
            return null;
        }
        try {
            InputStream content = blob.getPayload().getInput();
            Bucket bucket = this.cfg.isCompress() ? this.uncompress(blob, bucketName, content) : (Bucket)this.marshaller.objectFromInputStream(content);
            if (bucket != null) {
                bucket.setBucketId(bucketName);
            }
            return bucket;
        }
        catch (ClassNotFoundException e) {
            throw this.convertToCacheLoaderException("Unable to read blob", e);
        }
        catch (IOException e) {
            throw this.convertToCacheLoaderException("Class loading issue", e);
        }
    }

    private Bucket uncompress(Blob blob, String bucketName, InputStream content) throws IOException, CacheLoaderException, ClassNotFoundException {
        byte[] hash;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Streams.copy((InputStream)content, (OutputStream)bos);
        byte[] compressedByteArray = bos.toByteArray();
        ByteArrayInputStream bis = new ByteArrayInputStream(compressedByteArray);
        BZip2CompressorInputStream is = new BZip2CompressorInputStream((InputStream)bis);
        ByteArrayOutputStream bos2 = new ByteArrayOutputStream();
        Streams.copy((InputStream)is, (OutputStream)bos2);
        byte[] uncompressedByteArray = bos2.toByteArray();
        byte[] md5FromStoredBlob = blob.getMetadata().getContentMetadata().getContentMD5();
        if (md5FromStoredBlob != null && !Arrays.equals(hash = this.getMd5Digest(compressedByteArray), md5FromStoredBlob)) {
            throw new CacheLoaderException("MD5 hash failed when reading (transfer error) for entry " + bucketName);
        }
        is.close();
        bis.close();
        bos.close();
        bos2.close();
        Bucket bucket = (Bucket)this.marshaller.objectFromInputStream((InputStream)new ByteArrayInputStream(uncompressedByteArray));
        return bucket;
    }

    private byte[] compress(byte[] uncompressedByteArray, Blob blob) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayInputStream input = new ByteArrayInputStream(uncompressedByteArray);
        BZip2CompressorOutputStream output = new BZip2CompressorOutputStream((OutputStream)baos);
        Streams.copy((InputStream)input, (OutputStream)output);
        output.close();
        ((InputStream)input).close();
        byte[] compressedByteArray = baos.toByteArray();
        blob.getMetadata().getContentMetadata().setContentMD5(this.getMd5Digest(compressedByteArray));
        baos.close();
        return compressedByteArray;
    }

    private String encodeBucketName(String bucketId) {
        String name;
        String string = name = bucketId.startsWith("-") ? bucketId.replace('-', 'A') : bucketId;
        if (this.cfg.isCompress()) {
            return name + ".bz2";
        }
        return name;
    }

    private synchronized byte[] getMd5Digest(byte[] toDigest) {
        this.md5.reset();
        return this.md5.digest(toDigest);
    }
}

