/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.cloud.configuration;

import java.util.Properties;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.loaders.cloud.configuration.CloudCacheStoreConfiguration;

public class CloudCacheStoreConfigurationBuilder
extends AbstractStoreConfigurationBuilder<CloudCacheStoreConfiguration, CloudCacheStoreConfigurationBuilder> {
    private String bucketPrefix;
    private String cloudService;
    private String cloudServiceLocation;
    private boolean compress = true;
    private String identity;
    private boolean lazyPurgingOnly = false;
    private int maxConnections = 10000;
    private String password;
    private String proxyHost;
    private int proxyPort;
    private long requestTimeout = 10000L;
    private boolean secure = true;

    public CloudCacheStoreConfigurationBuilder(LoadersConfigurationBuilder builder) {
        super(builder);
    }

    public CloudCacheStoreConfigurationBuilder self() {
        return this;
    }

    public CloudCacheStoreConfigurationBuilder bucketPrefix(String bucketPrefix) {
        this.bucketPrefix = bucketPrefix;
        return this;
    }

    public CloudCacheStoreConfigurationBuilder cloudService(String cloudService) {
        this.cloudService = cloudService;
        return this;
    }

    public CloudCacheStoreConfigurationBuilder cloudServiceLocation(String cloudServiceLocation) {
        this.cloudServiceLocation = cloudServiceLocation;
        return this;
    }

    public CloudCacheStoreConfigurationBuilder compress(boolean compress) {
        this.compress = compress;
        return this;
    }

    public CloudCacheStoreConfigurationBuilder identity(String identity) {
        this.identity = identity;
        return this;
    }

    public CloudCacheStoreConfigurationBuilder lazyPurgingOnly(boolean lazyPurgingOnly) {
        this.lazyPurgingOnly = lazyPurgingOnly;
        return this;
    }

    public CloudCacheStoreConfigurationBuilder maxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public CloudCacheStoreConfigurationBuilder password(String password) {
        this.password = password;
        return this;
    }

    public CloudCacheStoreConfigurationBuilder proxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        return this;
    }

    public CloudCacheStoreConfigurationBuilder proxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    public CloudCacheStoreConfigurationBuilder requestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public CloudCacheStoreConfigurationBuilder secure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public CloudCacheStoreConfiguration create() {
        return new CloudCacheStoreConfiguration(this.identity, this.password, this.bucketPrefix, this.proxyHost, this.proxyPort, this.requestTimeout, this.lazyPurgingOnly, this.cloudService, this.cloudServiceLocation, this.maxConnections, this.secure, this.compress, this.purgeOnStartup, this.purgeSynchronously, this.purgerThreads, this.fetchPersistentState, this.ignoreModifications, TypedProperties.toTypedProperties((Properties)this.properties), this.async.create(), this.singletonStore.create());
    }

    public CloudCacheStoreConfigurationBuilder read(CloudCacheStoreConfiguration template) {
        this.bucketPrefix = template.bucketPrefix();
        this.cloudService = template.cloudService();
        this.cloudServiceLocation = template.cloudServiceLocation();
        this.compress = template.compress();
        this.identity = template.identity();
        this.lazyPurgingOnly = template.lazyPurgingOnly();
        this.maxConnections = template.maxConnections();
        this.password = template.password();
        this.proxyHost = template.proxyHost();
        this.proxyPort = template.proxyPort();
        this.requestTimeout = template.requestTimeout();
        this.secure = template.secure();
        this.fetchPersistentState = template.fetchPersistentState();
        this.ignoreModifications = template.ignoreModifications();
        this.properties = template.properties();
        this.purgeOnStartup = template.purgeOnStartup();
        this.purgeSynchronously = template.purgeSynchronously();
        this.async.read(template.async());
        this.singletonStore.read(template.singletonStore());
        return this;
    }
}

