/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.cloud.configuration;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.configuration.cache.CacheStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Parser52;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.loaders.cloud.configuration.Attribute;
import org.infinispan.loaders.cloud.configuration.CloudCacheStoreConfigurationBuilder;
import org.infinispan.loaders.cloud.configuration.Element;

@Namespace(uri="urn:infinispan:config:cloud:5.2", root="cloudStore")
public class CloudCacheStoreConfigurationParser52
implements ConfigurationParser {
    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case CLOUD_STORE: {
                this.parseCloudStore(reader, builder.loaders(), holder.getClassLoader());
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    private void parseCloudStore(XMLExtendedStreamReader reader, LoadersConfigurationBuilder loadersBuilder, ClassLoader classLoader) throws XMLStreamException {
        CloudCacheStoreConfigurationBuilder builder = new CloudCacheStoreConfigurationBuilder(loadersBuilder);
        this.parseCloudStoreAttributes(reader, builder);
        while (reader.hasNext() && reader.nextTag() != 2) {
            Parser52.parseCommonStoreChildren((XMLExtendedStreamReader)reader, (CacheStoreConfigurationBuilder)builder);
        }
        loadersBuilder.addStore((CacheStoreConfigurationBuilder)builder);
    }

    private void parseCloudStoreAttributes(XMLExtendedStreamReader reader, CloudCacheStoreConfigurationBuilder builder) throws XMLStreamException {
        block14: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case BUCKET_PREFIX: {
                    builder.bucketPrefix(value);
                    continue block14;
                }
                case CLOUD_SERVICE: {
                    builder.cloudService(value);
                    continue block14;
                }
                case CLOUD_SERVICE_LOCATION: {
                    builder.cloudServiceLocation(value);
                    continue block14;
                }
                case COMPRESS: {
                    builder.compress(Boolean.parseBoolean(value));
                    continue block14;
                }
                case IDENTITY: {
                    builder.identity(value);
                    continue block14;
                }
                case LAZY_PURGING_ONLY: {
                    builder.lazyPurgingOnly(Boolean.parseBoolean(value));
                    continue block14;
                }
                case MAX_CONNECTIONS: {
                    builder.maxConnections(Integer.parseInt(value));
                    continue block14;
                }
                case PASSWORD: {
                    builder.password(value);
                    continue block14;
                }
                case PROXY_HOST: {
                    builder.proxyHost(value);
                    continue block14;
                }
                case PROXY_PORT: {
                    builder.proxyPort(Integer.parseInt(value));
                    continue block14;
                }
                case REQUEST_TIMEOUT: {
                    builder.requestTimeout(Long.parseLong(value));
                    continue block14;
                }
                case SECURE: {
                    builder.secure(Boolean.parseBoolean(value));
                    continue block14;
                }
                default: {
                    Parser52.parseCommonStoreAttributes((XMLExtendedStreamReader)reader, (int)i, (CacheStoreConfigurationBuilder)builder);
                }
            }
        }
    }
}

