package org.infinispan.persistence.jdbc.common.logging;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import java.sql.SQLException;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.commons.CacheConfigurationException;
import java.sql.Connection;
import java.io.IOException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.jboss.logging.BasicLogger;
import org.infinispan.persistence.spi.PersistenceException;
import java.lang.Throwable;
import java.lang.Object;
import javax.naming.NamingException;
import java.util.Arrays;
import java.lang.ClassNotFoundException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2021-12-13T06:27:03-0500")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void errorMarshallingObject(final Throwable ioe, final Object obj) {
        super.log.logf(FQCN, ERROR, ioe, errorMarshallingObject$str(), obj);
    }
    private static final String errorMarshallingObject = "ISPN000065: Exception while marshalling object: %s";
    protected String errorMarshallingObject$str() {
        return errorMarshallingObject;
    }
    @Override
    public final void failedClearingJdbcCacheStore(final Exception e) {
        super.log.logf(FQCN, ERROR, e, failedClearingJdbcCacheStore$str());
    }
    private static final String failedClearingJdbcCacheStore = "ISPN008001: Failed clearing cache store";
    protected String failedClearingJdbcCacheStore$str() {
        return failedClearingJdbcCacheStore;
    }
    @Override
    public final void sqlFailureIntegratingState(final SQLException e) {
        super.log.logf(FQCN, ERROR, e, sqlFailureIntegratingState$str());
    }
    private static final String sqlFailureIntegratingState = "ISPN008003: SQL failure while integrating state into store";
    protected String sqlFailureIntegratingState$str() {
        return sqlFailureIntegratingState;
    }
    @Override
    public final void ioErrorUnmarshalling(final IOException e) {
        super.log.logf(FQCN, ERROR, e, ioErrorUnmarshalling$str());
    }
    private static final String ioErrorUnmarshalling = "ISPN008009: I/O error while unmarshalling from stream";
    protected String ioErrorUnmarshalling$str() {
        return ioErrorUnmarshalling;
    }
    @Override
    public final void unexpectedClassNotFoundException(final ClassNotFoundException e) {
        super.log.logf(FQCN, ERROR, e, unexpectedClassNotFoundException$str());
    }
    private static final String unexpectedClassNotFoundException = "ISPN008010: *UNEXPECTED* ClassNotFoundException.";
    protected String unexpectedClassNotFoundException$str() {
        return unexpectedClassNotFoundException;
    }
    @Override
    public final void errorCreatingTable(final String sql, final SQLException e) {
        super.log.logf(FQCN, ERROR, e, errorCreatingTable$str(), sql);
    }
    private static final String errorCreatingTable = "ISPN008011: Error while creating table; used DDL statement: '%s'";
    protected String errorCreatingTable$str() {
        return errorCreatingTable;
    }
    @Override
    public final void connectionInJndiNotFound(final String dataSourceName) {
        super.log.logf(FQCN, ERROR, null, connectionInJndiNotFound$str(), dataSourceName);
    }
    private static final String connectionInJndiNotFound = "ISPN008015: Could not find a connection in jndi under the name '%s'";
    protected String connectionInJndiNotFound$str() {
        return connectionInJndiNotFound;
    }
    @Override
    public final void namingExceptionLookingUpConnection(final String dataSourceName, final NamingException e) {
        super.log.logf(FQCN, ERROR, e, namingExceptionLookingUpConnection$str(), dataSourceName);
    }
    private static final String namingExceptionLookingUpConnection = "ISPN008016: Could not lookup connection with datasource %s";
    protected String namingExceptionLookingUpConnection$str() {
        return namingExceptionLookingUpConnection;
    }
    @Override
    public final void failedClosingNamingCtx(final NamingException e) {
        super.log.logf(FQCN, WARN, e, failedClosingNamingCtx$str());
    }
    private static final String failedClosingNamingCtx = "ISPN008017: Failed to close naming context.";
    protected String failedClosingNamingCtx$str() {
        return failedClosingNamingCtx;
    }
    @Override
    public final void sqlFailureRetrievingConnection(final SQLException e) {
        super.log.logf(FQCN, ERROR, e, sqlFailureRetrievingConnection$str());
    }
    private static final String sqlFailureRetrievingConnection = "ISPN008018: Sql failure retrieving connection from datasource";
    protected String sqlFailureRetrievingConnection$str() {
        return sqlFailureRetrievingConnection;
    }
    @Override
    public final void sqlFailureClosingConnection(final Connection conn, final SQLException e) {
        super.log.logf(FQCN, ERROR, e, sqlFailureClosingConnection$str(), conn);
    }
    private static final String sqlFailureClosingConnection = "ISPN008019: Issues while closing connection %s";
    protected String sqlFailureClosingConnection$str() {
        return sqlFailureClosingConnection;
    }
    @Override
    public final void sqlFailureUnexpected(final SQLException e) {
        super.log.logf(FQCN, WARN, e, sqlFailureUnexpected$str());
    }
    private static final String sqlFailureUnexpected = "ISPN008022: Unexpected sql failure";
    protected String sqlFailureUnexpected$str() {
        return sqlFailureUnexpected;
    }
    @Override
    public final void failureClosingConnection(final SQLException e) {
        super.log.logf(FQCN, WARN, e, failureClosingConnection$str());
    }
    private static final String failureClosingConnection = "ISPN008023: Failure while closing the connection to the database";
    protected String failureClosingConnection$str() {
        return failureClosingConnection;
    }
    @Override
    public final void sqlFailureStoringKey(final Object lockingKey, final SQLException e) {
        super.log.logf(FQCN, ERROR, e, sqlFailureStoringKey$str(), lockingKey);
    }
    private static final String sqlFailureStoringKey = "ISPN008024: Error while storing string key to database; key: '%s'";
    protected String sqlFailureStoringKey$str() {
        return sqlFailureStoringKey;
    }
    @Override
    public final void sqlFailureRemovingKeys(final SQLException e) {
        super.log.logf(FQCN, ERROR, e, sqlFailureRemovingKeys$str());
    }
    private static final String sqlFailureRemovingKeys = "ISPN008025: Error while removing string keys from database";
    protected String sqlFailureRemovingKeys$str() {
        return sqlFailureRemovingKeys;
    }
    @Override
    public final void invalidKey2StringMapper(final String where, final String className) {
        super.log.logf(FQCN, ERROR, null, invalidKey2StringMapper$str(), where, className);
    }
    private static final String invalidKey2StringMapper = "ISPN008026: In order for JdbcStringBasedStore to support %s, the Key2StringMapper needs to implement TwoWayKey2StringMapper. You should either make %s implement TwoWayKey2StringMapper or disable the sql. See [https://jira.jboss.org/browse/ISPN-579] for more details.";
    protected String invalidKey2StringMapper$str() {
        return invalidKey2StringMapper;
    }
    @Override
    public final void sqlFailureReadingKey(final Object key, final Object lockingKey, final SQLException e) {
        super.log.logf(FQCN, ERROR, e, sqlFailureReadingKey$str(), key, lockingKey);
    }
    private static final String sqlFailureReadingKey = "ISPN008027: SQL error while fetching stored entry with key: %s, lockingKey: %s";
    protected String sqlFailureReadingKey$str() {
        return sqlFailureReadingKey;
    }
    private static final String tableManipulationAttributeNotSet = "ISPN008028: Attribute '%s' has not been set";
    protected String tableManipulationAttributeNotSet$str() {
        return tableManipulationAttributeNotSet;
    }
    @Override
    public final CacheConfigurationException tableManipulationAttributeNotSet(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), tableManipulationAttributeNotSet$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingConnectionFactory = "ISPN008029: A ConnectionFactory has not been specified for this store";
    protected String missingConnectionFactory$str() {
        return missingConnectionFactory;
    }
    @Override
    public final CacheConfigurationException missingConnectionFactory() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingConnectionFactory$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void sqlFailureTxCommit(final SQLException e) {
        super.log.logf(FQCN, ERROR, e, sqlFailureTxCommit$str());
    }
    private static final String sqlFailureTxCommit = "ISPN008031: Error committing JDBC transaction";
    protected String sqlFailureTxCommit$str() {
        return sqlFailureTxCommit;
    }
    @Override
    public final void sqlFailureTxRollback(final SQLException e) {
        super.log.logf(FQCN, ERROR, e, sqlFailureTxRollback$str());
    }
    private static final String sqlFailureTxRollback = "ISPN008032: Error during rollback of JDBC transaction";
    protected String sqlFailureTxRollback$str() {
        return sqlFailureTxRollback;
    }
    private static final String prepareTxFailure = "ISPN008033: Exception encountered when preparing JDBC store Tx";
    protected String prepareTxFailure$str() {
        return prepareTxFailure;
    }
    @Override
    public final PersistenceException prepareTxFailure(final Throwable e) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), prepareTxFailure$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void twoWayKey2StringMapperIsMissing(final String className) {
        super.log.logf(FQCN, WARN, null, twoWayKey2StringMapperIsMissing$str(), className);
    }
    private static final String twoWayKey2StringMapperIsMissing = "ISPN008036: Unable to notify the PurgeListener of expired cache entries as the configured key2StringMapper does not implement %s";
    protected String twoWayKey2StringMapperIsMissing$str() {
        return twoWayKey2StringMapperIsMissing;
    }
    private static final String sqlFailureWritingBatch = "ISPN008037: Error while writing entries in batch to the database:";
    protected String sqlFailureWritingBatch$str() {
        return sqlFailureWritingBatch;
    }
    @Override
    public final PersistenceException sqlFailureWritingBatch(final Throwable e) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), sqlFailureWritingBatch$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String sqlFailureDeletingBatch = "ISPN008038: Error whilst removing keys in batch from the database. Keys: %s";
    protected String sqlFailureDeletingBatch$str() {
        return sqlFailureDeletingBatch;
    }
    @Override
    public final PersistenceException sqlFailureDeletingBatch(final Iterable<Object> keys, final Exception e) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), sqlFailureDeletingBatch$str(), keys), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String existingStoreNoSegmentation = "ISPN008039: The existing store was created without segmentation enabled";
    protected String existingStoreNoSegmentation$str() {
        return existingStoreNoSegmentation;
    }
    @Override
    public final CacheConfigurationException existingStoreNoSegmentation() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), existingStoreNoSegmentation$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String existingStoreSegmentMismatch = "ISPN008040: The existing store was created with %d segments configured, but the cache is configured with %d";
    protected String existingStoreSegmentMismatch$str() {
        return existingStoreSegmentMismatch;
    }
    @Override
    public final CacheConfigurationException existingStoreSegmentMismatch(final int existing, final int cache) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), existingStoreSegmentMismatch$str(), existing, cache));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void sqlFailureMetaRetrieval(final SQLException e) {
        super.log.logf(FQCN, ERROR, e, sqlFailureMetaRetrieval$str());
    }
    private static final String sqlFailureMetaRetrieval = "ISPN008041: Error retrieving JDBC metadata";
    protected String sqlFailureMetaRetrieval$str() {
        return sqlFailureMetaRetrieval;
    }
    @Override
    public final void sqlFailureSize(final SQLException e) {
        super.log.logf(FQCN, ERROR, e, sqlFailureSize$str());
    }
    private static final String sqlFailureSize = "ISPN008042: SQL failure while retrieving size";
    protected String sqlFailureSize$str() {
        return sqlFailureSize;
    }
    private static final String primaryKeyMultipleColumnWithoutSchema = "ISPN008043: Primary key has multiple columns but no key message schema defined, which is required when there is more than one key column";
    protected String primaryKeyMultipleColumnWithoutSchema$str() {
        return primaryKeyMultipleColumnWithoutSchema;
    }
    @Override
    public final CacheConfigurationException primaryKeyMultipleColumnWithoutSchema() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), primaryKeyMultipleColumnWithoutSchema$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String valueMultipleColumnWithoutSchema = "ISPN008044: Multiple non key columns but no value message schema defined, which is required when there is more than one value column";
    protected String valueMultipleColumnWithoutSchema$str() {
        return valueMultipleColumnWithoutSchema;
    }
    @Override
    public final CacheConfigurationException valueMultipleColumnWithoutSchema() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), valueMultipleColumnWithoutSchema$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyNotInSchema = "ISPN008045: Primary key %s was not found in the key schema %s";
    protected String keyNotInSchema$str() {
        return keyNotInSchema;
    }
    @Override
    public final CacheConfigurationException keyNotInSchema(final String primaryKeyName, final String schemaName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), keyNotInSchema$str(), primaryKeyName, schemaName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String valueNotInSchema = "ISPN008046: Additional value columns %s found that were not part of the schema, make sure the columns returned match the value schema %s";
    protected String valueNotInSchema$str() {
        return valueNotInSchema;
    }
    @Override
    public final CacheConfigurationException valueNotInSchema(final java.util.List<String> columnNames, final String schemaName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), valueNotInSchema$str(), columnNames, schemaName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String schemaNotFound = "ISPN008047: Schema not found for : %s";
    protected String schemaNotFound$str() {
        return schemaNotFound;
    }
    @Override
    public final CacheConfigurationException schemaNotFound(final String schemaName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), schemaNotFound$str(), schemaName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyCannotEmbedWithEnum = "ISPN008048: Key cannot be embedded when the value schema %s is an enum";
    protected String keyCannotEmbedWithEnum$str() {
        return keyCannotEmbedWithEnum;
    }
    @Override
    public final CacheConfigurationException keyCannotEmbedWithEnum(final String schemaName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), keyCannotEmbedWithEnum$str(), schemaName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String repeatedFieldsNotSupported = "ISPN008049: Repeated fields are not supported, found %s in schema %s";
    protected String repeatedFieldsNotSupported$str() {
        return repeatedFieldsNotSupported;
    }
    @Override
    public final CacheConfigurationException repeatedFieldsNotSupported(final String fieldName, final String schemaName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), repeatedFieldsNotSupported$str(), fieldName, schemaName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateFieldInSchema = "ISPN008050: Duplicate name %s found for nested schema: %s";
    protected String duplicateFieldInSchema$str() {
        return duplicateFieldInSchema;
    }
    @Override
    public final CacheConfigurationException duplicateFieldInSchema(final String fieldName, final String schemaName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), duplicateFieldInSchema$str(), fieldName, schemaName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String requiredSchemaFieldNotPresent = "ISPN008051: Schema contained a field %s that is required but wasn't found in the query for schema %s";
    protected String requiredSchemaFieldNotPresent$str() {
        return requiredSchemaFieldNotPresent;
    }
    @Override
    public final CacheConfigurationException requiredSchemaFieldNotPresent(final String fieldName, final String schemaName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), requiredSchemaFieldNotPresent$str(), fieldName, schemaName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String primaryKeyPresentButNotEmbedded = "ISPN008052: Primary key %s was found in the value schema %s but embedded key was not true";
    protected String primaryKeyPresentButNotEmbedded$str() {
        return primaryKeyPresentButNotEmbedded;
    }
    @Override
    public final CacheConfigurationException primaryKeyPresentButNotEmbedded(final String fieldName, final String schemaName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), primaryKeyPresentButNotEmbedded$str(), fieldName, schemaName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String deleteAndSelectQueryMismatchArguments2 = "ISPN008053: Delete and select queries do not have matching arguments. Delete was %s and select was %s";
    protected String deleteAndSelectQueryMismatchArguments2$str() {
        return deleteAndSelectQueryMismatchArguments2;
    }
    @Override
    public final CacheConfigurationException deleteAndSelectQueryMismatchArguments(final java.util.List<String> deleteParams, final java.util.List<String> selectParams) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), deleteAndSelectQueryMismatchArguments2$str(), deleteParams, selectParams));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String deleteAndSelectQueryMismatchArguments3 = "ISPN008054: Named parameter %s in upsert statement [%s] is not available in columns from selectAll statement [%s]";
    protected String deleteAndSelectQueryMismatchArguments3$str() {
        return deleteAndSelectQueryMismatchArguments3;
    }
    @Override
    public final CacheConfigurationException deleteAndSelectQueryMismatchArguments(final String paramName, final String upsertStatement, final String selectStatement) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), deleteAndSelectQueryMismatchArguments3$str(), paramName, upsertStatement, selectStatement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String selectAllCannotHaveParameters = "ISPN008055: No parameters are allowed for select all statement %s";
    protected String selectAllCannotHaveParameters$str() {
        return selectAllCannotHaveParameters;
    }
    @Override
    public final CacheConfigurationException selectAllCannotHaveParameters(final String selectAllStatement) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), selectAllCannotHaveParameters$str(), selectAllStatement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String deleteAllCannotHaveParameters = "ISPN008056: No parameters are allowed for delete all statement %s";
    protected String deleteAllCannotHaveParameters$str() {
        return deleteAllCannotHaveParameters;
    }
    @Override
    public final CacheConfigurationException deleteAllCannotHaveParameters(final String selectAllStatement) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), deleteAllCannotHaveParameters$str(), selectAllStatement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String sizeCannotHaveParameters = "ISPN008057: No parameters are allowed for sizer statement %s";
    protected String sizeCannotHaveParameters$str() {
        return sizeCannotHaveParameters;
    }
    @Override
    public final CacheConfigurationException sizeCannotHaveParameters(final String selectAllStatement) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), sizeCannotHaveParameters$str(), selectAllStatement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyColumnsNotReturnedFromSelectAll = "ISPN008058: Not all key columns %s were returned from select all statement %s";
    protected String keyColumnsNotReturnedFromSelectAll$str() {
        return keyColumnsNotReturnedFromSelectAll;
    }
    @Override
    public final CacheConfigurationException keyColumnsNotReturnedFromSelectAll(final String keyColumns, final String selectAllStatement) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), keyColumnsNotReturnedFromSelectAll$str(), keyColumns, selectAllStatement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String namedParamNotReturnedFromSelect = "ISPN008059: Select parameter %s is not returned from select all statement %s, select statement is %s";
    protected String namedParamNotReturnedFromSelect$str() {
        return namedParamNotReturnedFromSelect;
    }
    @Override
    public final CacheConfigurationException namedParamNotReturnedFromSelect(final String paramName, final String selectAllStatement, final String selectStatement) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), namedParamNotReturnedFromSelect$str(), paramName, selectAllStatement, selectStatement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nonTerminatedNamedParamInSql = "ISPN008060: Non-terminated named parameter declaration at position %d in statement: %s";
    protected String nonTerminatedNamedParamInSql$str() {
        return nonTerminatedNamedParamInSql;
    }
    @Override
    public final CacheConfigurationException nonTerminatedNamedParamInSql(final int position, final String sqlStatement) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), nonTerminatedNamedParamInSql$str(), position, sqlStatement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidCharacterInSql = "ISPN008061: Invalid character %s at position %d in statement: %s";
    protected String invalidCharacterInSql$str() {
        return invalidCharacterInSql;
    }
    @Override
    public final CacheConfigurationException invalidCharacterInSql(final char character, final int position, final String sqlStatement) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidCharacterInSql$str(), character, position, sqlStatement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unnamedParametersNotAllowed = "ISPN008062: Unnamed parameters are not allowed, found one at %d in statement %s";
    protected String unnamedParametersNotAllowed$str() {
        return unnamedParametersNotAllowed;
    }
    @Override
    public final CacheConfigurationException unnamedParametersNotAllowed(final int position, final String sqlStatement) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unnamedParametersNotAllowed$str(), position, sqlStatement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tableNotInCorrectFormat = "ISPN008063: Provided table name %s is not in form of (<SCHEMA>.)<TABLE-NAME> where SCHEMA is optional";
    protected String tableNotInCorrectFormat$str() {
        return tableNotInCorrectFormat;
    }
    @Override
    public final CacheConfigurationException tableNotInCorrectFormat(final String tableName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), tableNotInCorrectFormat$str(), tableName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noPrimaryKeysFoundForTable = "ISPN008064: No primary keys found for table %s, check case sensitivity";
    protected String noPrimaryKeysFoundForTable$str() {
        return noPrimaryKeysFoundForTable;
    }
    @Override
    public final CacheConfigurationException noPrimaryKeysFoundForTable(final String tableName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), noPrimaryKeysFoundForTable$str(), tableName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noValueColumnForTable = "ISPN008065: No column found that wasn't a primary key for table: %s";
    protected String noValueColumnForTable$str() {
        return noValueColumnForTable;
    }
    @Override
    public final CacheConfigurationException noValueColumnForTable(final String tableName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), noValueColumnForTable$str(), tableName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToDetectDialect = "ISPN008066: Unable to detect database dialect from JDBC driver name or connection metadata.  Please provide this manually using the 'dialect' property in your configuration.  Supported database dialect strings are %s";
    protected String unableToDetectDialect$str() {
        return unableToDetectDialect;
    }
    @Override
    public final CacheConfigurationException unableToDetectDialect(final String supportedDialects) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unableToDetectDialect$str(), supportedDialects));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String requiredStatementsForQueryStoreLoader = "ISPN008067: The size, select and select all attributes must be set for a query store";
    protected String requiredStatementsForQueryStoreLoader$str() {
        return requiredStatementsForQueryStoreLoader;
    }
    @Override
    public final CacheConfigurationException requiredStatementsForQueryStoreLoader() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), requiredStatementsForQueryStoreLoader$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String requiredStatementsForQueryStoreWriter = "ISPN008068: The delete, delete all and upsert attributes must be set for a query store that allows writes";
    protected String requiredStatementsForQueryStoreWriter$str() {
        return requiredStatementsForQueryStoreWriter;
    }
    @Override
    public final CacheConfigurationException requiredStatementsForQueryStoreWriter() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), requiredStatementsForQueryStoreWriter$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyColumnsRequired = "ISPN008069: Key columns are required for QueryStore";
    protected String keyColumnsRequired$str() {
        return keyColumnsRequired;
    }
    @Override
    public final CacheConfigurationException keyColumnsRequired() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), keyColumnsRequired$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String messageNameRequiredIfEmbeddedKey = "ISPN008070: Message name must not be null if embedded key is true";
    protected String messageNameRequiredIfEmbeddedKey$str() {
        return messageNameRequiredIfEmbeddedKey;
    }
    @Override
    public final CacheConfigurationException messageNameRequiredIfEmbeddedKey() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), messageNameRequiredIfEmbeddedKey$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tableNameMissing = "ISPN008071: Table name must be non null";
    protected String tableNameMissing$str() {
        return tableNameMissing;
    }
    @Override
    public final CacheConfigurationException tableNameMissing() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), tableNameMissing$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
