/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.common;

import java.util.concurrent.atomic.AtomicInteger;
import org.h2.Driver;
import org.infinispan.persistence.jdbc.common.DatabaseType;
import org.infinispan.persistence.jdbc.common.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.common.configuration.ConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.common.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.common.impl.connectionfactory.PooledConnectionFactory;
import org.infinispan.persistence.jdbc.common.impl.connectionfactory.SimpleConnectionFactory;
import org.testng.Assert;

public class UnitTestDatabaseManager {
    private static AtomicInteger userIndex = new AtomicInteger(0);
    private static final String DB_TYPE = System.getProperty("infinispan.test.jdbc.db", "H2");
    private static final String H2_DRIVER = Driver.class.getName();
    private static final String NON_EXISTENT_DRIVER = "non.existent.Driver";
    private static final DatabaseType dt;

    public static ConnectionFactoryConfigurationBuilder<?> configureUniqueConnectionFactory(AbstractJdbcStoreConfigurationBuilder<?, ?> store) {
        switch (dt) {
            case H2: {
                return store.connectionPool().driverClass(Driver.class).connectionUrl(String.format("jdbc:h2:mem:%s;DB_CLOSE_DELAY=-1", UnitTestDatabaseManager.extractTestName() + userIndex.incrementAndGet())).username("sa");
            }
            case MYSQL: {
                return store.simpleConnection().driverClass(com.mysql.jdbc.Driver.class).connectionUrl("jdbc:mysql://localhost/infinispan?user=ispn&password=ispn").username("ispn").password("ispn");
            }
        }
        throw new RuntimeException("Cannot configure connection for database type " + dt);
    }

    public static ConnectionFactoryConfigurationBuilder<?> configureSimpleConnectionFactory(AbstractJdbcStoreConfigurationBuilder<?, ?> store) {
        return store.simpleConnection().driverClass(Driver.class).connectionUrl(String.format("jdbc:h2:mem:%s;DB_CLOSE_DELAY=-1", UnitTestDatabaseManager.extractTestName() + userIndex.incrementAndGet())).username("sa");
    }

    public static ConnectionFactoryConfigurationBuilder<?> configureBrokenConnectionFactory(AbstractJdbcStoreConfigurationBuilder<?, ?> storeBuilder) {
        return storeBuilder.connectionPool().driverClass(NON_EXISTENT_DRIVER);
    }

    private static String extractTestName() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        if (stack.length == 0) {
            return null;
        }
        for (int i = stack.length - 1; i > 0; --i) {
            StackTraceElement e = stack[i];
            String className = e.getClassName();
            if (className.indexOf("org.infinispan") == -1) continue;
            return className.replace('.', '_') + "_" + e.getMethodName();
        }
        return null;
    }

    public static void setDialect(AbstractJdbcStoreConfigurationBuilder builder) {
        builder.dialect(dt);
    }

    public static void verifyConnectionLeaks(ConnectionFactory connectionFactory) {
        if (connectionFactory instanceof PooledConnectionFactory) {
            PooledConnectionFactory pcf = (PooledConnectionFactory)connectionFactory;
            try {
                Thread.sleep(500L);
                Assert.assertEquals((long)pcf.getActiveConnections(), (long)0L);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (connectionFactory instanceof SimpleConnectionFactory) {
            SimpleConnectionFactory scf = (SimpleConnectionFactory)connectionFactory;
            Assert.assertEquals((int)scf.getConnectionCount(), (int)0);
        }
    }

    static {
        String driver = "";
        try {
            if (DB_TYPE.equalsIgnoreCase("mysql")) {
                driver = com.mysql.jdbc.Driver.class.getName();
                dt = DatabaseType.MYSQL;
            } else {
                driver = H2_DRIVER;
                dt = DatabaseType.H2;
            }
            try {
                Class.forName(driver);
            }
            catch (ClassNotFoundException e) {
                driver = H2_DRIVER;
                Class.forName(H2_DRIVER);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

