/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc;

import java.sql.Connection;
import java.util.HashSet;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.connectionfactory.PooledConnectionFactory;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.PooledConnectionFactoryTest")
public class PooledConnectionFactoryTest {
    private PooledConnectionFactory factory;
    private JdbcStringBasedStoreConfigurationBuilder storeBuilder;
    private ConnectionFactoryConfigurationBuilder<?> factoryBuilder;

    @BeforeMethod
    public void beforeMethod() {
        this.factory = new PooledConnectionFactory();
    }

    @AfterMethod
    public void destroyFactory() {
        this.factory.stop();
    }

    @Test
    public void testValuesNoOverrides() throws Exception {
        this.storeBuilder = (JdbcStringBasedStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class);
        this.factoryBuilder = this.storeBuilder.connectionPool().propertyFile("src/test/resources/configs/agroal.properties");
        ConnectionFactoryConfiguration factoryConfiguration = (ConnectionFactoryConfiguration)this.factoryBuilder.create();
        this.factory.start(factoryConfiguration, Thread.currentThread().getContextClassLoader());
        int hardcodedMaxPoolSize = this.factory.getMaxPoolSize();
        assert (hardcodedMaxPoolSize == 20);
        HashSet<Connection> connections = new HashSet<Connection>();
        for (int i = 0; i < hardcodedMaxPoolSize; ++i) {
            connections.add(this.factory.getConnection());
        }
        assert (connections.size() == hardcodedMaxPoolSize);
        assert (this.factory.getActiveConnections() == (long)hardcodedMaxPoolSize);
        for (Connection conn : connections) {
            conn.close();
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 2000L && this.factory.getActiveConnections() != 0L) {
        }
        assert (this.factory.getActiveConnections() == 0L);
    }

    @Test(expectedExceptions={PersistenceException.class})
    public void testNoDriverClassFound() {
        this.storeBuilder = (JdbcStringBasedStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class);
        this.factoryBuilder = UnitTestDatabaseManager.configureBrokenConnectionFactory(this.storeBuilder);
        ConnectionFactoryConfiguration factoryConfiguration = (ConnectionFactoryConfiguration)this.factoryBuilder.create();
        this.factory.start(factoryConfiguration, Thread.currentThread().getContextClassLoader());
    }
}

