/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.stringbased;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.persistence.jdbc.ManagedConnectionFactoryTest;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.connectionfactory.ManagedConnectionFactory;
import org.infinispan.persistence.jdbc.stringbased.JdbcStringBasedStore;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.stringbased.StringStoreWithManagedConnectionTest")
public class StringStoreWithManagedConnectionTest
extends ManagedConnectionFactoryTest {
    protected AdvancedLoadWriteStore createStore() throws Exception {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        JdbcStringBasedStoreConfigurationBuilder storeBuilder = (JdbcStringBasedStoreConfigurationBuilder)builder.persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class);
        storeBuilder.dataSource().jndiUrl(this.getDatasourceLocation());
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.table());
        JdbcStringBasedStore stringBasedCacheStore = new JdbcStringBasedStore();
        stringBasedCacheStore.init(this.createContext(builder.build()));
        return stringBasedCacheStore;
    }

    public void testLoadFromFile() throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.fromXml((String)"configs/managed/str-managed-connection-factory.xml"), true){

            public void call() {
                Cache first = this.cm.getCache("first");
                Cache second = this.cm.getCache("second");
                StoreConfiguration firstCacheLoaderConfig = (StoreConfiguration)first.getCacheConfiguration().persistence().stores().get(0);
                AssertJUnit.assertNotNull((Object)firstCacheLoaderConfig);
                AssertJUnit.assertTrue((boolean)(firstCacheLoaderConfig instanceof JdbcStringBasedStoreConfiguration));
                StoreConfiguration secondCacheLoaderConfig = (StoreConfiguration)second.getCacheConfiguration().persistence().stores().get(0);
                AssertJUnit.assertNotNull((Object)secondCacheLoaderConfig);
                AssertJUnit.assertTrue((boolean)(secondCacheLoaderConfig instanceof JdbcStringBasedStoreConfiguration));
                JdbcStringBasedStore loader = (JdbcStringBasedStore)TestingUtil.getFirstLoader((Cache)first);
                AssertJUnit.assertTrue((boolean)(loader.getConnectionFactory() instanceof ManagedConnectionFactory));
            }
        });
    }

    @Override
    public String getDatasourceLocation() {
        return "java:/StringStoreWithManagedConnectionTest/DS";
    }

    protected boolean storePurgesAllExpired() {
        return false;
    }
}

