/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.parsing.XmlConfigHelper;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.Element;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.ManagedConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.PooledConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfigurationBuilder;
import org.infinispan.persistence.keymappers.Key2StringMapper;

public class JdbcStringBasedStoreConfigurationBuilder
extends AbstractJdbcStoreConfigurationBuilder<JdbcStringBasedStoreConfiguration, JdbcStringBasedStoreConfigurationBuilder>
implements ConfigurationBuilderInfo {
    private StringTableManipulationConfigurationBuilder table = new StringTableManipulationConfigurationBuilder(this);

    public JdbcStringBasedStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder, JdbcStringBasedStoreConfiguration.attributeDefinitionSet());
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ConfigurationBuilderInfo getBuilderInfo(String name, String qualifier) {
        if (name.equals(Element.CONNECTION_POOL.getLocalName())) {
            return this.connectionPool();
        }
        if (name.equals(Element.DATA_SOURCE.getLocalName())) {
            return this.dataSource();
        }
        if (name.equals(Element.SIMPLE_CONNECTION.getLocalName())) {
            return this.simpleConnection();
        }
        if (name.equals(Element.STRING_KEYED_TABLE.getLocalName())) {
            return this.table;
        }
        return null;
    }

    public ElementDefinition getElementDefinition() {
        return JdbcStringBasedStoreConfiguration.ELEMENT_DEFINITION;
    }

    public Collection<ConfigurationBuilderInfo> getChildrenInfo() {
        return Collections.singletonList(this.table);
    }

    public JdbcStringBasedStoreConfigurationBuilder self() {
        return this;
    }

    public JdbcStringBasedStoreConfigurationBuilder key2StringMapper(String key2StringMapper) {
        this.attributes.attribute(JdbcStringBasedStoreConfiguration.KEY2STRING_MAPPER).set((Object)key2StringMapper);
        return this;
    }

    public JdbcStringBasedStoreConfigurationBuilder key2StringMapper(Class<? extends Key2StringMapper> klass) {
        this.key2StringMapper(klass.getName());
        return this;
    }

    public StringTableManipulationConfigurationBuilder table() {
        return this.table;
    }

    public JdbcStringBasedStoreConfigurationBuilder withProperties(Properties props) {
        Map unrecognized = XmlConfigHelper.setAttributes((AttributeSet)this.attributes, (Map)props, (boolean)false, (boolean)false);
        unrecognized = XmlConfigHelper.setAttributes((AttributeSet)this.table.attributes(), (Map)unrecognized, (boolean)false, (boolean)false);
        XmlConfigHelper.showUnrecognizedAttributes((Map)unrecognized);
        this.attributes.attribute(JdbcStringBasedStoreConfiguration.PROPERTIES).set((Object)TypedProperties.toTypedProperties((Properties)props));
        return this;
    }

    public JdbcStringBasedStoreConfiguration create() {
        return new JdbcStringBasedStoreConfiguration(this.attributes.protect(), this.async.create(), this.singletonStore.create(), this.connectionFactory != null ? (ConnectionFactoryConfiguration)this.connectionFactory.create() : null, this.table.create());
    }

    @Override
    public Builder<?> read(JdbcStringBasedStoreConfiguration template) {
        super.read(template);
        this.table.read(template.table());
        return this;
    }

    public String toString() {
        return "JdbcStringBasedStoreConfigurationBuilder [table=" + this.table + ", connectionFactory=" + this.connectionFactory + ", attributes=" + this.attributes + ", async=" + this.async + ", singletonStore=" + this.singletonStore + "]";
    }

    public class StringTableManipulationConfigurationBuilder
    extends TableManipulationConfigurationBuilder<JdbcStringBasedStoreConfigurationBuilder, StringTableManipulationConfigurationBuilder> {
        StringTableManipulationConfigurationBuilder(AbstractJdbcStoreConfigurationBuilder<?, JdbcStringBasedStoreConfigurationBuilder> builder) {
            super(builder);
        }

        public StringTableManipulationConfigurationBuilder self() {
            return this;
        }

        @Override
        public PooledConnectionFactoryConfigurationBuilder<JdbcStringBasedStoreConfigurationBuilder> connectionPool() {
            return JdbcStringBasedStoreConfigurationBuilder.this.connectionPool();
        }

        @Override
        public ManagedConnectionFactoryConfigurationBuilder<JdbcStringBasedStoreConfigurationBuilder> dataSource() {
            return JdbcStringBasedStoreConfigurationBuilder.this.dataSource();
        }
    }
}

