/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.infinispan.persistence.BaseStoreTest;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.impl.connectionfactory.SimpleConnectionFactory;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.infinispan.test.jndi.DummyContextFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.ManagedConnectionFactoryTest")
public abstract class ManagedConnectionFactoryTest
extends BaseStoreTest {
    private DummyDataSource ds;

    @BeforeClass
    public void bindDatasourceInJndi() throws Exception {
        System.setProperty("java.naming.factory.initial", DummyContextFactory.class.getName());
        this.ds = new DummyDataSource();
        this.ds.start();
        InitialContext ic = new InitialContext();
        ic.bind(this.getDatasourceLocation(), (Object)this.ds);
        assert (ic.lookup(this.getDatasourceLocation()) instanceof DummyDataSource);
    }

    public abstract String getDatasourceLocation();

    @AfterClass
    public void destroyDatasourceAndUnbind() throws NamingException {
        InitialContext ic = new InitialContext();
        ic.unbind(this.getDatasourceLocation());
        assert (ic.lookup(this.getDatasourceLocation()) == null);
        this.ds.stop();
    }

    public static class DummyDataSource
    implements DataSource {
        private SimpleConnectionFactory simpleFactory;

        public void start() throws PersistenceException {
            JdbcStringBasedStoreConfigurationBuilder storeBuilder = (JdbcStringBasedStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class);
            this.simpleFactory = new SimpleConnectionFactory();
            this.simpleFactory.start((ConnectionFactoryConfiguration)UnitTestDatabaseManager.configureSimpleConnectionFactory(storeBuilder).create(), Thread.currentThread().getContextClassLoader());
        }

        public void stop() {
            this.simpleFactory.stop();
        }

        @Override
        public Connection getConnection() throws SQLException {
            try {
                return this.simpleFactory.getConnection();
            }
            catch (PersistenceException e) {
                throw new SQLException(e);
            }
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            return this.getConnection();
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            throw new IllegalStateException("This should not be called!");
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            throw new IllegalStateException("This should not be called!");
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            throw new IllegalStateException("This should not be called!");
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            throw new IllegalStateException("This should not be called!");
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw new IllegalStateException("This should not be called!");
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            throw new IllegalStateException("This should not be called!");
        }

        @Override
        public Logger getParentLogger() {
            throw new IllegalStateException("This should not be called!");
        }
    }
}

