/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc;

import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import org.infinispan.persistence.jdbc.JdbcUtil;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.PooledConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.SimpleConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.impl.connectionfactory.PooledConnectionFactory;
import org.infinispan.persistence.jdbc.impl.connectionfactory.SimpleConnectionFactory;
import org.infinispan.persistence.jdbc.impl.table.TableManager;
import org.infinispan.persistence.jdbc.impl.table.TableManagerFactory;
import org.infinispan.persistence.jdbc.impl.table.TableName;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.TableManagerTest")
public class TableManagerTest {
    ConnectionFactory connectionFactory;
    Connection connection;
    TableManager tableManager;

    @BeforeClass
    public void createConnection() throws Exception {
        JdbcStringBasedStoreConfigurationBuilder storeBuilder = (JdbcStringBasedStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class);
        UnitTestDatabaseManager.setDialect((AbstractJdbcStoreConfigurationBuilder)storeBuilder);
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.table());
        ConnectionFactoryConfiguration factoryConfiguration = (ConnectionFactoryConfiguration)UnitTestDatabaseManager.configureUniqueConnectionFactory(storeBuilder).create();
        if (factoryConfiguration instanceof SimpleConnectionFactoryConfiguration) {
            SimpleConnectionFactoryConfiguration simpleConfiguration = (SimpleConnectionFactoryConfiguration)factoryConfiguration;
            this.connectionFactory = ConnectionFactory.getConnectionFactory(SimpleConnectionFactory.class);
            this.connectionFactory.start((ConnectionFactoryConfiguration)simpleConfiguration, this.connectionFactory.getClass().getClassLoader());
            this.connection = this.connectionFactory.getConnection();
        } else if (factoryConfiguration instanceof PooledConnectionFactoryConfiguration) {
            PooledConnectionFactoryConfiguration pooledConfiguration = (PooledConnectionFactoryConfiguration)factoryConfiguration;
            this.connectionFactory = ConnectionFactory.getConnectionFactory(PooledConnectionFactory.class);
            this.connectionFactory.start((ConnectionFactoryConfiguration)pooledConfiguration, this.connectionFactory.getClass().getClassLoader());
            this.connection = this.connectionFactory.getConnection();
        }
        this.tableManager = TableManagerFactory.getManager((ConnectionFactory)this.connectionFactory, (JdbcStringBasedStoreConfiguration)storeBuilder.create());
        this.tableManager.setCacheName("aName");
    }

    @AfterClass
    public void closeConnection() throws SQLException {
        this.connection.close();
    }

    public void testConnectionLeakGuessDialect() throws Exception {
        JdbcStringBasedStoreConfigurationBuilder storeBuilder = (JdbcStringBasedStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class);
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.table());
        PooledConnectionFactory connectionFactory = new PooledConnectionFactory();
        ConnectionFactoryConfiguration config = (ConnectionFactoryConfiguration)UnitTestDatabaseManager.configureUniqueConnectionFactory(storeBuilder).create();
        connectionFactory.start(config, Thread.currentThread().getContextClassLoader());
        TableManager tableManager = TableManagerFactory.getManager((ConnectionFactory)connectionFactory, (JdbcStringBasedStoreConfiguration)storeBuilder.create());
        tableManager.setCacheName("GuessDialect");
        tableManager.start();
        UnitTestDatabaseManager.verifyConnectionLeaks((ConnectionFactory)connectionFactory);
        tableManager.stop();
        connectionFactory.stop();
    }

    public void testCreateTable() throws Exception {
        assert (!TableManagerTest.existsTable(this.connection, this.tableManager.getTableName()));
        this.tableManager.createTable(this.connection);
        assert (TableManagerTest.existsTable(this.connection, this.tableManager.getTableName()));
    }

    @Test(dependsOnMethods={"testCreateTable"})
    public void testExists() throws PersistenceException {
        assert (this.tableManager.tableExists(this.connection));
        assert (!this.tableManager.tableExists(this.connection, new TableName("\"", "", "does_not_exist")));
    }

    public void testExistsWithSchema() throws PersistenceException {
    }

    @Test(dependsOnMethods={"testExists"})
    public void testDrop() throws Exception {
        assert (this.tableManager.tableExists(this.connection));
        byte[] data = new byte[64];
        new Random().nextBytes(data);
        PreparedStatement ps = null;
        try {
            ps = this.connection.prepareStatement("INSERT INTO " + this.tableManager.getTableName() + "(ID_COLUMN, DATA_COLUMN, TIMESTAMP_COLUMN) values(?, ?, ?)");
            ps.setString(1, System.currentTimeMillis() + "");
            ps.setBlob(2, new ByteArrayInputStream(data));
            ps.setLong(3, System.currentTimeMillis());
            assert (1 == ps.executeUpdate());
        }
        catch (Throwable throwable) {
            JdbcUtil.safeClose(ps);
            throw throwable;
        }
        JdbcUtil.safeClose((Statement)ps);
        this.tableManager.dropTable(this.connection);
        assert (!this.tableManager.tableExists(this.connection));
    }

    public void testTableQuoting() throws Exception {
        this.tableManager.setCacheName("my.cache");
        assert (!TableManagerTest.existsTable(this.connection, this.tableManager.getTableName()));
        this.tableManager.createTable(this.connection);
        assert (TableManagerTest.existsTable(this.connection, this.tableManager.getTableName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean existsTable(Connection connection, TableName tableName) throws Exception {
        boolean bl;
        Statement st = connection.createStatement();
        ResultSet rs = null;
        try {
            rs = st.executeQuery("select * from " + tableName);
            bl = true;
            JdbcUtil.safeClose((ResultSet)rs);
        }
        catch (SQLException e) {
            boolean bl2 = false;
            return bl2;
        }
        finally {
            JdbcUtil.safeClose(rs);
            JdbcUtil.safeClose((Statement)st);
        }
        JdbcUtil.safeClose((Statement)st);
        return bl;
    }
}

