/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.stores;

import java.util.function.Predicate;
import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.impl.table.TableName;
import org.infinispan.persistence.jdbc.stringbased.JdbcStringBasedStore;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.support.BatchModification;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.Exceptions;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.stores.TxStoreTest")
public class TxStoreTest
extends AbstractInfinispanTest {
    private static final String KEY1 = "Key 1";
    private static final String KEY2 = "Key 2";
    private static final String VAL1 = "Val 1";
    private static final String VAL2 = "Val 2";
    private EmbeddedCacheManager cacheManager;
    private Cache<String, String> cache;
    private JdbcStringBasedStore store;

    @BeforeMethod
    public void beforeClass() {
        ConfigurationBuilder cc = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)true);
        JdbcStringBasedStoreConfigurationBuilder storeBuilder = (JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)cc.persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class)).shared(true)).transactional(true);
        UnitTestDatabaseManager.configureUniqueConnectionFactory(storeBuilder);
        UnitTestDatabaseManager.setDialect((AbstractJdbcStoreConfigurationBuilder)storeBuilder);
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.table());
        this.cacheManager = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)new GlobalConfigurationBuilder().defaultCacheName("Test"), (ConfigurationBuilder)cc);
        this.cache = this.cacheManager.getCache("Test");
        this.store = (JdbcStringBasedStore)TestingUtil.getFirstTxWriter(this.cache);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws PersistenceException {
        if (this.store != null) {
            this.store.clear();
            this.assertRowCount(0);
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }

    @Test
    public void testTxCommit() throws Exception {
        this.cache.put((Object)KEY1, (Object)VAL1);
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache);
        tm.begin();
        this.cache.put((Object)KEY2, (Object)VAL1);
        String oldValue = (String)this.cache.put((Object)KEY1, (Object)VAL2);
        AssertJUnit.assertEquals((String)oldValue, (String)VAL1);
        tm.commit();
        String cacheVal = (String)this.cache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD).get((Object)KEY1);
        AssertJUnit.assertEquals((String)cacheVal, (String)VAL2);
        this.assertRowCount(2);
        AssertJUnit.assertEquals((Object)this.store.loadEntry((Object)KEY1).getValue(), (Object)VAL2);
        AssertJUnit.assertEquals((Object)this.store.loadEntry((Object)KEY2).getValue(), (Object)VAL1);
    }

    @Test
    public void testTxRollback() throws Exception {
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache);
        tm.begin();
        Transaction tx = tm.getTransaction();
        this.cache.put((Object)KEY1, (Object)VAL1);
        this.cache.put((Object)KEY2, (Object)VAL2);
        tm.rollback();
        assert (tx.getStatus() == 4);
        this.assertRowCount(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTxRollbackOnStoreException() throws Exception {
        PersistenceManager pm = (PersistenceManager)TestingUtil.extractComponent(this.cache, PersistenceManager.class);
        PersistenceManager mockPM = (PersistenceManager)Mockito.mock(PersistenceManager.class);
        ((PersistenceManager)Mockito.doThrow((Throwable[])new Throwable[]{new PersistenceException()}).when((Object)mockPM)).prepareAllTxStores((Transaction)Matchers.any(), (BatchModification)Matchers.any(), (Predicate)Matchers.any());
        TestingUtil.replaceComponent(this.cache, PersistenceManager.class, (Object)mockPM, (boolean)true);
        try {
            TransactionManager tm = TestingUtil.getTransactionManager(this.cache);
            tm.begin();
            Transaction tx = tm.getTransaction();
            this.cache.put((Object)KEY1, (Object)VAL1);
            this.cache.put((Object)KEY2, (Object)VAL2);
            Throwable throwable = Exceptions.extractException(() -> ((TransactionManager)tm).commit());
            Exceptions.assertException(RollbackException.class, (Throwable)throwable);
            Exceptions.assertException(XAException.class, PersistenceException.class, (Throwable)throwable.getSuppressed()[0]);
            AssertJUnit.assertEquals((int)4, (int)tx.getStatus());
            this.assertRowCount(0);
        }
        finally {
            pm.stop();
            this.store = null;
        }
    }

    private void assertRowCount(int rowCount) {
        ConnectionFactory connectionFactory = this.store.getConnectionFactory();
        TableName tableName = this.store.getTableManager(this.cache.getName()).getTableName();
        int value = UnitTestDatabaseManager.rowCount(connectionFactory, tableName);
        assert (value == rowCount) : "Expected " + rowCount + " rows, actual value is " + value;
    }

    public void testSizeWithEntryInContext() throws Exception {
        this.cache.put((Object)KEY1, (Object)VAL1);
        AssertJUnit.assertEquals((int)1, (int)this.cache.size());
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache);
        TestingUtil.withTx((TransactionManager)tm, () -> {
            this.cache.put((Object)KEY2, (Object)VAL2);
            AssertJUnit.assertEquals((int)2, (int)this.cache.size());
            return null;
        });
    }
}

