/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import java.nio.file.Paths;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.serializer.AbstractConfigurationSerializerTest;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(testName="persistence.jdbc.configuration.ConfigurationSerializerTest", groups={"functional"})
public class ConfigurationSerializerTest
extends AbstractConfigurationSerializerTest {
    @DataProvider(name="configurationFiles")
    public Object[][] configurationFiles() {
        return new Object[][]{{Paths.get("configs/string-based.xml", new String[0])}, {Paths.get("configs/string-based-jndi.xml", new String[0])}};
    }

    protected void compareStoreConfiguration(String name, StoreConfiguration beforeStore, StoreConfiguration afterStore) {
        AbstractJdbcStoreConfiguration after;
        AbstractJdbcStoreConfiguration before;
        if (beforeStore instanceof AbstractJdbcStoreConfiguration) {
            before = (AbstractJdbcStoreConfiguration)beforeStore;
            after = (AbstractJdbcStoreConfiguration)afterStore;
            AssertJUnit.assertEquals((String)("Configuration " + name + " JDBC connection factory"), (Object)before.connectionFactory(), (Object)after.connectionFactory());
        }
        if (beforeStore instanceof JdbcStringBasedStoreConfiguration) {
            before = (JdbcStringBasedStoreConfiguration)beforeStore;
            after = (JdbcStringBasedStoreConfiguration)afterStore;
            this.compareAttributeSets("Configuration " + name + " table", before.table().attributes(), after.table().attributes(), new String[0]);
        }
        super.compareStoreConfiguration(name, beforeStore, afterStore);
    }
}

